/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

public enum BorderStyle {
    NONE(0),
    THIN(1),
    MEDIUM(2),
    DASHED(3),
    DOTTED(4),
    THICK(5),
    DOUBLE(6),
    HAIR(7),
    MEDIUM_DASHED(8),
    DASH_DOT(9),
    MEDIUM_DASH_DOT(10),
    DASH_DOT_DOT(11),
    MEDIUM_DASH_DOT_DOT(12),
    SLANTED_DASH_DOT(13);

    private final short code;
    private static final BorderStyle[] _table;

    static {
        _table = new BorderStyle[14];
        BorderStyle[] borderStyleArray = BorderStyle.values();
        int n = borderStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            BorderStyle c;
            BorderStyle._table[c.getCode()] = c = borderStyleArray[n2];
            ++n2;
        }
    }

    private BorderStyle(int code) {
        this.code = (short)code;
    }

    public short getCode() {
        return this.code;
    }

    public static BorderStyle valueOf(String string) {
        return Enum.valueOf(BorderStyle.class, string);
    }
}

