/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AVTPart;
import org.apache.xalan.templates.AVTPartSimple;
import org.apache.xalan.templates.AVTPartXPath;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.XSLTVisitable;
import org.apache.xalan.templates.XSLTVisitor;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class AVT
implements Serializable,
XSLTVisitable {
    static final long serialVersionUID = 5167607155517042691L;
    private static final boolean USE_OBJECT_POOL = false;
    private static final int INIT_BUFFER_CHUNK_BITS = 8;
    private String m_simpleString;
    private Vector m_parts;
    private String m_rawName;
    private String m_name;
    private String m_uri;

    public String getRawName() {
        return this.m_rawName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void setURI(String uri) {
        this.m_uri = uri;
    }

    public AVT(StylesheetHandler handler, String uri, String name, String rawName, String stringedValue, ElemTemplateElement owner) throws TransformerException {
        block32: {
            int nTokens;
            StringTokenizer tokenizer;
            block33: {
                this.m_simpleString = null;
                this.m_parts = null;
                this.m_uri = uri;
                this.m_name = name;
                this.m_rawName = rawName;
                tokenizer = new StringTokenizer(stringedValue, "{}\"'", true);
                nTokens = tokenizer.countTokens();
                if (nTokens >= 2) break block33;
                this.m_simpleString = stringedValue;
                break block32;
            }
            FastStringBuffer buffer = null;
            FastStringBuffer exprBuffer = null;
            buffer = new FastStringBuffer(6);
            exprBuffer = new FastStringBuffer(6);
            try {
                this.m_parts = new Vector(nTokens + 1);
                String t = null;
                String lookahead = null;
                String error = null;
                while (tokenizer.hasMoreTokens()) {
                    block31: {
                        block34: {
                            if (lookahead != null) {
                                t = lookahead;
                                lookahead = null;
                            } else {
                                t = tokenizer.nextToken();
                            }
                            if (t.length() != 1) break block34;
                            switch (t.charAt(0)) {
                                case '\"': 
                                case '\'': {
                                    buffer.append(t);
                                    break;
                                }
                                case '{': {
                                    try {
                                        lookahead = tokenizer.nextToken();
                                        if (lookahead.equals("{")) {
                                            buffer.append(lookahead);
                                            lookahead = null;
                                            break;
                                        }
                                        if (buffer.length() > 0) {
                                            this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                                            buffer.setLength(0);
                                        }
                                        exprBuffer.setLength(0);
                                        while (lookahead != null) {
                                            if (lookahead.length() == 1) {
                                                switch (lookahead.charAt(0)) {
                                                    case '\"': 
                                                    case '\'': {
                                                        exprBuffer.append(lookahead);
                                                        String quote = lookahead;
                                                        lookahead = tokenizer.nextToken();
                                                        while (!lookahead.equals(quote)) {
                                                            exprBuffer.append(lookahead);
                                                            lookahead = tokenizer.nextToken();
                                                        }
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                        break;
                                                    }
                                                    case '{': {
                                                        error = XSLMessages.createMessage("ER_NO_CURLYBRACE", null);
                                                        lookahead = null;
                                                        break;
                                                    }
                                                    case '}': {
                                                        buffer.setLength(0);
                                                        XPath xpath = handler.createXPath(exprBuffer.toString(), owner);
                                                        this.m_parts.addElement(new AVTPartXPath(xpath));
                                                        lookahead = null;
                                                        break;
                                                    }
                                                    default: {
                                                        exprBuffer.append(lookahead);
                                                        lookahead = tokenizer.nextToken();
                                                        break;
                                                    }
                                                }
                                                continue;
                                            }
                                            exprBuffer.append(lookahead);
                                            lookahead = tokenizer.nextToken();
                                        }
                                        if (error != null) {
                                            // empty if block
                                        }
                                        break block31;
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        error = XSLMessages.createMessage("ER_ILLEGAL_ATTRIBUTE_VALUE", new Object[]{name, stringedValue});
                                    }
                                    break block31;
                                }
                                case '}': {
                                    lookahead = tokenizer.nextToken();
                                    if (lookahead.equals("}")) {
                                        buffer.append(lookahead);
                                        lookahead = null;
                                        break;
                                    }
                                    try {
                                        handler.warn("WG_FOUND_CURLYBRACE", null);
                                    }
                                    catch (SAXException se) {
                                        throw new TransformerException(se);
                                    }
                                    buffer.append("}");
                                    break;
                                }
                                default: {
                                    buffer.append(t);
                                    break;
                                }
                            }
                            break block31;
                        }
                        buffer.append(t);
                    }
                    if (error == null) continue;
                    try {
                        handler.warn("WG_ATTR_TEMPLATE", new Object[]{error});
                        break;
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                }
                if (buffer.length() > 0) {
                    this.m_parts.addElement(new AVTPartSimple(buffer.toString()));
                    buffer.setLength(0);
                }
            }
            finally {
                buffer = null;
                exprBuffer = null;
            }
        }
        if (this.m_parts == null && this.m_simpleString == null) {
            this.m_simpleString = "";
        }
    }

    public String getSimpleString() {
        if (this.m_simpleString != null) {
            return this.m_simpleString;
        }
        if (this.m_parts != null) {
            FastStringBuffer buf = this.getBuffer();
            String out = null;
            int n = this.m_parts.size();
            try {
                int i = 0;
                while (i < n) {
                    AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                    buf.append(part.getSimpleString());
                    ++i;
                }
                out = buf.toString();
            }
            finally {
                buf.setLength(0);
            }
            return out;
        }
        return "";
    }

    public String evaluate(XPathContext xctxt, int context, PrefixResolver nsNode) throws TransformerException {
        if (this.m_simpleString != null) {
            return this.m_simpleString;
        }
        if (this.m_parts != null) {
            FastStringBuffer buf = this.getBuffer();
            String out = null;
            int n = this.m_parts.size();
            try {
                int i = 0;
                while (i < n) {
                    AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                    part.evaluate(xctxt, buf, context, nsNode);
                    ++i;
                }
                out = buf.toString();
            }
            finally {
                buf.setLength(0);
            }
            return out;
        }
        return "";
    }

    public boolean isContextInsensitive() {
        return this.m_simpleString != null;
    }

    public boolean canTraverseOutsideSubtree() {
        if (this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                if (part.canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        if (this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.fixupVariables(vars, globalsSize);
                ++i;
            }
        }
    }

    @Override
    public void callVisitors(XSLTVisitor visitor) {
        if (visitor.visitAVT(this) && this.m_parts != null) {
            int n = this.m_parts.size();
            int i = 0;
            while (i < n) {
                AVTPart part = (AVTPart)this.m_parts.elementAt(i);
                part.callVisitors(visitor);
                ++i;
            }
        }
    }

    public boolean isSimple() {
        return this.m_simpleString != null;
    }

    private final FastStringBuffer getBuffer() {
        return new FastStringBuffer(8);
    }
}

