/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    static final long serialVersionUID = -6670449967116905820L;
    private StepPattern[] m_patterns;

    @Override
    public void fixupVariables(Vector vars, int globalsSize) {
        int i = 0;
        while (i < this.m_patterns.length) {
            this.m_patterns[i].fixupVariables(vars, globalsSize);
            ++i;
        }
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (this.m_patterns != null) {
            int n = this.m_patterns.length;
            int i = 0;
            while (i < n) {
                if (this.m_patterns[i].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
        if (patterns != null) {
            int i = 0;
            while (i < patterns.length) {
                patterns[i].exprSetParent(this);
                ++i;
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        int n = this.m_patterns.length;
        int i = 0;
        while (i < n) {
            XObject score = this.m_patterns[i].execute(xctxt);
            if (score != NodeTest.SCORE_NONE) {
                if (bestScore == null) {
                    bestScore = score;
                } else if (score.num() > bestScore.num()) {
                    bestScore = score;
                }
            }
            ++i;
        }
        if (bestScore == null) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    @Override
    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        visitor.visitUnionPattern(owner, this);
        if (this.m_patterns != null) {
            int n = this.m_patterns.length;
            int i = 0;
            while (i < n) {
                this.m_patterns[i].callVisitors(new UnionPathPartOwner(i), visitor);
                ++i;
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (this.m_patterns != null) {
            int n = this.m_patterns.length;
            if (up.m_patterns == null || up.m_patterns.length != n) {
                return false;
            }
            int i = 0;
            while (i < n) {
                if (!this.m_patterns[i].deepEquals(up.m_patterns[i])) {
                    return false;
                }
                ++i;
            }
        } else if (up.m_patterns != null) {
            return false;
        }
        return true;
    }

    class UnionPathPartOwner
    implements ExpressionOwner {
        int m_index;

        UnionPathPartOwner(int index) {
            this.m_index = index;
        }

        @Override
        public Expression getExpression() {
            return UnionPattern.this.m_patterns[this.m_index];
        }

        @Override
        public void setExpression(Expression exp) {
            exp.exprSetParent(UnionPattern.this);
            UnionPattern.this.m_patterns[this.m_index] = (StepPattern)exp;
        }
    }
}

