/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.xerces.impl.XML11EntityScanner;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.io.ASCIIReader;
import org.apache.xerces.impl.io.Latin1Reader;
import org.apache.xerces.impl.io.UCSReader;
import org.apache.xerces.impl.io.UTF16Reader;
import org.apache.xerces.impl.io.UTF8Reader;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.HTTPInputSource;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLEntityDescriptionImpl;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLEntityManager
implements XMLComponent,
XMLEntityResolver {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 512;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected static final String STANDARD_URI_CONFORMANT = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String BUFFER_SIZE = "http://apache.org/xml/properties/input-buffer-size";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/warn-on-duplicate-entitydef", "http://apache.org/xml/features/standard-uri-conformant"};
    private static final Boolean[] FEATURE_DEFAULTS;
    private static final String[] RECOGNIZED_PROPERTIES;
    private static final Object[] PROPERTY_DEFAULTS;
    private static final String XMLEntity;
    private static final String DTDEntity;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_ENTITIES = false;
    private static final boolean DEBUG_ENCODINGS = false;
    private static final boolean DEBUG_RESOLVER = false;
    protected boolean fValidation;
    protected boolean fExternalGeneralEntities = true;
    protected boolean fExternalParameterEntities = true;
    protected boolean fAllowJavaEncodings;
    protected boolean fWarnDuplicateEntityDef;
    protected boolean fStrictURI;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager;
    protected int fBufferSize = 2048;
    protected SecurityManager fSecurityManager = null;
    protected boolean fStandalone;
    protected boolean fHasPEReferences;
    protected boolean fInExternalSubset = false;
    protected XMLEntityHandler fEntityHandler;
    protected XMLEntityScanner fEntityScanner;
    protected XMLEntityScanner fXML10EntityScanner;
    protected XMLEntityScanner fXML11EntityScanner;
    protected int fEntityExpansionLimit = 0;
    protected int fEntityExpansionCount = 0;
    protected final Hashtable fEntities = new Hashtable();
    protected final Stack fEntityStack = new Stack();
    protected ScannedEntity fCurrentEntity;
    protected Hashtable fDeclaredEntities;
    private final XMLResourceIdentifierImpl fResourceIdentifier = new XMLResourceIdentifierImpl();
    private final Augmentations fEntityAugs = new AugmentationsImpl();
    private final ByteBufferPool fSmallByteBufferPool = new ByteBufferPool(this.fBufferSize);
    private final ByteBufferPool fLargeByteBufferPool = new ByteBufferPool(this.fBufferSize << 1);
    private byte[] fTempByteBuffer = null;
    private final CharacterBufferPool fCharacterBufferPool = new CharacterBufferPool(this.fBufferSize, 512);
    protected Stack fReaderStack = new Stack();
    private static String gUserDir;
    private static URI gUserDirURI;
    private static final boolean[] gNeedEscaping;
    private static final char[] gAfterEscaping1;
    private static final char[] gAfterEscaping2;
    private static final char[] gHexChs;
    private static PrivilegedAction GET_USER_DIR_SYSTEM_PROPERTY;

    static {
        Boolean[] booleanArray = new Boolean[6];
        booleanArray[1] = Boolean.TRUE;
        booleanArray[2] = Boolean.TRUE;
        booleanArray[3] = Boolean.FALSE;
        booleanArray[4] = Boolean.FALSE;
        booleanArray[5] = Boolean.FALSE;
        FEATURE_DEFAULTS = booleanArray;
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ENTITY_RESOLVER, VALIDATION_MANAGER, BUFFER_SIZE, SECURITY_MANAGER};
        Object[] objectArray = new Object[6];
        objectArray[4] = new Integer(2048);
        PROPERTY_DEFAULTS = objectArray;
        XMLEntity = "[xml]".intern();
        DTDEntity = "[dtd]".intern();
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = 0;
        while (i <= 31) {
            XMLEntityManager.gNeedEscaping[i] = true;
            XMLEntityManager.gAfterEscaping1[i] = gHexChs[i >> 4];
            XMLEntityManager.gAfterEscaping2[i] = gHexChs[i & 0xF];
            ++i;
        }
        XMLEntityManager.gNeedEscaping[127] = true;
        XMLEntityManager.gAfterEscaping1[127] = 55;
        XMLEntityManager.gAfterEscaping2[127] = 70;
        char[] escChs = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int len = escChs.length;
        int i2 = 0;
        while (i2 < len) {
            char ch = escChs[i2];
            XMLEntityManager.gNeedEscaping[ch] = true;
            XMLEntityManager.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            XMLEntityManager.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
            ++i2;
        }
        GET_USER_DIR_SYSTEM_PROPERTY = new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        };
    }

    public XMLEntityManager() {
        this(null);
    }

    public XMLEntityManager(XMLEntityManager entityManager) {
        this.fDeclaredEntities = entityManager != null ? entityManager.getDeclaredEntities() : null;
        this.setScannerVersion((short)1);
    }

    public void setStandalone(boolean standalone) {
        this.fStandalone = standalone;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    final void notifyHasPEReferences() {
        this.fHasPEReferences = true;
    }

    final boolean hasPEReferences() {
        return this.fHasPEReferences;
    }

    public void setEntityHandler(XMLEntityHandler entityHandler) {
        this.fEntityHandler = entityHandler;
    }

    public XMLResourceIdentifier getCurrentResourceIdentifier() {
        return this.fResourceIdentifier;
    }

    public ScannedEntity getCurrentEntity() {
        return this.fCurrentEntity;
    }

    public void addInternalEntity(String name, String text, int paramEntityRefs) {
        if (!this.fEntities.containsKey(name)) {
            InternalEntity entity = new InternalEntity(name, text, this.fInExternalSubset, paramEntityRefs);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public void addInternalEntity(String name, String text) {
        this.addInternalEntity(name, text, 0);
    }

    public int getParamEntityRefCount(String entityName) {
        Entity entity;
        if (entityName != null && entityName.length() > 0 && entityName.charAt(0) == '%' && (entity = (Entity)this.fEntities.get(entityName)) != null && !entity.isExternal()) {
            return ((InternalEntity)entity).paramEntityRefs;
        }
        return 0;
    }

    public void addExternalEntity(String name, String publicId, String literalSystemId, String baseSystemId) throws IOException {
        if (!this.fEntities.containsKey(name)) {
            if (baseSystemId == null) {
                int size = this.fEntityStack.size();
                if (size == 0 && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                    baseSystemId = this.fCurrentEntity.entityLocation.getExpandedSystemId();
                }
                int i = size - 1;
                while (i >= 0) {
                    ScannedEntity externalEntity = (ScannedEntity)this.fEntityStack.elementAt(i);
                    if (externalEntity.entityLocation != null && externalEntity.entityLocation.getExpandedSystemId() != null) {
                        baseSystemId = externalEntity.entityLocation.getExpandedSystemId();
                        break;
                    }
                    --i;
                }
            }
            ExternalEntity entity = new ExternalEntity(name, new XMLEntityDescriptionImpl(name, publicId, literalSystemId, baseSystemId, XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, false)), null, this.fInExternalSubset);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isExternalEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isEntityDeclInExternalSubset(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public void addUnparsedEntity(String name, String publicId, String systemId, String baseSystemId, String notation) {
        if (!this.fEntities.containsKey(name)) {
            ExternalEntity entity = new ExternalEntity(name, new XMLEntityDescriptionImpl(name, publicId, systemId, baseSystemId, null), notation, this.fInExternalSubset);
            this.fEntities.put(name, entity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{name}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String entityName) {
        Entity entity = (Entity)this.fEntities.get(entityName);
        return entity != null;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        boolean needExpand;
        if (resourceIdentifier == null) {
            return null;
        }
        String publicId = resourceIdentifier.getPublicId();
        String literalSystemId = resourceIdentifier.getLiteralSystemId();
        String baseSystemId = resourceIdentifier.getBaseSystemId();
        String expandedSystemId = resourceIdentifier.getExpandedSystemId();
        boolean bl = needExpand = expandedSystemId == null;
        if (baseSystemId == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null && (baseSystemId = this.fCurrentEntity.entityLocation.getExpandedSystemId()) != null) {
            needExpand = true;
        }
        XMLInputSource xmlInputSource = null;
        if (this.fEntityResolver != null) {
            if (needExpand) {
                expandedSystemId = XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, false);
            }
            resourceIdentifier.setBaseSystemId(baseSystemId);
            resourceIdentifier.setExpandedSystemId(expandedSystemId);
            xmlInputSource = this.fEntityResolver.resolveEntity(resourceIdentifier);
        }
        if (xmlInputSource == null) {
            xmlInputSource = new XMLInputSource(publicId, literalSystemId, baseSystemId);
        }
        return xmlInputSource;
    }

    public void startEntity(String entityName, boolean literal) throws IOException, XNIException {
        int size;
        Entity entity = (Entity)this.fEntities.get(entityName);
        if (entity == null) {
            if (this.fEntityHandler != null) {
                String encoding = null;
                this.fResourceIdentifier.clear();
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                this.fEntityAugs.removeAllItems();
                this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
            }
            return;
        }
        boolean external = entity.isExternal();
        if (external && (this.fValidationManager == null || !this.fValidationManager.isCachedDTD())) {
            boolean general;
            boolean unparsed = entity.isUnparsed();
            boolean parameter = entityName.startsWith("%");
            boolean bl = general = !parameter;
            if (unparsed || general && !this.fExternalGeneralEntities || parameter && !this.fExternalParameterEntities) {
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String encoding = null;
                    ExternalEntity externalEntity = (ExternalEntity)entity;
                    String extLitSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                    String extBaseSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                    String expandedSystemId = XMLEntityManager.expandSystemId(extLitSysId, extBaseSysId, false);
                    this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, extLitSysId, extBaseSysId, expandedSystemId);
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
                }
                return;
            }
        }
        int i = size = this.fEntityStack.size();
        while (i >= 0) {
            Entity activeEntity;
            Entity entity2 = activeEntity = i == size ? this.fCurrentEntity : (Entity)this.fEntityStack.elementAt(i);
            if (activeEntity.name == entityName) {
                StringBuffer path = new StringBuffer(entityName);
                int j = i + 1;
                while (j < size) {
                    activeEntity = (Entity)this.fEntityStack.elementAt(j);
                    path.append(" -> ");
                    path.append(activeEntity.name);
                    ++j;
                }
                path.append(" -> ");
                path.append(this.fCurrentEntity.name);
                path.append(" -> ");
                path.append(entityName);
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "RecursiveReference", new Object[]{entityName, path.toString()}, (short)2);
                if (this.fEntityHandler != null) {
                    this.fResourceIdentifier.clear();
                    String encoding = null;
                    if (external) {
                        ExternalEntity externalEntity = (ExternalEntity)entity;
                        String extLitSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getLiteralSystemId() : null;
                        String extBaseSysId = externalEntity.entityLocation != null ? externalEntity.entityLocation.getBaseSystemId() : null;
                        String expandedSystemId = XMLEntityManager.expandSystemId(extLitSysId, extBaseSysId, false);
                        this.fResourceIdentifier.setValues(externalEntity.entityLocation != null ? externalEntity.entityLocation.getPublicId() : null, extLitSysId, extBaseSysId, expandedSystemId);
                    }
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.startEntity(entityName, this.fResourceIdentifier, encoding, this.fEntityAugs);
                    this.fEntityAugs.removeAllItems();
                    this.fEntityAugs.putItem("ENTITY_SKIPPED", Boolean.TRUE);
                    this.fEntityHandler.endEntity(entityName, this.fEntityAugs);
                }
                return;
            }
            --i;
        }
        XMLInputSource xmlInputSource = null;
        if (external) {
            ExternalEntity externalEntity = (ExternalEntity)entity;
            xmlInputSource = this.resolveEntity(externalEntity.entityLocation);
        } else {
            InternalEntity internalEntity = (InternalEntity)entity;
            StringReader reader = new StringReader(internalEntity.text);
            xmlInputSource = new XMLInputSource(null, null, null, reader, null);
        }
        this.startEntity(entityName, xmlInputSource, literal, external);
    }

    public void startDocumentEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        this.startEntity(XMLEntity, xmlInputSource, false, true);
    }

    public void startDTDEntity(XMLInputSource xmlInputSource) throws IOException, XNIException {
        this.startEntity(DTDEntity, xmlInputSource, false, true);
    }

    public void startExternalSubset() {
        this.fInExternalSubset = true;
    }

    public void endExternalSubset() {
        this.fInExternalSubset = false;
    }

    public void startEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        String encoding = this.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
        if (this.fSecurityManager != null) {
            this.fEntityExpansionCount += this.getParamEntityRefCount(name);
            if (this.fEntityExpansionCount++ > this.fEntityExpansionLimit) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EntityExpansionLimitExceeded", new Object[]{new Integer(this.fEntityExpansionLimit)}, (short)2);
                this.fEntityExpansionCount = 0;
            }
        }
        if (this.fEntityHandler != null) {
            this.fEntityHandler.startEntity(name, this.fResourceIdentifier, encoding, null);
        }
    }

    public String setupCurrentEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        String publicId = xmlInputSource.getPublicId();
        String literalSystemId = xmlInputSource.getSystemId();
        String baseSystemId = xmlInputSource.getBaseSystemId();
        String encoding = xmlInputSource.getEncoding();
        boolean encodingExternallySpecified = encoding != null;
        Boolean isBigEndian = null;
        this.fTempByteBuffer = null;
        InputStream stream = null;
        Reader reader = xmlInputSource.getCharacterStream();
        String expandedSystemId = XMLEntityManager.expandSystemId(literalSystemId, baseSystemId, this.fStrictURI);
        if (baseSystemId == null) {
            baseSystemId = expandedSystemId;
        }
        if (reader == null) {
            stream = xmlInputSource.getByteStream();
            if (stream == null) {
                URL location = new URL(expandedSystemId);
                URLConnection connect = location.openConnection();
                if (!(connect instanceof HttpURLConnection)) {
                    stream = connect.getInputStream();
                } else {
                    String redirect;
                    boolean followRedirects = true;
                    if (xmlInputSource instanceof HTTPInputSource) {
                        HttpURLConnection urlConnection = (HttpURLConnection)connect;
                        HTTPInputSource httpInputSource = (HTTPInputSource)xmlInputSource;
                        Iterator propIter = httpInputSource.getHTTPRequestProperties();
                        while (propIter.hasNext()) {
                            Map.Entry entry = (Map.Entry)propIter.next();
                            urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        followRedirects = httpInputSource.getFollowHTTPRedirects();
                        if (!followRedirects) {
                            urlConnection.setInstanceFollowRedirects(followRedirects);
                        }
                    }
                    stream = connect.getInputStream();
                    if (followRedirects && !(redirect = connect.getURL().toString()).equals(expandedSystemId)) {
                        literalSystemId = redirect;
                        expandedSystemId = redirect;
                    }
                }
            }
            RewindableInputStream rewindableStream = new RewindableInputStream(stream);
            stream = rewindableStream;
            if (encoding == null) {
                b4 = new byte[4];
                count = 0;
                while (count < 4) {
                    b4[count] = (byte)rewindableStream.readAndBuffer();
                    ++count;
                }
                if (count == 4) {
                    EncodingInfo info = this.getEncodingInfo((byte[])b4, count);
                    encoding = info.autoDetectedEncoding;
                    String readerEncoding = info.readerEncoding;
                    isBigEndian = info.isBigEndian;
                    stream.reset();
                    if (info.hasBOM) {
                        if (readerEncoding == "UTF-8") {
                            stream.skip(3L);
                        } else if (readerEncoding == "UTF-16") {
                            stream.skip(2L);
                        }
                    }
                    reader = this.createReader(stream, readerEncoding, isBigEndian);
                } else {
                    reader = this.createReader(stream, encoding, isBigEndian);
                }
            } else if ((encoding = encoding.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
                int[] b3 = new int[3];
                count = 0;
                while (count < 3) {
                    b3[count] = rewindableStream.readAndBuffer();
                    if (b3[count] == -1) break;
                    ++count;
                }
                if (count == 3) {
                    if (b3[0] != 239 || b3[1] != 187 || b3[2] != 191) {
                        stream.reset();
                    }
                } else {
                    stream.reset();
                }
                reader = this.createReader(stream, "UTF-8", isBigEndian);
            } else if (encoding.equals("UTF-16")) {
                b4 = new int[4];
                count = 0;
                while (count < 4) {
                    b4[count] = rewindableStream.readAndBuffer();
                    if (b4[count] == -1) break;
                    ++count;
                }
                stream.reset();
                if (count >= 2) {
                    byte b0 = b4[0];
                    byte b1 = b4[1];
                    if (b0 == 254 && b1 == 255) {
                        isBigEndian = Boolean.TRUE;
                        stream.skip(2L);
                    } else if (b0 == 255 && b1 == 254) {
                        isBigEndian = Boolean.FALSE;
                        stream.skip(2L);
                    } else if (count == 4) {
                        byte b2 = b4[2];
                        byte b3 = b4[3];
                        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
                            isBigEndian = Boolean.TRUE;
                        }
                        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
                            isBigEndian = Boolean.FALSE;
                        }
                    }
                }
                reader = this.createReader(stream, "UTF-16", isBigEndian);
            } else if (encoding.equals("ISO-10646-UCS-4")) {
                b4 = new int[4];
                count = 0;
                while (count < 4) {
                    b4[count] = rewindableStream.readAndBuffer();
                    if (b4[count] == -1) break;
                    ++count;
                }
                stream.reset();
                if (count == 4) {
                    if (b4[0] == 0 && b4[1] == 0 && b4[2] == 0 && b4[3] == 60) {
                        isBigEndian = Boolean.TRUE;
                    } else if (b4[0] == 60 && b4[1] == 0 && b4[2] == 0 && b4[3] == 0) {
                        isBigEndian = Boolean.FALSE;
                    }
                }
                reader = this.createReader(stream, encoding, isBigEndian);
            } else if (encoding.equals("ISO-10646-UCS-2")) {
                b4 = new int[4];
                count = 0;
                while (count < 4) {
                    b4[count] = rewindableStream.readAndBuffer();
                    if (b4[count] == -1) break;
                    ++count;
                }
                stream.reset();
                if (count == 4) {
                    if (b4[0] == 0 && b4[1] == 60 && b4[2] == 0 && b4[3] == 63) {
                        isBigEndian = Boolean.TRUE;
                    } else if (b4[0] == 60 && b4[1] == 0 && b4[2] == 63 && b4[3] == 0) {
                        isBigEndian = Boolean.FALSE;
                    }
                }
                reader = this.createReader(stream, encoding, isBigEndian);
            } else {
                reader = this.createReader(stream, encoding, isBigEndian);
            }
        }
        this.fReaderStack.push(reader);
        if (this.fCurrentEntity != null) {
            this.fEntityStack.push(this.fCurrentEntity);
        }
        this.fCurrentEntity = new ScannedEntity(name, new XMLResourceIdentifierImpl(publicId, literalSystemId, baseSystemId, expandedSystemId), stream, reader, this.fTempByteBuffer, encoding, literal, false, isExternal);
        this.fCurrentEntity.setEncodingExternallySpecified(encodingExternallySpecified);
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        this.fResourceIdentifier.setValues(publicId, literalSystemId, baseSystemId, expandedSystemId);
        return encoding;
    }

    public void setScannerVersion(short version) {
        if (version == 1) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
            }
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML10EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        } else {
            if (this.fXML11EntityScanner == null) {
                this.fXML11EntityScanner = new XML11EntityScanner();
            }
            this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML11EntityScanner;
            this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
        }
    }

    public XMLEntityScanner getEntityScanner() {
        if (this.fEntityScanner == null) {
            if (this.fXML10EntityScanner == null) {
                this.fXML10EntityScanner = new XMLEntityScanner();
            }
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
            this.fEntityScanner = this.fXML10EntityScanner;
        }
        return this.fEntityScanner;
    }

    public void closeReaders() {
        int i = this.fReaderStack.size() - 1;
        while (i >= 0) {
            try {
                ((Reader)this.fReaderStack.pop()).close();
            }
            catch (IOException iOException) {}
            --i;
        }
    }

    @Override
    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        boolean parser_settings;
        try {
            parser_settings = componentManager.getFeature(PARSER_SETTINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            parser_settings = true;
        }
        if (!parser_settings) {
            this.reset();
            return;
        }
        try {
            this.fValidation = componentManager.getFeature(VALIDATION);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidation = false;
        }
        try {
            this.fExternalGeneralEntities = componentManager.getFeature(EXTERNAL_GENERAL_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalGeneralEntities = true;
        }
        try {
            this.fExternalParameterEntities = componentManager.getFeature(EXTERNAL_PARAMETER_ENTITIES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fExternalParameterEntities = true;
        }
        try {
            this.fAllowJavaEncodings = componentManager.getFeature(ALLOW_JAVA_ENCODINGS);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fAllowJavaEncodings = false;
        }
        try {
            this.fWarnDuplicateEntityDef = componentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateEntityDef = false;
        }
        try {
            this.fStrictURI = componentManager.getFeature(STANDARD_URI_CONFORMANT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fStrictURI = false;
        }
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        try {
            this.fEntityResolver = (XMLEntityResolver)componentManager.getProperty(ENTITY_RESOLVER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        try {
            this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fValidationManager = null;
        }
        try {
            this.fSecurityManager = (SecurityManager)componentManager.getProperty(SECURITY_MANAGER);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSecurityManager = null;
        }
        this.reset();
    }

    public void reset() {
        this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
        this.fStandalone = false;
        this.fHasPEReferences = false;
        this.fEntities.clear();
        this.fEntityStack.removeAllElements();
        this.fEntityExpansionCount = 0;
        this.fCurrentEntity = null;
        if (this.fXML10EntityScanner != null) {
            this.fXML10EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fXML11EntityScanner != null) {
            this.fXML11EntityScanner.reset(this.fSymbolTable, this, this.fErrorReporter);
        }
        if (this.fDeclaredEntities != null) {
            for (Map.Entry entry : this.fDeclaredEntities.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.fEntities.put(key, value);
            }
        }
        this.fEntityHandler = null;
    }

    @Override
    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    @Override
    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        int suffixLength;
        if (featureId.startsWith("http://apache.org/xml/features/") && (suffixLength = featureId.length() - "http://apache.org/xml/features/".length()) == "allow-java-encodings".length() && featureId.endsWith("allow-java-encodings")) {
            this.fAllowJavaEncodings = state;
        }
    }

    @Override
    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            Integer bufferSize;
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/symbol-table".length() && propertyId.endsWith("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
                return;
            }
            if (suffixLength == "internal/error-reporter".length() && propertyId.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
                return;
            }
            if (suffixLength == "internal/entity-resolver".length() && propertyId.endsWith("internal/entity-resolver")) {
                this.fEntityResolver = (XMLEntityResolver)value;
                return;
            }
            if (suffixLength == "input-buffer-size".length() && propertyId.endsWith("input-buffer-size") && (bufferSize = (Integer)value) != null && bufferSize > 64) {
                this.fBufferSize = bufferSize;
                this.fEntityScanner.setBufferSize(this.fBufferSize);
                this.fSmallByteBufferPool.setBufferSize(this.fBufferSize);
                this.fLargeByteBufferPool.setBufferSize(this.fBufferSize << 1);
                this.fCharacterBufferPool.setExternalBufferSize(this.fBufferSize);
            }
            if (suffixLength == "security-manager".length() && propertyId.endsWith("security-manager")) {
                this.fSecurityManager = (SecurityManager)value;
                this.fEntityExpansionLimit = this.fSecurityManager != null ? this.fSecurityManager.getEntityExpansionLimit() : 0;
            }
        }
    }

    @Override
    public Boolean getFeatureDefault(String featureId) {
        int i = 0;
        while (i < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[i].equals(featureId)) {
                return FEATURE_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getPropertyDefault(String propertyId) {
        int i = 0;
        while (i < RECOGNIZED_PROPERTIES.length) {
            if (RECOGNIZED_PROPERTIES[i].equals(propertyId)) {
                return PROPERTY_DEFAULTS[i];
            }
            ++i;
        }
        return null;
    }

    private static synchronized URI getUserDir() throws URI.MalformedURIException {
        int ch;
        String userDir = "";
        try {
            userDir = (String)AccessController.doPrivileged(GET_USER_DIR_SYSTEM_PROPERTY);
        }
        catch (SecurityException securityException) {}
        if (userDir.length() == 0) {
            return new URI("file", "", "", null, null);
        }
        if (gUserDirURI != null && userDir.equals(gUserDir)) {
            return gUserDirURI;
        }
        gUserDir = userDir;
        char separator = File.separatorChar;
        userDir = userDir.replace(separator, '/');
        int len = userDir.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        if (len >= 2 && userDir.charAt(1) == ':' && (ch = Character.toUpperCase(userDir.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        int i = 0;
        while (i < len) {
            ch = userDir.charAt(i);
            if (ch >= 128) break;
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
            } else {
                buffer.append((char)ch);
            }
            ++i;
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = userDir.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new URI("file", "", userDir, null, null);
            }
            len = bytes.length;
            i = 0;
            while (i < len) {
                byte b = bytes[i];
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                } else if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                } else {
                    buffer.append((char)b);
                }
                ++i;
            }
        }
        if (!userDir.endsWith("/")) {
            buffer.append('/');
        }
        gUserDirURI = new URI("file", "", buffer.toString(), null, null);
        return gUserDirURI;
    }

    public static void absolutizeAgainstUserDir(URI uri) throws URI.MalformedURIException {
        uri.absolutize(XMLEntityManager.getUserDir());
    }

    public static String expandSystemId(String systemId, String baseSystemId, boolean strict) throws URI.MalformedURIException {
        if (systemId == null) {
            return null;
        }
        if (strict) {
            return XMLEntityManager.expandSystemIdStrictOn(systemId, baseSystemId);
        }
        try {
            return XMLEntityManager.expandSystemIdStrictOff(systemId, baseSystemId);
        }
        catch (URI.MalformedURIException malformedURIException) {
            if (systemId.length() == 0) {
                return systemId;
            }
            String id = XMLEntityManager.fixURI(systemId);
            URI base = null;
            URI uri = null;
            try {
                if (baseSystemId == null || baseSystemId.length() == 0 || baseSystemId.equals(systemId)) {
                    base = XMLEntityManager.getUserDir();
                } else {
                    try {
                        base = new URI(XMLEntityManager.fixURI(baseSystemId).trim());
                    }
                    catch (URI.MalformedURIException malformedURIException2) {
                        base = baseSystemId.indexOf(58) != -1 ? new URI("file", "", XMLEntityManager.fixURI(baseSystemId).trim(), null, null) : new URI(XMLEntityManager.getUserDir(), XMLEntityManager.fixURI(baseSystemId));
                    }
                }
                uri = new URI(base, id.trim());
            }
            catch (Exception exception) {}
            if (uri == null) {
                return systemId;
            }
            return uri.toString();
        }
    }

    private static String expandSystemIdStrictOn(String systemId, String baseSystemId) throws URI.MalformedURIException {
        URI systemURI = new URI(systemId, true);
        if (systemURI.isAbsoluteURI()) {
            return systemId;
        }
        URI baseURI = null;
        if (baseSystemId == null || baseSystemId.length() == 0) {
            baseURI = XMLEntityManager.getUserDir();
        } else {
            baseURI = new URI(baseSystemId, true);
            if (!baseURI.isAbsoluteURI()) {
                baseURI.absolutize(XMLEntityManager.getUserDir());
            }
        }
        systemURI.absolutize(baseURI);
        return systemURI.toString();
    }

    private static String expandSystemIdStrictOff(String systemId, String baseSystemId) throws URI.MalformedURIException {
        URI systemURI = new URI(systemId, true);
        if (systemURI.isAbsoluteURI()) {
            if (systemURI.getScheme().length() > 1) {
                return systemId;
            }
            throw new URI.MalformedURIException();
        }
        URI baseURI = null;
        if (baseSystemId == null || baseSystemId.length() == 0) {
            baseURI = XMLEntityManager.getUserDir();
        } else {
            baseURI = new URI(baseSystemId, true);
            if (!baseURI.isAbsoluteURI()) {
                baseURI.absolutize(XMLEntityManager.getUserDir());
            }
        }
        systemURI.absolutize(baseURI);
        return systemURI.toString();
    }

    public static OutputStream createOutputStream(String uri) throws IOException {
        String expanded = XMLEntityManager.expandSystemId(uri, null, true);
        URL url = new URL(expanded != null ? expanded : uri);
        OutputStream out = null;
        String protocol = url.getProtocol();
        String host = url.getHost();
        if (protocol.equals("file") && (host == null || host.length() == 0 || host.equals("localhost"))) {
            File parent;
            File file = new File(XMLEntityManager.getPathWithoutEscapes(url.getPath()));
            if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            out = new FileOutputStream(file);
        } else {
            URLConnection urlCon = url.openConnection();
            urlCon.setDoInput(false);
            urlCon.setDoOutput(true);
            urlCon.setUseCaches(false);
            if (urlCon instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)urlCon;
                httpCon.setRequestMethod("PUT");
            }
            out = urlCon.getOutputStream();
        }
        return out;
    }

    private static String getPathWithoutEscapes(String origPath) {
        if (origPath != null && origPath.length() != 0 && origPath.indexOf(37) != -1) {
            StringTokenizer tokenizer = new StringTokenizer(origPath, "%");
            StringBuffer result = new StringBuffer(origPath.length());
            int size = tokenizer.countTokens();
            result.append(tokenizer.nextToken());
            int i = 1;
            while (i < size) {
                String token = tokenizer.nextToken();
                result.append((char)Integer.valueOf(token.substring(0, 2), 16).intValue());
                result.append(token.substring(2));
                ++i;
            }
            return result.toString();
        }
        return origPath;
    }

    void endEntity() throws XNIException {
        if (this.fEntityHandler != null) {
            this.fEntityHandler.endEntity(this.fCurrentEntity.name, null);
        }
        try {
            this.fCurrentEntity.reader.close();
        }
        catch (IOException iOException) {}
        if (!this.fReaderStack.isEmpty()) {
            this.fReaderStack.pop();
        }
        this.fCharacterBufferPool.returnBuffer(this.fCurrentEntity.fCharacterBuffer);
        if (this.fCurrentEntity.fByteBuffer != null) {
            if (this.fCurrentEntity.fByteBuffer.length == this.fBufferSize) {
                this.fSmallByteBufferPool.returnBuffer(this.fCurrentEntity.fByteBuffer);
            } else {
                this.fLargeByteBufferPool.returnBuffer(this.fCurrentEntity.fByteBuffer);
            }
        }
        this.fCurrentEntity = this.fEntityStack.size() > 0 ? (ScannedEntity)this.fEntityStack.pop() : null;
        this.fEntityScanner.setCurrentEntity(this.fCurrentEntity);
    }

    protected EncodingInfo getEncodingInfo(byte[] b4, int count) {
        if (count < 2) {
            return EncodingInfo.UTF_8;
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return EncodingInfo.UTF_16_BIG_ENDIAN_WITH_BOM;
        }
        if (b0 == 255 && b1 == 254) {
            return EncodingInfo.UTF_16_LITTLE_ENDIAN_WITH_BOM;
        }
        if (count < 3) {
            return EncodingInfo.UTF_8;
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return EncodingInfo.UTF_8_WITH_BOM;
        }
        if (count < 4) {
            return EncodingInfo.UTF_8;
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return EncodingInfo.UCS_4_BIG_ENDIAN;
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return EncodingInfo.UCS_4_LITTLE_ENDIAN;
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return EncodingInfo.UCS_4_UNUSUAL_BYTE_ORDER;
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return EncodingInfo.UCS_4_UNUSUAL_BYTE_ORDER;
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return EncodingInfo.UTF_16_BIG_ENDIAN;
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return EncodingInfo.UTF_16_LITTLE_ENDIAN;
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return EncodingInfo.EBCDIC;
        }
        return EncodingInfo.UTF_8;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Reader createReader(InputStream inputStream, String encoding, Boolean isBigEndian) throws IOException {
        if (encoding == "UTF-8") return this.createUTF8Reader(inputStream);
        if (encoding == null) {
            return this.createUTF8Reader(inputStream);
        }
        if (encoding == "UTF-16" && isBigEndian != null) {
            return this.createUTF16Reader(inputStream, isBigEndian);
        }
        String ENCODING = encoding.toUpperCase(Locale.ENGLISH);
        if (ENCODING.equals("UTF-8")) {
            return this.createUTF8Reader(inputStream);
        }
        if (ENCODING.equals("UTF-16BE")) {
            return this.createUTF16Reader(inputStream, true);
        }
        if (ENCODING.equals("UTF-16LE")) {
            return this.createUTF16Reader(inputStream, false);
        }
        if (ENCODING.equals("ISO-10646-UCS-4")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (!isBE) return new UCSReader(inputStream, 4);
                return new UCSReader(inputStream, 8);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        if (ENCODING.equals("ISO-10646-UCS-2")) {
            if (isBigEndian != null) {
                boolean isBE = isBigEndian;
                if (!isBE) return new UCSReader(inputStream, 1);
                return new UCSReader(inputStream, 2);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingByteOrderUnsupported", new Object[]{encoding}, (short)2);
        }
        boolean validIANA = XMLChar.isValidIANAEncoding(encoding);
        boolean validJava = XMLChar.isValidJavaEncoding(encoding);
        if (!validIANA || this.fAllowJavaEncodings && !validJava) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
            return this.createLatin1Reader(inputStream);
        }
        String javaEncoding = EncodingMap.getIANA2JavaMapping(ENCODING);
        if (javaEncoding == null) {
            if (this.fAllowJavaEncodings) {
                javaEncoding = encoding;
                return new InputStreamReader(inputStream, javaEncoding);
            }
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "EncodingDeclInvalid", new Object[]{encoding}, (short)2);
            return this.createLatin1Reader(inputStream);
        }
        if (javaEncoding.equals("ASCII")) {
            return this.createASCIIReader(inputStream);
        }
        if (!javaEncoding.equals("ISO8859_1")) return new InputStreamReader(inputStream, javaEncoding);
        return this.createLatin1Reader(inputStream);
    }

    private Reader createUTF8Reader(InputStream stream) {
        if (this.fTempByteBuffer == null) {
            this.fTempByteBuffer = this.fSmallByteBufferPool.getBuffer();
        }
        return new UTF8Reader(stream, this.fTempByteBuffer, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createUTF16Reader(InputStream stream, boolean isBigEndian) {
        if (this.fTempByteBuffer == null) {
            this.fTempByteBuffer = this.fLargeByteBufferPool.getBuffer();
        } else if (this.fTempByteBuffer.length == this.fBufferSize) {
            this.fSmallByteBufferPool.returnBuffer(this.fTempByteBuffer);
            this.fTempByteBuffer = this.fLargeByteBufferPool.getBuffer();
        }
        return new UTF16Reader(stream, this.fTempByteBuffer, isBigEndian, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createASCIIReader(InputStream stream) {
        if (this.fTempByteBuffer == null) {
            this.fTempByteBuffer = this.fSmallByteBufferPool.getBuffer();
        }
        return new ASCIIReader(stream, this.fTempByteBuffer, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createLatin1Reader(InputStream stream) {
        if (this.fTempByteBuffer == null) {
            this.fTempByteBuffer = this.fSmallByteBufferPool.getBuffer();
        }
        return new Latin1Reader(stream, this.fTempByteBuffer);
    }

    protected static String fixURI(String str) {
        int pos;
        str = str.replace(File.separatorChar, '/');
        StringBuffer sb = null;
        if (str.length() >= 2) {
            char ch1 = str.charAt(1);
            if (ch1 == ':') {
                char ch0 = Character.toUpperCase(str.charAt(0));
                if (ch0 >= 'A' && ch0 <= 'Z') {
                    sb = new StringBuffer(str.length() + 8);
                    sb.append("file:///");
                }
            } else if (ch1 == '/' && str.charAt(0) == '/') {
                sb = new StringBuffer(str.length() + 5);
                sb.append("file:");
            }
        }
        if ((pos = str.indexOf(32)) < 0) {
            if (sb != null) {
                sb.append(str);
                str = sb.toString();
            }
        } else {
            if (sb == null) {
                sb = new StringBuffer(str.length());
            }
            int i = 0;
            while (i < pos) {
                sb.append(str.charAt(i));
                ++i;
            }
            sb.append("%20");
            i = pos + 1;
            while (i < str.length()) {
                if (str.charAt(i) == ' ') {
                    sb.append("%20");
                } else {
                    sb.append(str.charAt(i));
                }
                ++i;
            }
            str = sb.toString();
        }
        return str;
    }

    Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    static final void print(ScannedEntity currentEntity) {
    }

    private static final class ByteBufferPool {
        private static final int DEFAULT_POOL_SIZE = 3;
        private int fPoolSize;
        private int fBufferSize;
        private byte[][] fByteBufferPool;
        private int fDepth;

        public ByteBufferPool(int bufferSize) {
            this(3, bufferSize);
        }

        public ByteBufferPool(int poolSize, int bufferSize) {
            this.fPoolSize = poolSize;
            this.fBufferSize = bufferSize;
            this.fByteBufferPool = new byte[this.fPoolSize][];
            this.fDepth = 0;
        }

        public byte[] getBuffer() {
            return this.fDepth > 0 ? this.fByteBufferPool[--this.fDepth] : new byte[this.fBufferSize];
        }

        public void returnBuffer(byte[] buffer) {
            if (this.fDepth < this.fByteBufferPool.length) {
                this.fByteBufferPool[this.fDepth++] = buffer;
            }
        }

        public void setBufferSize(int bufferSize) {
            this.fBufferSize = bufferSize;
            this.fByteBufferPool = new byte[this.fPoolSize][];
            this.fDepth = 0;
        }
    }

    private static final class CharacterBuffer {
        private final char[] ch;
        private final boolean isExternal;

        public CharacterBuffer(boolean isExternal, int size) {
            this.isExternal = isExternal;
            this.ch = new char[size];
        }
    }

    private static final class CharacterBufferPool {
        private static final int DEFAULT_POOL_SIZE = 3;
        private CharacterBuffer[] fInternalBufferPool;
        private CharacterBuffer[] fExternalBufferPool;
        private int fExternalBufferSize;
        private int fInternalBufferSize;
        private int fPoolSize;
        private int fInternalTop;
        private int fExternalTop;

        public CharacterBufferPool(int externalBufferSize, int internalBufferSize) {
            this(3, externalBufferSize, internalBufferSize);
        }

        public CharacterBufferPool(int poolSize, int externalBufferSize, int internalBufferSize) {
            this.fExternalBufferSize = externalBufferSize;
            this.fInternalBufferSize = internalBufferSize;
            this.fPoolSize = poolSize;
            this.init();
        }

        private void init() {
            this.fInternalBufferPool = new CharacterBuffer[this.fPoolSize];
            this.fExternalBufferPool = new CharacterBuffer[this.fPoolSize];
            this.fInternalTop = -1;
            this.fExternalTop = -1;
        }

        public CharacterBuffer getBuffer(boolean external) {
            if (external) {
                if (this.fExternalTop > -1) {
                    return this.fExternalBufferPool[this.fExternalTop--];
                }
                return new CharacterBuffer(true, this.fExternalBufferSize);
            }
            if (this.fInternalTop > -1) {
                return this.fInternalBufferPool[this.fInternalTop--];
            }
            return new CharacterBuffer(false, this.fInternalBufferSize);
        }

        public void returnBuffer(CharacterBuffer buffer) {
            if (buffer.isExternal) {
                if (this.fExternalTop < this.fExternalBufferPool.length - 1) {
                    this.fExternalBufferPool[++this.fExternalTop] = buffer;
                }
            } else if (this.fInternalTop < this.fInternalBufferPool.length - 1) {
                this.fInternalBufferPool[++this.fInternalTop] = buffer;
            }
        }

        public void setExternalBufferSize(int bufferSize) {
            this.fExternalBufferSize = bufferSize;
            this.fExternalBufferPool = new CharacterBuffer[this.fPoolSize];
            this.fExternalTop = -1;
        }
    }

    private static class EncodingInfo {
        public static final EncodingInfo UTF_8 = new EncodingInfo("UTF-8", null, false);
        public static final EncodingInfo UTF_8_WITH_BOM = new EncodingInfo("UTF-8", null, true);
        public static final EncodingInfo UTF_16_BIG_ENDIAN = new EncodingInfo("UTF-16BE", "UTF-16", Boolean.TRUE, false);
        public static final EncodingInfo UTF_16_BIG_ENDIAN_WITH_BOM = new EncodingInfo("UTF-16BE", "UTF-16", Boolean.TRUE, true);
        public static final EncodingInfo UTF_16_LITTLE_ENDIAN = new EncodingInfo("UTF-16LE", "UTF-16", Boolean.FALSE, false);
        public static final EncodingInfo UTF_16_LITTLE_ENDIAN_WITH_BOM = new EncodingInfo("UTF-16LE", "UTF-16", Boolean.FALSE, true);
        public static final EncodingInfo UCS_4_BIG_ENDIAN = new EncodingInfo("ISO-10646-UCS-4", Boolean.TRUE, false);
        public static final EncodingInfo UCS_4_LITTLE_ENDIAN = new EncodingInfo("ISO-10646-UCS-4", Boolean.FALSE, false);
        public static final EncodingInfo UCS_4_UNUSUAL_BYTE_ORDER = new EncodingInfo("ISO-10646-UCS-4", null, false);
        public static final EncodingInfo EBCDIC = new EncodingInfo("CP037", null, false);
        public final String autoDetectedEncoding;
        public final String readerEncoding;
        public final Boolean isBigEndian;
        public final boolean hasBOM;

        private EncodingInfo(String autoDetectedEncoding, Boolean isBigEndian, boolean hasBOM) {
            this(autoDetectedEncoding, autoDetectedEncoding, isBigEndian, hasBOM);
        }

        private EncodingInfo(String autoDetectedEncoding, String readerEncoding, Boolean isBigEndian, boolean hasBOM) {
            this.autoDetectedEncoding = autoDetectedEncoding;
            this.readerEncoding = readerEncoding;
            this.isBigEndian = isBigEndian;
            this.hasBOM = hasBOM;
        }
    }

    public static abstract class Entity {
        public String name;
        public boolean inExternalSubset;

        public Entity() {
            this.clear();
        }

        public Entity(String name, boolean inExternalSubset) {
            this.name = name;
            this.inExternalSubset = inExternalSubset;
        }

        public boolean isEntityDeclInExternalSubset() {
            return this.inExternalSubset;
        }

        public abstract boolean isExternal();

        public abstract boolean isUnparsed();

        public void clear() {
            this.name = null;
            this.inExternalSubset = false;
        }

        public void setValues(Entity entity) {
            this.name = entity.name;
            this.inExternalSubset = entity.inExternalSubset;
        }
    }

    protected static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String name, XMLResourceIdentifier entityLocation, String notation, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.entityLocation = entityLocation;
            this.notation = notation;
        }

        @Override
        public final boolean isExternal() {
            return true;
        }

        @Override
        public final boolean isUnparsed() {
            return this.notation != null;
        }

        @Override
        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }

        @Override
        public void setValues(Entity entity) {
            super.setValues(entity);
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity entity) {
            super.setValues(entity);
            this.entityLocation = entity.entityLocation;
            this.notation = entity.notation;
        }
    }

    protected static class InternalEntity
    extends Entity {
        public String text;
        public int paramEntityRefs;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String name, String text, boolean inExternalSubset) {
            super(name, inExternalSubset);
            this.text = text;
        }

        public InternalEntity(String name, String text, boolean inExternalSubset, int paramEntityRefs) {
            this(name, text, inExternalSubset);
            this.paramEntityRefs = paramEntityRefs;
        }

        @Override
        public final boolean isExternal() {
            return false;
        }

        @Override
        public final boolean isUnparsed() {
            return false;
        }

        @Override
        public void clear() {
            super.clear();
            this.text = null;
        }

        @Override
        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity entity) {
            super.setValues(entity);
            this.text = entity.text;
        }
    }

    protected final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fStartOffset;
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream is) {
            this.fInputStream = is;
            this.fStartOffset = 0;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        public void setStartOffset(int offset) {
            this.fStartOffset = offset;
        }

        public void rewind() {
            this.fOffset = this.fStartOffset;
        }

        public int readAndBuffer() throws IOException {
            int b;
            if (this.fOffset == this.fData.length) {
                byte[] newData = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, newData, 0, this.fOffset);
                this.fData = newData;
            }
            if ((b = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)b;
            ++this.fOffset;
            return b & 0xFF;
        }

        @Override
        public int read() throws IOException {
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (XMLEntityManager.this.fCurrentEntity.mayReadChunks) {
                return this.fInputStream.read();
            }
            return this.readAndBuffer();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                if (XMLEntityManager.this.fCurrentEntity.mayReadChunks) {
                    return this.fInputStream.read(b, off, len);
                }
                int returnedVal = this.readAndBuffer();
                if (returnedVal == -1) {
                    this.fEndOffset = this.fOffset;
                    return -1;
                }
                b[off] = (byte)returnedVal;
                return 1;
            }
            if (len < bytesLeft) {
                if (len <= 0) {
                    return 0;
                }
            } else {
                len = bytesLeft;
            }
            if (b != null) {
                System.arraycopy(this.fData, this.fOffset, b, off, len);
            }
            this.fOffset += len;
            return len;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(n);
            }
            if (n <= (long)bytesLeft) {
                this.fOffset = (int)((long)this.fOffset + n);
                return n;
            }
            this.fOffset += bytesLeft;
            if (this.fOffset == this.fEndOffset) {
                return bytesLeft;
            }
            return this.fInputStream.skip(n -= (long)bytesLeft) + (long)bytesLeft;
        }

        @Override
        public int available() throws IOException {
            int bytesLeft = this.fLength - this.fOffset;
            if (bytesLeft == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEntityManager.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return bytesLeft;
        }

        @Override
        public void mark(int howMuch) {
            this.fMark = this.fOffset;
        }

        @Override
        public void reset() {
            this.fOffset = this.fMark;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }

    public class ScannedEntity
    extends Entity {
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public int lineNumber;
        public int columnNumber;
        public String encoding;
        boolean externallySpecifiedEncoding;
        public String xmlVersion;
        public boolean literal;
        public boolean isExternal;
        public char[] ch;
        public int position;
        public int baseCharOffset;
        public int startPosition;
        public int count;
        public boolean mayReadChunks;
        private CharacterBuffer fCharacterBuffer;
        private byte[] fByteBuffer;

        public ScannedEntity(String name, XMLResourceIdentifier entityLocation, InputStream stream, Reader reader, byte[] byteBuffer, String encoding, boolean literal, boolean mayReadChunks, boolean isExternal) {
            super(name, XMLEntityManager.this.fInExternalSubset);
            this.lineNumber = 1;
            this.columnNumber = 1;
            this.externallySpecifiedEncoding = false;
            this.xmlVersion = "1.0";
            this.ch = null;
            this.entityLocation = entityLocation;
            this.stream = stream;
            this.reader = reader;
            this.encoding = encoding;
            this.literal = literal;
            this.mayReadChunks = mayReadChunks;
            this.isExternal = isExternal;
            this.fCharacterBuffer = XMLEntityManager.this.fCharacterBufferPool.getBuffer(isExternal);
            this.ch = this.fCharacterBuffer.ch;
            this.fByteBuffer = byteBuffer;
        }

        @Override
        public final boolean isExternal() {
            return this.isExternal;
        }

        @Override
        public final boolean isUnparsed() {
            return false;
        }

        public void setReader(InputStream stream, String encoding, Boolean isBigEndian) throws IOException {
            XMLEntityManager.this.fTempByteBuffer = this.fByteBuffer;
            this.reader = XMLEntityManager.this.createReader(stream, encoding, isBigEndian);
            this.fByteBuffer = XMLEntityManager.this.fTempByteBuffer;
        }

        public String getExpandedSystemId() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity externalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (externalEntity.entityLocation != null && externalEntity.entityLocation.getExpandedSystemId() != null) {
                    return externalEntity.entityLocation.getExpandedSystemId();
                }
                --i;
            }
            return null;
        }

        public String getLiteralSystemId() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity externalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (externalEntity.entityLocation != null && externalEntity.entityLocation.getLiteralSystemId() != null) {
                    return externalEntity.entityLocation.getLiteralSystemId();
                }
                --i;
            }
            return null;
        }

        public int getLineNumber() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (firstExternalEntity.isExternal()) {
                    return firstExternalEntity.lineNumber;
                }
                --i;
            }
            return -1;
        }

        public int getColumnNumber() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (firstExternalEntity.isExternal()) {
                    return firstExternalEntity.columnNumber;
                }
                --i;
            }
            return -1;
        }

        public int getCharacterOffset() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (firstExternalEntity.isExternal()) {
                    return firstExternalEntity.baseCharOffset + (firstExternalEntity.position - firstExternalEntity.startPosition);
                }
                --i;
            }
            return -1;
        }

        public String getEncoding() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (firstExternalEntity.isExternal()) {
                    return firstExternalEntity.encoding;
                }
                --i;
            }
            return null;
        }

        public String getXMLVersion() {
            int size = XMLEntityManager.this.fEntityStack.size();
            int i = size - 1;
            while (i >= 0) {
                ScannedEntity firstExternalEntity = (ScannedEntity)XMLEntityManager.this.fEntityStack.elementAt(i);
                if (firstExternalEntity.isExternal()) {
                    return firstExternalEntity.xmlVersion;
                }
                --i;
            }
            return null;
        }

        public boolean isEncodingExternallySpecified() {
            return this.externallySpecifiedEncoding;
        }

        public void setEncodingExternallySpecified(boolean value) {
            this.externallySpecifiedEncoding = value;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append("name=\"").append(this.name).append('\"');
            str.append(",ch=");
            str.append(this.ch);
            str.append(",position=").append(this.position);
            str.append(",count=").append(this.count);
            str.append(",baseCharOffset=").append(this.baseCharOffset);
            str.append(",startPosition=").append(this.startPosition);
            return str.toString();
        }
    }
}

