/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSNamespaceItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSAnnotationImpl
implements XSAnnotation {
    private String fData = null;
    private SchemaGrammar fGrammar = null;

    public XSAnnotationImpl(String contents, SchemaGrammar grammar) {
        this.fData = contents;
        this.fGrammar = grammar;
    }

    @Override
    public boolean writeAnnotation(Object target, short targetType) {
        if (targetType == 1 || targetType == 3) {
            this.writeToDOM((Node)target, targetType);
            return true;
        }
        if (targetType == 2) {
            this.writeToSAX((ContentHandler)target);
            return true;
        }
        return false;
    }

    @Override
    public String getAnnotationString() {
        return this.fData;
    }

    @Override
    public short getType() {
        return 12;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    private synchronized void writeToSAX(ContentHandler handler) {
        SAXParser parser = this.fGrammar.getSAXParser();
        StringReader aReader = new StringReader(this.fData);
        InputSource aSource = new InputSource(aReader);
        parser.setContentHandler(handler);
        try {
            parser.parse(aSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        parser.setContentHandler(null);
    }

    private synchronized void writeToDOM(Node target, short type) {
        Document futureOwner = type == 1 ? target.getOwnerDocument() : (Document)target;
        DOMParser parser = this.fGrammar.getDOMParser();
        StringReader aReader = new StringReader(this.fData);
        InputSource aSource = new InputSource(aReader);
        try {
            parser.parse(aSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        Document aDocument = parser.getDocument();
        parser.dropDocumentReferences();
        Element annotation = aDocument.getDocumentElement();
        Node newElem = null;
        if (futureOwner instanceof CoreDocumentImpl) {
            newElem = futureOwner.adoptNode(annotation);
            if (newElem == null) {
                newElem = futureOwner.importNode(annotation, true);
            }
        } else {
            newElem = futureOwner.importNode(annotation, true);
        }
        target.insertBefore(newElem, target.getFirstChild());
    }
}

