/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

final class JAXPValidationMessageFormatter {
    JAXPValidationMessageFormatter() {
    }

    public static String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        String msg;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.JAXPValidationMessages", locale);
        try {
            msg = resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format(msg, arguments);
                }
                catch (Exception exception) {
                    msg = resourceBundle.getString("FormatFailed");
                    msg = String.valueOf(msg) + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuffer str = new StringBuffer(msg);
                str.append('?');
                int i = 0;
                while (i < arguments.length) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                    ++i;
                }
            }
        }
        return msg;
    }
}

