/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.apache.xerces.impl.XMLEntityDescription;
import org.apache.xerces.impl.dtd.XMLDTDProcessor;
import org.apache.xerces.parsers.SecuritySupport;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDFilter;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLDTDSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public final class SecureProcessingConfiguration
extends XIncludeAwareParserConfiguration {
    private static final String SECURITY_MANAGER_PROPERTY = "http://apache.org/xml/properties/security-manager";
    private static final String ENTITY_RESOLVER_PROPERTY = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final boolean DEBUG = SecureProcessingConfiguration.isDebugEnabled();
    private static Properties jaxpProperties = null;
    private static long lastModified = -1L;
    private static final int SECURITY_MANAGER_DEFAULT_ENTITY_EXPANSION_LIMIT = 100000;
    private static final int SECURITY_MANAGER_DEFAULT_MAX_OCCUR_NODE_LIMIT = 3000;
    private static final String ENTITY_EXPANSION_LIMIT_PROPERTY_NAME = "jdk.xml.entityExpansionLimit";
    private static final String MAX_OCCUR_LIMIT_PROPERTY_NAME = "jdk.xml.maxOccur";
    private static final String TOTAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.totalEntitySizeLimit";
    private static final String MAX_GENERAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.maxGeneralEntitySizeLimit";
    private static final String MAX_PARAMETER_ENTITY_SIZE_LIMIT_PROPERTY_NAME = "jdk.xml.maxParameterEntitySizeLimit";
    private static final String RESOLVE_EXTERNAL_ENTITIES_PROPERTY_NAME = "jdk.xml.resolveExternalEntities";
    private static final int ENTITY_EXPANSION_LIMIT_DEFAULT_VALUE = 64000;
    private static final int MAX_OCCUR_LIMIT_DEFAULT_VALUE = 5000;
    private static final int TOTAL_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = 50000000;
    private static final int MAX_GENERAL_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final int MAX_PARAMETER_ENTITY_SIZE_LIMIT_DEFAULT_VALUE = Integer.MAX_VALUE;
    private static final boolean RESOLVE_EXTERNAL_ENTITIES_DEFAULT_VALUE = true;
    protected final int ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE;
    protected final int MAX_OCCUR_LIMIT_SYSTEM_VALUE;
    protected final int TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final int MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final int MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE;
    protected final boolean RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE;
    private final boolean fJavaSecurityManagerEnabled = System.getSecurityManager() != null;
    private boolean fLimitSpecified;
    private SecurityManager fSecurityManager;
    private InternalEntityMonitor fInternalEntityMonitor;
    private final ExternalEntityMonitor fExternalEntityMonitor;
    private int fTotalEntitySize = 0;

    public SecureProcessingConfiguration() {
        this(null, null, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable) {
        this(symbolTable, null, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, null);
    }

    public SecureProcessingConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, XMLComponentManager parentSettings) {
        super(symbolTable, grammarPool, parentSettings);
        this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE = this.getPropertyValue(ENTITY_EXPANSION_LIMIT_PROPERTY_NAME, 64000);
        this.MAX_OCCUR_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_OCCUR_LIMIT_PROPERTY_NAME, 5000);
        this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(TOTAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME, 50000000);
        this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_GENERAL_ENTITY_SIZE_LIMIT_PROPERTY_NAME, Integer.MAX_VALUE);
        this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE = this.getPropertyValue(MAX_PARAMETER_ENTITY_SIZE_LIMIT_PROPERTY_NAME, Integer.MAX_VALUE);
        this.RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE = this.getPropertyValue(RESOLVE_EXTERNAL_ENTITIES_PROPERTY_NAME, true);
        if (this.fJavaSecurityManagerEnabled || this.fLimitSpecified) {
            if (!this.RESOLVE_EXTERNAL_ENTITIES_SYSTEM_VALUE) {
                super.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
                super.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
                super.setFeature(LOAD_EXTERNAL_DTD, false);
            }
            this.fSecurityManager = new SecurityManager();
            this.fSecurityManager.setEntityExpansionLimit(this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE);
            this.fSecurityManager.setMaxOccurNodeLimit(this.MAX_OCCUR_LIMIT_SYSTEM_VALUE);
            super.setProperty(SECURITY_MANAGER_PROPERTY, this.fSecurityManager);
        }
        this.fExternalEntityMonitor = new ExternalEntityMonitor();
        super.setProperty(ENTITY_RESOLVER_PROPERTY, this.fExternalEntityMonitor);
    }

    protected void checkEntitySizeLimits(int sizeOfEntity, int delta, boolean isPE) {
        this.fTotalEntitySize += delta;
        if (this.fTotalEntitySize > this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "TotalEntitySizeLimitExceeded", new Object[]{new Integer(this.TOTAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
        }
        if (isPE) {
            if (sizeOfEntity > this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MaxParameterEntitySizeLimitExceeded", new Object[]{new Integer(this.MAX_PARAMETER_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
            }
        } else if (sizeOfEntity > this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MaxGeneralEntitySizeLimitExceeded", new Object[]{new Integer(this.MAX_GENERAL_ENTITY_SIZE_LIMIT_SYSTEM_VALUE)}, (short)2);
        }
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        if (SECURITY_MANAGER_PROPERTY.equals(propertyId)) {
            return this.fSecurityManager;
        }
        if (ENTITY_RESOLVER_PROPERTY.equals(propertyId)) {
            return this.fExternalEntityMonitor;
        }
        return super.getProperty(propertyId);
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (SECURITY_MANAGER_PROPERTY.equals(propertyId)) {
            if (value == null && this.fJavaSecurityManagerEnabled) {
                return;
            }
            this.fSecurityManager = (SecurityManager)value;
            if (this.fSecurityManager != null) {
                if (this.fSecurityManager.getEntityExpansionLimit() == 100000) {
                    this.fSecurityManager.setEntityExpansionLimit(this.ENTITY_EXPANSION_LIMIT_SYSTEM_VALUE);
                }
                if (this.fSecurityManager.getMaxOccurNodeLimit() == 3000) {
                    this.fSecurityManager.setMaxOccurNodeLimit(this.MAX_OCCUR_LIMIT_SYSTEM_VALUE);
                }
            }
        } else if (ENTITY_RESOLVER_PROPERTY.equals(propertyId)) {
            this.fExternalEntityMonitor.setEntityResolver((XMLEntityResolver)value);
            return;
        }
        super.setProperty(propertyId, value);
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        this.configurePipelineCommon(true);
    }

    @Override
    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configurePipelineCommon(false);
    }

    private void configurePipelineCommon(boolean isXML10) {
        if (this.fSecurityManager != null) {
            XMLDTDProcessor dtdProcessor;
            XMLDTDScanner dtdScanner;
            this.fTotalEntitySize = 0;
            if (this.fInternalEntityMonitor == null) {
                this.fInternalEntityMonitor = new InternalEntityMonitor();
            }
            if (isXML10) {
                dtdScanner = this.fDTDScanner;
                dtdProcessor = this.fDTDProcessor;
            } else {
                dtdScanner = this.fXML11DTDScanner;
                dtdProcessor = this.fXML11DTDProcessor;
            }
            dtdScanner.setDTDHandler(this.fInternalEntityMonitor);
            this.fInternalEntityMonitor.setDTDSource(dtdScanner);
            this.fInternalEntityMonitor.setDTDHandler(dtdProcessor);
            dtdProcessor.setDTDSource(this.fInternalEntityMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getPropertyValue(String propertyName, int defaultValue) {
        block35: {
            try {
                String propertyValue = SecuritySupport.getSystemProperty(propertyName);
                if (propertyValue != null && propertyValue.length() > 0) {
                    if (DEBUG) {
                        SecureProcessingConfiguration.debugPrintln("found system property \"" + propertyName + "\", value=" + propertyValue);
                    }
                    int intValue = Integer.parseInt(propertyValue);
                    this.fLimitSpecified = true;
                    if (intValue <= 0) return Integer.MAX_VALUE;
                    return intValue;
                }
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                if (!DEBUG) break block35;
                SecureProcessingConfiguration.debugPrintln(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            Object javah;
            boolean fExists = false;
            File f = null;
            try {
                javah = SecuritySupport.getSystemProperty("java.home");
                String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                f = new File(configFile);
                fExists = SecuritySupport.getFileExists(f);
            }
            catch (SecurityException securityException) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            javah = SecureProcessingConfiguration.class;
            synchronized (SecureProcessingConfiguration.class) {
                String propertyValue;
                block37: {
                    boolean runBlock = false;
                    FileInputStream fis = null;
                    try {
                        try {
                            if (lastModified >= 0L) {
                                if (fExists && lastModified < (lastModified = SecuritySupport.getLastModified(f))) {
                                    runBlock = true;
                                } else if (!fExists) {
                                    lastModified = -1L;
                                    jaxpProperties = null;
                                }
                            } else if (fExists) {
                                runBlock = true;
                                lastModified = SecuritySupport.getLastModified(f);
                            }
                            if (runBlock) {
                                jaxpProperties = new Properties();
                                fis = SecuritySupport.getFileInputStream(f);
                                jaxpProperties.load(fis);
                            }
                        }
                        catch (Exception exception) {
                            lastModified = -1L;
                            jaxpProperties = null;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                // ** MonitorExit[javah] (shouldn't be in output)
                if (jaxpProperties == null || (propertyValue = jaxpProperties.getProperty(propertyName)) == null || propertyValue.length() <= 0) return defaultValue;
                if (DEBUG) {
                    SecureProcessingConfiguration.debugPrintln("found \"" + propertyName + "\" in jaxp.properties, value=" + propertyValue);
                }
                int intValue = Integer.parseInt(propertyValue);
                this.fLimitSpecified = true;
                if (intValue <= 0) return Integer.MAX_VALUE;
                return intValue;
            }
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            if (!DEBUG) return defaultValue;
            SecureProcessingConfiguration.debugPrintln(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            e.printStackTrace();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getPropertyValue(String propertyName, boolean defaultValue) {
        block35: {
            try {
                String propertyValue = SecuritySupport.getSystemProperty(propertyName);
                if (propertyValue != null && propertyValue.length() > 0) {
                    if (DEBUG) {
                        SecureProcessingConfiguration.debugPrintln("found system property \"" + propertyName + "\", value=" + propertyValue);
                    }
                    boolean booleanValue = Boolean.valueOf(propertyValue);
                    this.fLimitSpecified = true;
                    return booleanValue;
                }
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                if (!DEBUG) break block35;
                SecureProcessingConfiguration.debugPrintln(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            Object javah;
            boolean fExists = false;
            File f = null;
            try {
                javah = SecuritySupport.getSystemProperty("java.home");
                String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                f = new File(configFile);
                fExists = SecuritySupport.getFileExists(f);
            }
            catch (SecurityException securityException) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            javah = SecureProcessingConfiguration.class;
            synchronized (SecureProcessingConfiguration.class) {
                String propertyValue;
                block37: {
                    boolean runBlock = false;
                    FileInputStream fis = null;
                    try {
                        try {
                            if (lastModified >= 0L) {
                                if (fExists && lastModified < (lastModified = SecuritySupport.getLastModified(f))) {
                                    runBlock = true;
                                } else if (!fExists) {
                                    lastModified = -1L;
                                    jaxpProperties = null;
                                }
                            } else if (fExists) {
                                runBlock = true;
                                lastModified = SecuritySupport.getLastModified(f);
                            }
                            if (runBlock) {
                                jaxpProperties = new Properties();
                                fis = SecuritySupport.getFileInputStream(f);
                                jaxpProperties.load(fis);
                            }
                        }
                        catch (Exception exception) {
                            lastModified = -1L;
                            jaxpProperties = null;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                // ** MonitorExit[javah] (shouldn't be in output)
                if (jaxpProperties == null || (propertyValue = jaxpProperties.getProperty(propertyName)) == null || propertyValue.length() <= 0) return defaultValue;
                if (DEBUG) {
                    SecureProcessingConfiguration.debugPrintln("found \"" + propertyName + "\" in jaxp.properties, value=" + propertyValue);
                }
                boolean booleanValue = Boolean.valueOf(propertyValue);
                this.fLimitSpecified = true;
                return booleanValue;
            }
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            if (!DEBUG) return defaultValue;
            SecureProcessingConfiguration.debugPrintln(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            e.printStackTrace();
        }
        return defaultValue;
    }

    private static boolean isDebugEnabled() {
        try {
            String val = SecuritySupport.getSystemProperty("xerces.debug");
            return val != null && !"false".equals(val);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void debugPrintln(String msg) {
        if (DEBUG) {
            System.err.println("XERCES: " + msg);
        }
    }

    final class ExternalEntityMonitor
    implements XMLEntityResolver {
        private XMLEntityResolver fEntityResolver;

        ExternalEntityMonitor() {
        }

        @Override
        public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
            XMLInputSource source = null;
            if (this.fEntityResolver != null) {
                source = this.fEntityResolver.resolveEntity(resourceIdentifier);
            }
            if (SecureProcessingConfiguration.this.fSecurityManager != null && resourceIdentifier instanceof XMLEntityDescription) {
                Reader reader;
                boolean isPE;
                String name = ((XMLEntityDescription)resourceIdentifier).getEntityName();
                boolean bl = isPE = name != null && name.startsWith("%");
                if (source == null) {
                    String publicId = resourceIdentifier.getPublicId();
                    String systemId = resourceIdentifier.getExpandedSystemId();
                    String baseSystemId = resourceIdentifier.getBaseSystemId();
                    source = new XMLInputSource(publicId, systemId, baseSystemId);
                }
                if ((reader = source.getCharacterStream()) != null) {
                    source.setCharacterStream(new ReaderMonitor(reader, isPE));
                } else {
                    InputStream stream = source.getByteStream();
                    if (stream != null) {
                        source.setByteStream(new InputStreamMonitor(stream, isPE));
                    } else {
                        String systemId = resourceIdentifier.getExpandedSystemId();
                        URL url = new URL(systemId);
                        stream = url.openStream();
                        source.setByteStream(new InputStreamMonitor(stream, isPE));
                    }
                }
            }
            return source;
        }

        public void setEntityResolver(XMLEntityResolver entityResolver) {
            this.fEntityResolver = entityResolver;
        }

        public XMLEntityResolver getEntityResolver() {
            return this.fEntityResolver;
        }

        final class InputStreamMonitor
        extends FilterInputStream {
            private final boolean isPE;
            private int size;

            protected InputStreamMonitor(InputStream in, boolean isPE) {
                super(in);
                this.size = 0;
                this.isPE = isPE;
            }

            @Override
            public int read() throws IOException {
                int i = super.read();
                if (i != -1) {
                    ++this.size;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, 1, this.isPE);
                }
                return i;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int i = super.read(b, off, len);
                if (i > 0) {
                    this.size += i;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, i, this.isPE);
                }
                return i;
            }
        }

        final class ReaderMonitor
        extends FilterReader {
            private final boolean isPE;
            private int size;

            protected ReaderMonitor(Reader in, boolean isPE) {
                super(in);
                this.size = 0;
                this.isPE = isPE;
            }

            @Override
            public int read() throws IOException {
                int i = super.read();
                if (i != -1) {
                    ++this.size;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, 1, this.isPE);
                }
                return i;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                int i = super.read(cbuf, off, len);
                if (i > 0) {
                    this.size += i;
                    SecureProcessingConfiguration.this.checkEntitySizeLimits(this.size, i, this.isPE);
                }
                return i;
            }
        }
    }

    final class InternalEntityMonitor
    implements XMLDTDFilter {
        private XMLDTDSource fDTDSource;
        private XMLDTDHandler fDTDHandler;

        @Override
        public void startDTD(XMLLocator locator, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startDTD(locator, augmentations);
            }
        }

        @Override
        public void startParameterEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startParameterEntity(name, identifier, encoding, augmentations);
            }
        }

        @Override
        public void textDecl(String version, String encoding, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.textDecl(version, encoding, augmentations);
            }
        }

        @Override
        public void endParameterEntity(String name, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endParameterEntity(name, augmentations);
            }
        }

        @Override
        public void startExternalSubset(XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startExternalSubset(identifier, augmentations);
            }
        }

        @Override
        public void endExternalSubset(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endExternalSubset(augmentations);
            }
        }

        @Override
        public void comment(XMLString text, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.comment(text, augmentations);
            }
        }

        @Override
        public void processingInstruction(String target, XMLString data, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.processingInstruction(target, data, augmentations);
            }
        }

        @Override
        public void elementDecl(String name, String contentModel, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.elementDecl(name, contentModel, augmentations);
            }
        }

        @Override
        public void startAttlist(String elementName, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startAttlist(elementName, augmentations);
            }
        }

        @Override
        public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.attributeDecl(elementName, attributeName, type, enumeration, defaultType, defaultValue, nonNormalizedDefaultValue, augmentations);
            }
        }

        @Override
        public void endAttlist(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endAttlist(augmentations);
            }
        }

        @Override
        public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augmentations) throws XNIException {
            SecureProcessingConfiguration.this.checkEntitySizeLimits(text.length, text.length, name != null && name.startsWith("%"));
            if (this.fDTDHandler != null) {
                this.fDTDHandler.internalEntityDecl(name, text, nonNormalizedText, augmentations);
            }
        }

        @Override
        public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.externalEntityDecl(name, identifier, augmentations);
            }
        }

        @Override
        public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(name, identifier, notation, augmentations);
            }
        }

        @Override
        public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(name, identifier, augmentations);
            }
        }

        @Override
        public void startConditional(short type, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.startConditional(type, augmentations);
            }
        }

        @Override
        public void ignoredCharacters(XMLString text, Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.ignoredCharacters(text, augmentations);
            }
        }

        @Override
        public void endConditional(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endConditional(augmentations);
            }
        }

        @Override
        public void endDTD(Augmentations augmentations) throws XNIException {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.endDTD(augmentations);
            }
        }

        @Override
        public void setDTDSource(XMLDTDSource source) {
            this.fDTDSource = source;
        }

        @Override
        public XMLDTDSource getDTDSource() {
            return this.fDTDSource;
        }

        @Override
        public void setDTDHandler(XMLDTDHandler handler) {
            this.fDTDHandler = handler;
        }

        @Override
        public XMLDTDHandler getDTDHandler() {
            return this.fDTDHandler;
        }
    }
}

