/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.FileChannel;

public class IOUtil {
    public static void copyCompletely(InputStream input, OutputStream output) throws IOException {
        int length;
        if (output instanceof FileOutputStream && input instanceof FileInputStream) {
            try {
                FileChannel target = ((FileOutputStream)output).getChannel();
                FileChannel source = ((FileInputStream)input).getChannel();
                source.transferTo(0L, Integer.MAX_VALUE, target);
                source.close();
                target.close();
                return;
            }
            catch (Exception exception) {}
        }
        byte[] buf = new byte[8192];
        while ((length = input.read(buf)) >= 0) {
            output.write(buf, 0, length);
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        try {
            output.close();
        }
        catch (IOException iOException) {}
    }

    public static void copyCompletely(Reader input, Writer output) throws IOException {
        int length;
        char[] buf = new char[8192];
        while ((length = input.read(buf)) >= 0) {
            output.write(buf, 0, length);
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        try {
            output.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyCompletely(URI input, URI output) throws IOException {
        File out = new File(output);
        File dir = out.getParentFile();
        dir.mkdirs();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                InputStream in = IOUtil.urlToStream(input);
                try {
                    try (FileOutputStream os = new FileOutputStream(out);){
                        IOUtil.copyCompletely(in, os);
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Cannot copy to " + output);
        }
    }

    private static InputStream urlToStream(URI input) throws IOException {
        try {
            File f = new File(input);
            if (f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Exception exception) {}
        return input.toURL().openStream();
    }

    public static File createDir(File rootdir, String subdir) {
        boolean created;
        File newdir = subdir == null ? rootdir : new File(rootdir, subdir);
        boolean bl = created = newdir.exists() && newdir.isDirectory() || newdir.mkdirs();
        assert (created) : "Could not create " + newdir.getAbsolutePath();
        return newdir;
    }
}

