/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class SniffedXmlInputStream
extends BufferedInputStream {
    public static final int MAX_SNIFFED_BYTES = 192;
    private static Charset dummy1 = Charset.forName("UTF-8");
    private static Charset dummy2 = Charset.forName("UTF-16");
    private static Charset dummy3 = Charset.forName("UTF-16BE");
    private static Charset dummy4 = Charset.forName("UTF-16LE");
    private static Charset dummy5 = Charset.forName("ISO-8859-1");
    private static Charset dummy6 = Charset.forName("US-ASCII");
    private static Charset dummy7 = Charset.forName("Cp1252");
    private String _encoding = this.sniffFourBytes();
    private static char[] WHITESPACE = new char[]{' ', '\r', '\t', '\n'};
    private static char[] NOTNAME = new char[]{'=', ' ', '\r', '\t', '\n', '?', '>', '<', '\'', '\"'};

    public SniffedXmlInputStream(InputStream stream) throws IOException {
        super(stream);
        String encoding;
        if (this._encoding != null && this._encoding.equals("IBM037") && (encoding = this.sniffForXmlDecl(this._encoding)) != null) {
            this._encoding = encoding;
        }
        if (this._encoding == null) {
            this._encoding = this.sniffForXmlDecl("UTF-8");
        }
        if (this._encoding == null) {
            this._encoding = "UTF-8";
        }
    }

    private int readAsMuchAsPossible(byte[] buf, int startAt, int len) throws IOException {
        int total = 0;
        while (total < len) {
            int count = this.read(buf, startAt + total, len - total);
            if (count < 0) break;
            total += count;
        }
        return total;
    }

    private String sniffFourBytes() throws IOException {
        this.mark(4);
        try {
            byte[] buf = new byte[4];
            if (this.readAsMuchAsPossible(buf, 0, 4) < 4) {
                return null;
            }
            long result = 0xFF000000 & buf[0] << 24 | 0xFF0000 & buf[1] << 16 | 0xFF00 & buf[2] << 8 | 0xFF & buf[3];
            if (result == 65279L) {
                return "UCS-4";
            }
            if (result == -131072L) {
                return "UCS-4";
            }
            if (result == 60L) {
                return "UCS-4BE";
            }
            if (result == 0x3C000000L) {
                return "UCS-4LE";
            }
            if (result == 3932223L) {
                return "UTF-16BE";
            }
            if (result == 1006649088L) {
                return "UTF-16LE";
            }
            if (result == 1010792557L) {
                return null;
            }
            if (result == 1282385812L) {
                return "IBM037";
            }
            if ((result & 0xFFFFFFFFFFFF0000L) == -16842752L) {
                return "UTF-16";
            }
            if ((result & 0xFFFFFFFFFFFF0000L) == -131072L) {
                return "UTF-16";
            }
            if ((result & 0xFFFFFFFFFFFFFF00L) == -272908544L) {
                return "UTF-8";
            }
            return null;
        }
        finally {
            this.reset();
        }
    }

    private String sniffForXmlDecl(String encoding) throws IOException {
        this.mark(192);
        try {
            byte[] bytebuf = new byte[192];
            int bytelimit = this.readAsMuchAsPossible(bytebuf, 0, 192);
            Charset charset = Charset.forName(encoding);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytebuf, 0, bytelimit), charset);
            char[] buf = new char[bytelimit];
            int limit = 0;
            while (limit < bytelimit) {
                int count = ((Reader)reader).read(buf, limit, bytelimit - limit);
                if (count < 0) break;
                limit += count;
            }
            String string = SniffedXmlInputStream.extractXmlDeclEncoding(buf, 0, limit);
            return string;
        }
        finally {
            this.reset();
        }
    }

    public String getXmlEncoding() {
        return this._encoding;
    }

    static String extractXmlDeclEncoding(char[] buf, int offset, int size) {
        int limit = offset + size;
        int xmlpi = SniffedXmlInputStream.firstIndexOf("<?xml", buf, offset, limit);
        if (xmlpi >= 0) {
            int i = xmlpi + 5;
            ScannedAttribute attr = new ScannedAttribute();
            while (i < limit) {
                if ((i = SniffedXmlInputStream.scanAttribute(buf, i, limit, attr)) < 0) {
                    return null;
                }
                if (!attr.name.equals("encoding")) continue;
                return attr.value;
            }
        }
        return null;
    }

    private static int firstIndexOf(String s, char[] buf, int startAt, int limit) {
        assert (s.length() > 0);
        char[] lookFor = s.toCharArray();
        char firstchar = lookFor[0];
        limit -= lookFor.length;
        while (startAt < limit) {
            block5: {
                if (buf[startAt] == firstchar) {
                    int i = 1;
                    while (i < lookFor.length) {
                        if (buf[startAt + i] == lookFor[i]) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return startAt;
                }
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextNonmatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            block3: {
                char thischar = buf[startAt];
                int i = 0;
                while (i < lookFor.length) {
                    if (thischar != lookFor[i]) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char[] lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            char thischar = buf[startAt];
            int i = 0;
            while (i < lookFor.length) {
                if (thischar == lookFor[i]) {
                    return startAt;
                }
                ++i;
            }
            ++startAt;
        }
        return -1;
    }

    private static int nextMatchingByte(char lookFor, char[] buf, int startAt, int limit) {
        while (startAt < limit) {
            if (buf[startAt] == lookFor) {
                return startAt;
            }
            ++startAt;
        }
        return -1;
    }

    private static int scanAttribute(char[] buf, int startAt, int limit, ScannedAttribute attr) {
        int nameStart = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, startAt, limit);
        if (nameStart < 0) {
            return -1;
        }
        int nameEnd = SniffedXmlInputStream.nextMatchingByte(NOTNAME, buf, nameStart, limit);
        if (nameEnd < 0) {
            return -1;
        }
        int equals = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, nameEnd, limit);
        if (equals < 0) {
            return -1;
        }
        if (buf[equals] != '=') {
            return -1;
        }
        int valQuote = SniffedXmlInputStream.nextNonmatchingByte(WHITESPACE, buf, equals + 1, limit);
        if (buf[valQuote] != '\'' && buf[valQuote] != '\"') {
            return -1;
        }
        int valEndquote = SniffedXmlInputStream.nextMatchingByte(buf[valQuote], buf, valQuote + 1, limit);
        if (valEndquote < 0) {
            return -1;
        }
        attr.name = new String(buf, nameStart, nameEnd - nameStart);
        attr.value = new String(buf, valQuote + 1, valEndquote - valQuote - 1);
        return valEndquote + 1;
    }

    private static class ScannedAttribute {
        public String name;
        public String value;

        private ScannedAttribute() {
        }
    }
}

