/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.repackage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlbeans.impl.repackage.Repackager;

public class Repackage {
    private final File _sourceBase;
    private final File _targetBase;
    private List<List<String>> _fromPackages;
    private List<List<String>> _toPackages;
    private Pattern _packagePattern;
    private final Repackager _repackager;
    private Map<String, String> _movedDirs;
    private List<String> _moveAlongFiles;
    private int _skippedFiles;

    public static void main(String[] args) throws Exception {
        new Repackage(args).repackage();
    }

    private Repackage(String[] args) {
        String sourceDir = null;
        String targetDir = null;
        String repackageSpec = null;
        boolean failure = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-repackage") && i + 1 < args.length) {
                repackageSpec = args[++i];
            } else if (args[i].equals("-f") && i + 1 < args.length) {
                sourceDir = args[++i];
            } else if (args[i].equals("-t") && i + 1 < args.length) {
                targetDir = args[++i];
            } else {
                failure = true;
            }
            ++i;
        }
        if (failure || repackageSpec == null || sourceDir == null ^ targetDir == null) {
            throw new RuntimeException("Usage: repackage -repackage [spec] [ -f [sourcedir] -t [targetdir] ]");
        }
        this._repackager = new Repackager(repackageSpec);
        if (sourceDir == null || targetDir == null) {
            this._targetBase = null;
            this._sourceBase = null;
        } else {
            this._sourceBase = new File(sourceDir);
            this._targetBase = new File(targetDir);
        }
    }

    public void repackage() throws Exception {
        if (this._sourceBase == null || this._targetBase == null) {
            System.out.println(this._repackager.repackage(this.readInputStream(System.in)).toString());
            return;
        }
        this._fromPackages = this._repackager.getFromPackages();
        this._toPackages = this._repackager.getToPackages();
        this._packagePattern = Pattern.compile("^\\s*package\\s+((?:\\w|\\.)*)\\s*;", 8);
        this._moveAlongFiles = new ArrayList<String>();
        this._movedDirs = new HashMap<String, String>();
        this._targetBase.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        this.fillFiles(files, this._sourceBase);
        System.out.println("Repackaging " + files.size() + " files ...");
        int prefixLength = this._sourceBase.getCanonicalPath().length();
        for (File from : files) {
            String name = from.getCanonicalPath().substring(prefixLength + 1);
            this.repackageFile(name);
        }
        this.finishMovingFiles();
        if (this._skippedFiles > 0) {
            System.out.println("Skipped " + this._skippedFiles + " unmodified files.");
        }
    }

    public void repackageFile(String name) throws IOException {
        if (name.endsWith(".java")) {
            this.repackageJavaFile(name);
        } else if (name.endsWith(".xsdconfig") || name.endsWith(".xml") || name.endsWith(".g")) {
            this.repackageNonJavaFile(name);
        } else if (name.startsWith("bin" + File.separatorChar)) {
            this.repackageNonJavaFile(name);
        } else {
            this.moveAlongWithJavaFiles(name);
        }
    }

    public void moveAlongWithJavaFiles(String name) {
        this._moveAlongFiles.add(name);
    }

    public void finishMovingFiles() throws IOException {
        for (String name : this._moveAlongFiles) {
            String toName;
            String srcDir = Repackager.dirForPath(name);
            String toDir = this._movedDirs.get(srcDir);
            String string = toName = toDir == null ? name : new File(toDir, new File(name).getName()).toString();
            if (name.endsWith(".html")) {
                this.repackageNonJavaFile(name, toName);
                continue;
            }
            this.justMoveNonJavaFile(name, toName);
        }
    }

    public void repackageNonJavaFile(String name) throws IOException {
        File sourceFile = new File(this._sourceBase, name);
        File targetFile = new File(this._targetBase, name);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            this.writeFile(targetFile, this._repackager.repackage(this.readFile(sourceFile)));
        }
    }

    public void repackageNonJavaFile(String sourceName, String targetName) throws IOException {
        File sourceFile = new File(this._sourceBase, sourceName);
        File targetFile = new File(this._targetBase, targetName);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            this.writeFile(targetFile, this._repackager.repackage(this.readFile(sourceFile)));
        }
    }

    public void justMoveNonJavaFile(String sourceName, String targetName) throws IOException {
        File sourceFile = new File(this._sourceBase, sourceName);
        File targetFile = new File(this._targetBase, targetName);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            Repackage.copyFile(sourceFile, targetFile);
        }
    }

    public void repackageJavaFile(String name) throws IOException {
        File sourceFile = new File(this._sourceBase, name);
        StringBuffer sb = this.readFile(sourceFile);
        Matcher packageMatcher = this._packagePattern.matcher(sb);
        if (packageMatcher.find()) {
            boolean swapped;
            String pkg = packageMatcher.group(1);
            int pkgStart = packageMatcher.start(1);
            int pkgEnd = packageMatcher.end(1);
            if (packageMatcher.find()) {
                throw new RuntimeException("Two package specifications found: " + name);
            }
            List<String> filePath = Repackager.splitPath(name, File.separatorChar);
            String srcDir = Repackager.dirForPath(name);
            do {
                swapped = false;
                int i = 1;
                while (i < filePath.size()) {
                    String spec1 = filePath.get(i - 1);
                    String spec2 = filePath.get(i);
                    if (spec1.indexOf(58) < spec2.indexOf(58)) {
                        filePath.set(i - 1, spec2);
                        filePath.set(i, spec1);
                        swapped = true;
                    }
                    ++i;
                }
            } while (swapped);
            List<String> pkgPath = Repackager.splitPath(pkg, '.');
            int f = filePath.size() - 2;
            if (f < 0 || filePath.size() - 1 < pkgPath.size()) {
                throw new RuntimeException("Package spec differs from file path: " + name);
            }
            int i = pkgPath.size() - 1;
            while (i >= 0) {
                if (!pkgPath.get(i).equals(filePath.get(f))) {
                    throw new RuntimeException("Package spec differs from file path: " + name);
                }
                --f;
                --i;
            }
            List<String> changeTo = null;
            List<String> changeFrom = null;
            int i2 = 0;
            while (i2 < this._fromPackages.size()) {
                block19: {
                    List<String> from = this._fromPackages.get(i2);
                    if (from.size() <= pkgPath.size()) {
                        int j = 0;
                        while (j < from.size()) {
                            if (from.get(j).equals(pkgPath.get(j))) {
                                ++j;
                                continue;
                            }
                            break block19;
                        }
                        changeFrom = from;
                        changeTo = this._toPackages.get(i2);
                        break;
                    }
                }
                ++i2;
            }
            if (changeTo != null) {
                String newPkg = "";
                String newName = "";
                int i3 = 0;
                while (i3 < changeTo.size()) {
                    if (i3 > 0) {
                        newPkg = String.valueOf(newPkg) + ".";
                        newName = String.valueOf(newName) + File.separatorChar;
                    }
                    newPkg = String.valueOf(newPkg) + (String)changeTo.get(i3);
                    newName = String.valueOf(newName) + changeTo.get(i3);
                    ++i3;
                }
                i3 = filePath.size() - pkgPath.size() - 2;
                while (i3 >= 0) {
                    newName = String.valueOf(filePath.get(i3)) + File.separatorChar + newName;
                    --i3;
                }
                i3 = changeFrom.size();
                while (i3 < pkgPath.size()) {
                    newName = String.valueOf(newName) + File.separatorChar + pkgPath.get(i3);
                    newPkg = String.valueOf(newPkg) + '.' + pkgPath.get(i3);
                    ++i3;
                }
                newName = String.valueOf(newName) + File.separatorChar + filePath.get(filePath.size() - 1);
                sb.replace(pkgStart, pkgEnd, newPkg);
                name = newName;
                String newDir = Repackager.dirForPath(name);
                if (!srcDir.equals(newDir)) {
                    this._movedDirs.put(srcDir, newDir);
                }
            }
        }
        File targetFile = new File(this._targetBase, name);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
            return;
        }
        this.writeFile(new File(this._targetBase, name), this._repackager.repackage(sb));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeFile(File f, StringBuffer chars) throws IOException {
        f.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedWriter w = Files.newBufferedWriter(f.toPath(), StandardCharsets.ISO_8859_1, new OpenOption[0]);
            try {
                try (StringReader r = new StringReader(chars.toString());){
                    Repackage.copy(r, w);
                }
                if (w == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (w == null) throw throwable;
                ((Writer)w).close();
                throw throwable;
            }
            ((Writer)w).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    StringBuffer readFile(File f) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            StringBuffer stringBuffer;
            StringWriter w;
            BufferedReader r;
            block16: {
                block15: {
                    r = Files.newBufferedReader(f.toPath(), StandardCharsets.ISO_8859_1);
                    w = new StringWriter();
                    Repackage.copy(r, w);
                    stringBuffer = w.getBuffer();
                    if (w == null) break block15;
                    w.close();
                }
                if (r == null) break block16;
                ((Reader)r).close();
            }
            return stringBuffer;
            {
                catch (Throwable throwable2) {
                    try {
                        if (w != null) {
                            w.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    StringBuffer readInputStream(InputStream is) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            StringBuffer stringBuffer;
            StringWriter w;
            InputStreamReader r;
            block16: {
                block15: {
                    r = new InputStreamReader(is, StandardCharsets.ISO_8859_1);
                    w = new StringWriter();
                    Repackage.copy(r, w);
                    stringBuffer = w.getBuffer();
                    if (w == null) break block15;
                    w.close();
                }
                if (r == null) break block16;
                ((Reader)r).close();
            }
            return stringBuffer;
            {
                catch (Throwable throwable2) {
                    try {
                        if (w != null) {
                            w.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File from, File to) throws IOException {
        to.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream in = new FileInputStream(from);
            try {
                try (FileOutputStream out = new FileOutputStream(to);){
                    Repackage.copy(in, out);
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[16384];
        while ((n = in.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, n);
        }
    }

    public static void copy(Reader r, Writer w) throws IOException {
        int n;
        char[] buffer = new char[16384];
        while ((n = r.read(buffer, 0, buffer.length)) >= 0) {
            w.write(buffer, 0, n);
        }
    }

    public void fillFiles(List<File> files, File file) {
        if (!file.isDirectory()) {
            files.add(file);
            return;
        }
        if (file.getName().equals("build")) {
            return;
        }
        if (file.getName().equals("CVS")) {
            return;
        }
        String[] entries = file.list();
        if (entries == null) {
            throw new RuntimeException("Directory can't be accessed: " + file.toString());
        }
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            this.fillFiles(files, new File(file, entry));
            ++n2;
        }
    }

    public void recursiveDelete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] entries = file.list();
            if (entries == null) {
                throw new RuntimeException("Directory can't be accessed: " + file.toString());
            }
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                this.recursiveDelete(new File(file, entry));
                ++n2;
            }
        }
        file.delete();
    }
}

