/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.repackage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Repackager {
    private final List<List<String>> _fromPackages = new ArrayList<List<String>>();
    private final List<List<String>> _toPackages = new ArrayList<List<String>>();
    private Matcher[] _fromMatchers;
    private String[] _toPackageNames;

    public Repackager(String repackageSpecs) {
        boolean swapped;
        List<String> repackages = Repackager.splitPath(repackageSpecs, ';');
        do {
            swapped = false;
            int i = 1;
            while (i < repackages.size()) {
                String spec1 = repackages.get(i - 1);
                String spec2 = repackages.get(i);
                if (spec1.indexOf(58) < spec2.indexOf(58)) {
                    repackages.set(i - 1, spec2);
                    repackages.set(i, spec1);
                    swapped = true;
                }
                ++i;
            }
        } while (swapped);
        for (String repackage : repackages) {
            int j = repackage.indexOf(58);
            if (j < 0 || repackage.indexOf(58, j + 1) >= 0) {
                throw new RuntimeException("Illegal repackage specification: " + repackage);
            }
            String from = repackage.substring(0, j);
            String to = repackage.substring(j + 1);
            this._fromPackages.add(Repackager.splitPath(from, '.'));
            this._toPackages.add(Repackager.splitPath(to, '.'));
        }
        this._fromMatchers = new Matcher[this._fromPackages.size() * 2];
        this._toPackageNames = new String[this._fromPackages.size() * 2];
        this.addPatterns('.', 0);
        this.addPatterns('/', this._fromPackages.size());
    }

    void addPatterns(char sep, int off) {
        int i = 0;
        while (i < this._fromPackages.size()) {
            List<String> from = this._fromPackages.get(i);
            List<String> to = this._toPackages.get(i);
            String pattern = "";
            int j = 0;
            while (j < from.size()) {
                if (j > 0) {
                    pattern = String.valueOf(pattern) + "\\" + sep;
                }
                pattern = String.valueOf(pattern) + from.get(j);
                ++j;
            }
            String toPackage = "";
            int j2 = 0;
            while (j2 < to.size()) {
                if (j2 > 0) {
                    toPackage = String.valueOf(toPackage) + sep;
                }
                toPackage = String.valueOf(toPackage) + to.get(j2);
                ++j2;
            }
            this._fromMatchers[off + i] = Pattern.compile(pattern).matcher("");
            this._toPackageNames[off + i] = toPackage;
            ++i;
        }
    }

    public StringBuffer repackage(StringBuffer sb) {
        StringBuffer result = null;
        int i = 0;
        while (i < this._fromMatchers.length) {
            Matcher m = this._fromMatchers[i];
            m.reset(sb);
            boolean found = m.find();
            while (found) {
                if (result == null) {
                    result = new StringBuffer();
                }
                m.appendReplacement(result, this._toPackageNames[i]);
                found = m.find();
            }
            if (result != null) {
                m.appendTail(result);
                sb = result;
                result = null;
            }
            ++i;
        }
        return sb;
    }

    public List<List<String>> getFromPackages() {
        return this._fromPackages;
    }

    public List<List<String>> getToPackages() {
        return this._toPackages;
    }

    public static List<String> splitPath(String path, char separator) {
        int i;
        ArrayList<String> components = new ArrayList<String>();
        while ((i = path.indexOf(separator)) >= 0) {
            components.add(path.substring(0, i));
            path = path.substring(i + 1);
        }
        if (path.length() > 0) {
            components.add(path);
        }
        return components;
    }

    public static String dirForPath(String path) {
        return new File(path).getParent();
    }
}

