/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CommandLine;

public class InstanceValidator {
    public static void printUsage() {
        System.out.println("Validates the specified instance against the specified schema.");
        System.out.println("Contrast with the svalidate tool, which validates using a stream.");
        System.out.println("Usage: validate [-dl] [-nopvr] [-noupa] [-license] schema.xsd instance.xml");
        System.out.println("Options:");
        System.out.println("    -dl - permit network downloads for imports and includes (default is off)");
        System.out.println("    -noupa - do not enforce the unique particle attribution rule");
        System.out.println("    -nopvr - do not enforce the particle valid (restriction) rule");
        System.out.println("    -strict - performs strict(er) validation");
        System.out.println("    -partial - allow partial schema type system");
        System.out.println("    -license - prints license information");
    }

    public static void main(String[] args) {
        System.exit(InstanceValidator.extraMain(args));
    }

    /*
     * Unable to fully structure code
     */
    public static int extraMain(String[] args) {
        block30: {
            flags = new HashSet<String>();
            flags.add("h");
            flags.add("help");
            flags.add("usage");
            flags.add("license");
            flags.add("version");
            flags.add("dl");
            flags.add("noupa");
            flags.add("nopvr");
            flags.add("strict");
            flags.add("partial");
            cl = new CommandLine(args, flags, Collections.EMPTY_SET);
            if (cl.getOpt("h") != null || cl.getOpt("help") != null || cl.getOpt("usage") != null || args.length < 1) {
                InstanceValidator.printUsage();
                return 0;
            }
            badopts = cl.getBadOpts();
            if (badopts.length > 0) {
                i = 0;
                while (i < badopts.length) {
                    System.out.println("Unrecognized option: " + badopts[i]);
                    ++i;
                }
                InstanceValidator.printUsage();
                return 0;
            }
            if (cl.getOpt("license") != null) {
                CommandLine.printLicense();
                return 0;
            }
            if (cl.getOpt("version") != null) {
                CommandLine.printVersion();
                return 0;
            }
            if (cl.args().length == 0) {
                return 0;
            }
            dl = cl.getOpt("dl") != null;
            nopvr = cl.getOpt("nopvr") != null;
            noupa = cl.getOpt("noupa") != null;
            strict = cl.getOpt("strict") != null;
            partial = cl.getOpt("partial") != null;
            schemaFiles = cl.filesEndingWith(".xsd");
            instanceFiles = cl.filesEndingWith(".xml");
            jarFiles = cl.filesEndingWith(".jar");
            sdocs = new ArrayList<XmlObject>();
            var16_14 = schemaFiles;
            var15_15 = schemaFiles.length;
            var14_17 = 0;
            while (var14_17 < var15_15) {
                schemaFile = var16_14[var14_17];
                try {
                    sdocs.add(XmlObject.Factory.parse(schemaFile, new XmlOptions().setLoadLineNumbers().setLoadMessageDigest()));
                }
                catch (Exception e) {
                    System.err.println(schemaFile + " not loadable: " + e);
                }
                ++var14_17;
            }
            schemas = sdocs.toArray(new XmlObject[0]);
            sLoader = null;
            compErrors = new ArrayList<XmlError>();
            schemaOptions = new XmlOptions();
            schemaOptions.setErrorListener(compErrors);
            if (dl) {
                schemaOptions.setCompileDownloadUrls();
            }
            if (nopvr) {
                schemaOptions.setCompileNoPvrRule();
            }
            if (noupa) {
                schemaOptions.setCompileNoUpaRule();
            }
            if (partial) {
                schemaOptions.setCompilePartialTypesystem();
            }
            if (jarFiles != null && jarFiles.length > 0) {
                sLoader = XmlBeans.typeLoaderForResource(XmlBeans.resourceLoaderForPath(jarFiles));
            }
            returnCode = 0;
            try {
                if (schemas != null && schemas.length > 0) {
                    sLoader = XmlBeans.compileXsd(schemas, sLoader, schemaOptions);
                }
                break block30;
            }
            catch (Exception e) {
                if (compErrors.isEmpty() || !(e instanceof XmlException)) {
                    e.printStackTrace(System.err);
                }
                System.out.println("Schema invalid:" + (partial != false ? " couldn't recover from errors" : ""));
                ** for (compError : compErrors)
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(compError);
                continue;
            }
lbl97:
            // 1 sources

            returnCode = 10;
            return returnCode;
        }
        if (partial && !compErrors.isEmpty()) {
            returnCode = 11;
            System.out.println("Schema invalid: partial schema type system recovered");
            for (XmlError compError : compErrors) {
                System.out.println(compError);
            }
        }
        if (sLoader == null) {
            sLoader = XmlBeans.getContextTypeLoader();
        }
        var21_29 = instanceFiles;
        var20_25 = instanceFiles.length;
        var19_28 = 0;
        while (var19_28 < var20_25) {
            block31: {
                instanceFile = var21_29[var19_28];
                try {
                    xo = new XmlOptions();
                    xo.setLoadLineNumbersEndElement();
                    xobj = sLoader.parse(instanceFile, null, xo);
                }
                catch (Exception e) {
                    System.err.println(instanceFile + " not loadable: " + e);
                    e.printStackTrace(System.err);
                    break block31;
                }
                errors = new ArrayList<XmlError>();
                if (xobj.schemaType() == XmlObject.type) {
                    System.out.println(instanceFile + " NOT valid.  ");
                    System.out.println("  Document type not found.");
                } else if (xobj.validate(strict != false ? new XmlOptions().setErrorListener(errors).setValidateStrict() : new XmlOptions().setErrorListener(errors))) {
                    System.out.println(instanceFile + " valid.");
                } else {
                    returnCode = 1;
                    System.out.println(instanceFile + " NOT valid.");
                    for (XmlError error : errors) {
                        System.out.println(error);
                    }
                }
            }
            ++var19_28;
        }
        return returnCode;
    }
}

