/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.StaxHelper;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.apache.xmlbeans.impl.validator.ValidatingXMLStreamReader;

public class StreamInstanceValidator {
    public static void printUsage() {
        System.out.println("Validates the specified instance against the specified schema.");
        System.out.println("A streaming validation useful for validating very large instance ");
        System.out.println("documents with less memory. Contrast with the validate tool.");
        System.out.println("Usage: svalidate [-dl] [-nopvr] [-noupa] [-license] schema.xsd instance.xml");
        System.out.println("Options:");
        System.out.println("    -dl - permit network downloads for imports and includes (default is off)");
        System.out.println("    -noupa - do not enforce the unique particle attribution rule");
        System.out.println("    -nopvr - do not enforce the particle valid (restriction) rule");
        System.out.println("    -license - prints license information");
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block18: {
            flags = new HashSet<String>();
            flags.add("h");
            flags.add("help");
            flags.add("usage");
            flags.add("license");
            flags.add("version");
            flags.add("dl");
            flags.add("noupr");
            flags.add("noupa");
            cl = new CommandLine(args, flags, Collections.EMPTY_SET);
            if (cl.getOpt("h") != null || cl.getOpt("help") != null || cl.getOpt("usage") != null || args.length < 1) {
                StreamInstanceValidator.printUsage();
                System.exit(0);
                return;
            }
            badopts = cl.getBadOpts();
            if (badopts.length > 0) {
                i = 0;
                while (i < badopts.length) {
                    System.out.println("Unrecognized option: " + badopts[i]);
                    ++i;
                }
                StreamInstanceValidator.printUsage();
                System.exit(0);
                return;
            }
            if (cl.getOpt("license") != null) {
                CommandLine.printLicense();
                System.exit(0);
                return;
            }
            if (cl.getOpt("version") != null) {
                CommandLine.printVersion();
                System.exit(0);
                return;
            }
            if (cl.args().length == 0) {
                StreamInstanceValidator.printUsage();
                return;
            }
            dl = cl.getOpt("dl") != null;
            nopvr = cl.getOpt("nopvr") != null;
            noupa = cl.getOpt("noupa") != null;
            schemaFiles = cl.filesEndingWith(".xsd");
            instanceFiles = cl.filesEndingWith(".xml");
            jarFiles = cl.filesEndingWith(".jar");
            sdocs = new ArrayList<XmlObject>();
            options = new XmlOptions().setLoadLineNumbers();
            i = 0;
            while (i < schemaFiles.length) {
                try {
                    sdocs.add(XmlObject.Factory.parse(schemaFiles[i], options.setLoadMessageDigest()));
                }
                catch (Exception e) {
                    System.err.println(schemaFiles[i] + " not loadable: " + e);
                }
                ++i;
            }
            schemas = sdocs.toArray(new XmlObject[0]);
            sLoader = null;
            compErrors = new ArrayList<XmlError>();
            schemaOptions = new XmlOptions();
            schemaOptions.setErrorListener(compErrors);
            if (dl) {
                schemaOptions.setCompileDownloadUrls();
            }
            if (nopvr) {
                schemaOptions.setCompileNoPvrRule();
            }
            if (noupa) {
                schemaOptions.setCompileNoUpaRule();
            }
            if (jarFiles != null && jarFiles.length > 0) {
                sLoader = XmlBeans.typeLoaderForResource(XmlBeans.resourceLoaderForPath(jarFiles));
            }
            try {
                if (schemas != null && schemas.length > 0) {
                    sLoader = XmlBeans.compileXsd(schemas, sLoader, schemaOptions);
                }
                break block18;
            }
            catch (Exception e) {
                if (compErrors.isEmpty() || !(e instanceof XmlException)) {
                    e.printStackTrace(System.err);
                }
                System.out.println("Schema invalid");
                i = compErrors.iterator();
                ** while (i.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(i.next());
                continue;
            }
lbl91:
            // 1 sources

            return;
        }
        StreamInstanceValidator.validateFiles(instanceFiles, sLoader, options);
    }

    public static void validateFiles(File[] instanceFiles, SchemaTypeLoader sLoader, XmlOptions options) {
        ValidatingXMLStreamReader vsr = new ValidatingXMLStreamReader();
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        int i = 0;
        while (i < instanceFiles.length) {
            block9: {
                File file = instanceFiles[i];
                String path = file.getPath();
                long time = 0L;
                errors.clear();
                try {
                    XMLInputFactory xmlInputFactory = StaxHelper.newXMLInputFactory(new XmlOptions(options));
                    FileInputStream fis = new FileInputStream(file);
                    XMLStreamReader rdr = xmlInputFactory.createXMLStreamReader(path, fis);
                    while (!rdr.isStartElement()) {
                        rdr.next();
                    }
                    time = System.currentTimeMillis();
                    vsr.init(rdr, true, null, sLoader, options, errors);
                    while (vsr.hasNext()) {
                        vsr.next();
                    }
                    time = System.currentTimeMillis() - time;
                    vsr.close();
                    fis.close();
                }
                catch (XMLStreamException xse) {
                    Location loc = xse.getLocation();
                    XmlError e = XmlError.forLocation(xse.getMessage(), path, loc.getLineNumber(), loc.getColumnNumber(), loc.getCharacterOffset());
                    errors.add(e);
                }
                catch (Exception e) {
                    System.err.println("error for file: " + file + ": " + e);
                    e.printStackTrace(System.err);
                    break block9;
                }
                if (errors.isEmpty()) {
                    System.out.println(file + " valid. (" + time + " ms)");
                } else {
                    System.out.println(file + " NOT valid (" + time + " ms):");
                    for (XmlError err : errors) {
                        System.out.println(StreamInstanceValidator.stringFromError(err, path));
                    }
                }
            }
            ++i;
        }
    }

    private static String stringFromError(XmlError err, String path) {
        String s = String.valueOf(XmlError.severityAsString(err.getSeverity())) + ": " + path + ":" + err.getLine() + ":" + err.getColumn() + " " + err.getMessage() + " ";
        return s;
    }
}

