/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public final class Glyphs {
    public static final String NOTDEF = ".notdef";
    @Deprecated
    public static final String[] MAC_GLYPH_NAMES = new String[]{".notdef", ".null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "Sigma", "Pi", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "applelogo", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dmacron"};
    public static final String[] TEX8R_GLYPH_NAMES = new String[]{".notdef", "dotaccent", "fi", "fl", "fraction", "hungarumlaut", "Lslash", "lslash", "ogonek", "ring", ".notdef", "breve", "minus", ".notdef", "Zcaron", "zcaron", "caron", "dotlessi", "dotlessj", "ff", "ffi", "ffl", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "grave", "quotesingle", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", ".notdef", "Euro", ".notdef", "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", ".notdef", ".notdef", "Ydieresis", ".notdef", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
    public static final char[] WINANSI_ENCODING;
    public static final char[] ADOBECYRILLIC_ENCODING;
    private static final String[] UNICODE_GLYPHS;
    private static final String[] DINGBATS_GLYPHS;
    private static final Map CHARNAME_ALTERNATIVES;
    private static final Map CHARNAMES_TO_UNICODE;

    static {
        char[] cArray = new char[256];
        cArray[32] = 32;
        cArray[33] = 33;
        cArray[34] = 34;
        cArray[35] = 35;
        cArray[36] = 36;
        cArray[37] = 37;
        cArray[38] = 38;
        cArray[39] = 39;
        cArray[40] = 40;
        cArray[41] = 41;
        cArray[42] = 42;
        cArray[43] = 43;
        cArray[44] = 44;
        cArray[45] = 45;
        cArray[46] = 46;
        cArray[47] = 47;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[58] = 58;
        cArray[59] = 59;
        cArray[60] = 60;
        cArray[61] = 61;
        cArray[62] = 62;
        cArray[63] = 63;
        cArray[64] = 64;
        cArray[65] = 65;
        cArray[66] = 66;
        cArray[67] = 67;
        cArray[68] = 68;
        cArray[69] = 69;
        cArray[70] = 70;
        cArray[71] = 71;
        cArray[72] = 72;
        cArray[73] = 73;
        cArray[74] = 74;
        cArray[75] = 75;
        cArray[76] = 76;
        cArray[77] = 77;
        cArray[78] = 78;
        cArray[79] = 79;
        cArray[80] = 80;
        cArray[81] = 81;
        cArray[82] = 82;
        cArray[83] = 83;
        cArray[84] = 84;
        cArray[85] = 85;
        cArray[86] = 86;
        cArray[87] = 87;
        cArray[88] = 88;
        cArray[89] = 89;
        cArray[90] = 90;
        cArray[91] = 91;
        cArray[92] = 92;
        cArray[93] = 93;
        cArray[94] = 94;
        cArray[95] = 95;
        cArray[96] = 8216;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        cArray[123] = 123;
        cArray[124] = 124;
        cArray[125] = 125;
        cArray[126] = 126;
        cArray[127] = 8226;
        cArray[128] = 8364;
        cArray[129] = 8226;
        cArray[130] = 8218;
        cArray[131] = 402;
        cArray[132] = 8222;
        cArray[133] = 8230;
        cArray[134] = 8224;
        cArray[135] = 8225;
        cArray[136] = 710;
        cArray[137] = 8240;
        cArray[138] = 352;
        cArray[139] = 8249;
        cArray[140] = 338;
        cArray[141] = 8226;
        cArray[142] = 381;
        cArray[143] = 8226;
        cArray[144] = 8226;
        cArray[145] = 8216;
        cArray[146] = 8217;
        cArray[147] = 8220;
        cArray[148] = 8221;
        cArray[149] = 8226;
        cArray[150] = 8211;
        cArray[151] = 8212;
        cArray[152] = 126;
        cArray[153] = 8482;
        cArray[154] = 353;
        cArray[155] = 8250;
        cArray[156] = 339;
        cArray[157] = 8226;
        cArray[158] = 382;
        cArray[159] = 376;
        cArray[160] = 32;
        cArray[161] = 161;
        cArray[162] = 162;
        cArray[163] = 163;
        cArray[164] = 164;
        cArray[165] = 165;
        cArray[166] = 166;
        cArray[167] = 167;
        cArray[168] = 168;
        cArray[169] = 169;
        cArray[170] = 170;
        cArray[171] = 171;
        cArray[172] = 172;
        cArray[173] = 173;
        cArray[174] = 174;
        cArray[175] = 175;
        cArray[176] = 176;
        cArray[177] = 177;
        cArray[178] = 178;
        cArray[179] = 179;
        cArray[180] = 180;
        cArray[181] = 181;
        cArray[182] = 182;
        cArray[183] = 183;
        cArray[184] = 184;
        cArray[185] = 185;
        cArray[186] = 186;
        cArray[187] = 187;
        cArray[188] = 188;
        cArray[189] = 189;
        cArray[190] = 190;
        cArray[191] = 191;
        cArray[192] = 192;
        cArray[193] = 193;
        cArray[194] = 194;
        cArray[195] = 195;
        cArray[196] = 196;
        cArray[197] = 197;
        cArray[198] = 198;
        cArray[199] = 199;
        cArray[200] = 200;
        cArray[201] = 201;
        cArray[202] = 202;
        cArray[203] = 203;
        cArray[204] = 204;
        cArray[205] = 205;
        cArray[206] = 206;
        cArray[207] = 207;
        cArray[208] = 208;
        cArray[209] = 209;
        cArray[210] = 210;
        cArray[211] = 211;
        cArray[212] = 212;
        cArray[213] = 213;
        cArray[214] = 214;
        cArray[215] = 215;
        cArray[216] = 216;
        cArray[217] = 217;
        cArray[218] = 218;
        cArray[219] = 219;
        cArray[220] = 220;
        cArray[221] = 221;
        cArray[222] = 222;
        cArray[223] = 223;
        cArray[224] = 224;
        cArray[225] = 225;
        cArray[226] = 226;
        cArray[227] = 227;
        cArray[228] = 228;
        cArray[229] = 229;
        cArray[230] = 230;
        cArray[231] = 231;
        cArray[232] = 232;
        cArray[233] = 233;
        cArray[234] = 234;
        cArray[235] = 235;
        cArray[236] = 236;
        cArray[237] = 237;
        cArray[238] = 238;
        cArray[239] = 239;
        cArray[240] = 240;
        cArray[241] = 241;
        cArray[242] = 242;
        cArray[243] = 243;
        cArray[244] = 244;
        cArray[245] = 245;
        cArray[246] = 246;
        cArray[247] = 247;
        cArray[248] = 248;
        cArray[249] = 249;
        cArray[250] = 250;
        cArray[251] = 251;
        cArray[252] = 252;
        cArray[253] = 253;
        cArray[254] = 254;
        cArray[255] = 255;
        WINANSI_ENCODING = cArray;
        char[] cArray2 = new char[256];
        cArray2[32] = 32;
        cArray2[33] = 33;
        cArray2[34] = 34;
        cArray2[35] = 35;
        cArray2[36] = 36;
        cArray2[37] = 37;
        cArray2[38] = 38;
        cArray2[39] = 39;
        cArray2[40] = 40;
        cArray2[41] = 41;
        cArray2[42] = 42;
        cArray2[43] = 43;
        cArray2[44] = 44;
        cArray2[45] = 45;
        cArray2[46] = 46;
        cArray2[47] = 47;
        cArray2[48] = 48;
        cArray2[49] = 49;
        cArray2[50] = 50;
        cArray2[51] = 51;
        cArray2[52] = 52;
        cArray2[53] = 53;
        cArray2[54] = 54;
        cArray2[55] = 55;
        cArray2[56] = 56;
        cArray2[57] = 57;
        cArray2[58] = 58;
        cArray2[59] = 59;
        cArray2[60] = 60;
        cArray2[61] = 61;
        cArray2[62] = 62;
        cArray2[63] = 63;
        cArray2[64] = 64;
        cArray2[65] = 65;
        cArray2[66] = 66;
        cArray2[67] = 67;
        cArray2[68] = 68;
        cArray2[69] = 69;
        cArray2[70] = 70;
        cArray2[71] = 71;
        cArray2[72] = 72;
        cArray2[73] = 73;
        cArray2[74] = 74;
        cArray2[75] = 75;
        cArray2[76] = 76;
        cArray2[77] = 77;
        cArray2[78] = 78;
        cArray2[79] = 79;
        cArray2[80] = 80;
        cArray2[81] = 81;
        cArray2[82] = 82;
        cArray2[83] = 83;
        cArray2[84] = 84;
        cArray2[85] = 85;
        cArray2[86] = 86;
        cArray2[87] = 87;
        cArray2[88] = 88;
        cArray2[89] = 89;
        cArray2[90] = 90;
        cArray2[91] = 91;
        cArray2[92] = 92;
        cArray2[93] = 93;
        cArray2[94] = 94;
        cArray2[95] = 95;
        cArray2[96] = 96;
        cArray2[97] = 97;
        cArray2[98] = 98;
        cArray2[99] = 99;
        cArray2[100] = 100;
        cArray2[101] = 101;
        cArray2[102] = 102;
        cArray2[103] = 103;
        cArray2[104] = 104;
        cArray2[105] = 105;
        cArray2[106] = 106;
        cArray2[107] = 107;
        cArray2[108] = 108;
        cArray2[109] = 109;
        cArray2[110] = 110;
        cArray2[111] = 111;
        cArray2[112] = 112;
        cArray2[113] = 113;
        cArray2[114] = 114;
        cArray2[115] = 115;
        cArray2[116] = 116;
        cArray2[117] = 117;
        cArray2[118] = 118;
        cArray2[119] = 119;
        cArray2[120] = 120;
        cArray2[121] = 121;
        cArray2[122] = 122;
        cArray2[123] = 123;
        cArray2[124] = 124;
        cArray2[125] = 125;
        cArray2[126] = 126;
        cArray2[128] = 1026;
        cArray2[129] = 1027;
        cArray2[130] = 8218;
        cArray2[131] = 1107;
        cArray2[132] = 8222;
        cArray2[133] = 8230;
        cArray2[134] = 8224;
        cArray2[135] = 8225;
        cArray2[136] = 8364;
        cArray2[137] = 8240;
        cArray2[138] = 1033;
        cArray2[139] = 8249;
        cArray2[140] = 1034;
        cArray2[141] = 1036;
        cArray2[142] = 1035;
        cArray2[143] = 1039;
        cArray2[144] = 1106;
        cArray2[145] = 8216;
        cArray2[146] = 8217;
        cArray2[147] = 8220;
        cArray2[148] = 8221;
        cArray2[149] = 8226;
        cArray2[150] = 8211;
        cArray2[151] = 8212;
        cArray2[153] = 8482;
        cArray2[154] = 1113;
        cArray2[155] = 8250;
        cArray2[156] = 1114;
        cArray2[157] = 1116;
        cArray2[158] = 1115;
        cArray2[159] = 1119;
        cArray2[160] = 160;
        cArray2[161] = 1038;
        cArray2[162] = 1118;
        cArray2[163] = 1032;
        cArray2[164] = 164;
        cArray2[165] = 1168;
        cArray2[166] = 166;
        cArray2[167] = 167;
        cArray2[168] = 1025;
        cArray2[169] = 169;
        cArray2[170] = 1028;
        cArray2[171] = 171;
        cArray2[172] = 172;
        cArray2[173] = 173;
        cArray2[174] = 174;
        cArray2[175] = 1031;
        cArray2[176] = 176;
        cArray2[177] = 177;
        cArray2[178] = 1030;
        cArray2[179] = 1110;
        cArray2[180] = 1169;
        cArray2[181] = 181;
        cArray2[182] = 182;
        cArray2[183] = 183;
        cArray2[184] = 1105;
        cArray2[185] = 8470;
        cArray2[186] = 1108;
        cArray2[187] = 187;
        cArray2[188] = 1112;
        cArray2[189] = 1029;
        cArray2[190] = 1109;
        cArray2[191] = 1111;
        cArray2[192] = 1040;
        cArray2[193] = 1041;
        cArray2[194] = 1042;
        cArray2[195] = 1043;
        cArray2[196] = 1044;
        cArray2[197] = 1045;
        cArray2[198] = 1046;
        cArray2[199] = 1047;
        cArray2[200] = 1048;
        cArray2[201] = 1049;
        cArray2[202] = 1050;
        cArray2[203] = 1051;
        cArray2[204] = 1052;
        cArray2[205] = 1053;
        cArray2[206] = 1054;
        cArray2[207] = 1055;
        cArray2[208] = 1056;
        cArray2[209] = 1057;
        cArray2[210] = 1058;
        cArray2[211] = 1059;
        cArray2[212] = 1060;
        cArray2[213] = 1061;
        cArray2[214] = 1062;
        cArray2[215] = 1063;
        cArray2[216] = 1064;
        cArray2[217] = 1065;
        cArray2[218] = 1066;
        cArray2[219] = 1067;
        cArray2[220] = 1068;
        cArray2[221] = 1069;
        cArray2[222] = 1070;
        cArray2[223] = 1071;
        cArray2[224] = 1072;
        cArray2[225] = 1073;
        cArray2[226] = 1074;
        cArray2[227] = 1075;
        cArray2[228] = 1076;
        cArray2[229] = 1077;
        cArray2[230] = 1078;
        cArray2[231] = 1079;
        cArray2[232] = 1080;
        cArray2[233] = 1081;
        cArray2[234] = 1082;
        cArray2[235] = 1083;
        cArray2[236] = 1084;
        cArray2[237] = 1085;
        cArray2[238] = 1086;
        cArray2[239] = 1087;
        cArray2[240] = 1088;
        cArray2[241] = 1089;
        cArray2[242] = 1090;
        cArray2[243] = 1091;
        cArray2[244] = 1092;
        cArray2[245] = 1093;
        cArray2[246] = 1094;
        cArray2[247] = 1095;
        cArray2[248] = 1096;
        cArray2[249] = 1097;
        cArray2[250] = 1098;
        cArray2[251] = 1099;
        cArray2[252] = 1100;
        cArray2[253] = 1101;
        cArray2[254] = 1102;
        cArray2[255] = 1103;
        ADOBECYRILLIC_ENCODING = cArray2;
        TreeMap map = new TreeMap();
        UNICODE_GLYPHS = Glyphs.loadGlyphList("glyphlist.txt", map);
        DINGBATS_GLYPHS = Glyphs.loadGlyphList("zapfdingbats.txt", map);
        CHARNAMES_TO_UNICODE = Collections.unmodifiableMap(map);
        map = new TreeMap();
        Glyphs.addAlternatives(map, new String[]{"Omega", "Omegagreek"});
        Glyphs.addAlternatives(map, new String[]{"Delta", "Deltagreek"});
        Glyphs.addAlternatives(map, new String[]{"fraction", "divisionslash"});
        Glyphs.addAlternatives(map, new String[]{"hyphen", "sfthyphen", "softhyphen", "minus"});
        Glyphs.addAlternatives(map, new String[]{"macron", "overscore"});
        Glyphs.addAlternatives(map, new String[]{"mu", "mu1", "mugreek"});
        Glyphs.addAlternatives(map, new String[]{"periodcentered", "middot", "bulletoperator", "anoteleia"});
        Glyphs.addAlternatives(map, new String[]{"space", "nonbreakingspace", "nbspace"});
        Glyphs.addAlternatives(map, new String[]{"zero", "zerooldstyle"});
        Glyphs.addAlternatives(map, new String[]{"one", "oneoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"two", "twooldstyle"});
        Glyphs.addAlternatives(map, new String[]{"three", "threeoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"four", "fouroldstyle"});
        Glyphs.addAlternatives(map, new String[]{"five", "fiveoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"six", "sixoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"seven", "sevenoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"eight", "eightoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"nine", "nineoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"cent", "centoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"dollar", "dollaroldstyle"});
        Glyphs.addAlternatives(map, new String[]{"Acyrillic", "afii10017"});
        Glyphs.addAlternatives(map, new String[]{"Becyrillic", "afii10018"});
        Glyphs.addAlternatives(map, new String[]{"Vecyrillic", "afii10019"});
        Glyphs.addAlternatives(map, new String[]{"Gecyrillic", "afii10020"});
        Glyphs.addAlternatives(map, new String[]{"Decyrillic", "afii10021"});
        Glyphs.addAlternatives(map, new String[]{"Iecyrillic", "afii10022"});
        Glyphs.addAlternatives(map, new String[]{"Iocyrillic", "afii10023"});
        Glyphs.addAlternatives(map, new String[]{"Zhecyrillic", "afii10024"});
        Glyphs.addAlternatives(map, new String[]{"Zecyrillic", "afii10025"});
        Glyphs.addAlternatives(map, new String[]{"Iicyrillic", "afii10026"});
        Glyphs.addAlternatives(map, new String[]{"Iishortcyrillic", "afii10027"});
        Glyphs.addAlternatives(map, new String[]{"Kacyrillic", "afii10028"});
        Glyphs.addAlternatives(map, new String[]{"Elcyrillic", "afii10029"});
        Glyphs.addAlternatives(map, new String[]{"Emcyrillic", "afii10030"});
        Glyphs.addAlternatives(map, new String[]{"Encyrillic", "afii10031"});
        Glyphs.addAlternatives(map, new String[]{"Ocyrillic", "afii10032"});
        Glyphs.addAlternatives(map, new String[]{"Pecyrillic", "afii10033"});
        Glyphs.addAlternatives(map, new String[]{"Ercyrillic", "afii10034"});
        Glyphs.addAlternatives(map, new String[]{"Escyrillic", "afii10035"});
        Glyphs.addAlternatives(map, new String[]{"Tecyrillic", "afii10036"});
        Glyphs.addAlternatives(map, new String[]{"Ucyrillic", "afii10037"});
        Glyphs.addAlternatives(map, new String[]{"Efcyrillic", "afii10038"});
        Glyphs.addAlternatives(map, new String[]{"Khacyrillic", "afii10039"});
        Glyphs.addAlternatives(map, new String[]{"Tsecyrillic", "afii10040"});
        Glyphs.addAlternatives(map, new String[]{"Checyrillic", "afii10041"});
        Glyphs.addAlternatives(map, new String[]{"Shacyrillic", "afii10042"});
        Glyphs.addAlternatives(map, new String[]{"Shchacyrillic", "afii10043"});
        Glyphs.addAlternatives(map, new String[]{"Hardsigncyrillic", "afii10044"});
        Glyphs.addAlternatives(map, new String[]{"Yericyrillic", "afii10045"});
        Glyphs.addAlternatives(map, new String[]{"Softsigncyrillic", "afii10046"});
        Glyphs.addAlternatives(map, new String[]{"Ereversedcyrillic", "afii10047"});
        Glyphs.addAlternatives(map, new String[]{"IUcyrillic", "afii10048"});
        Glyphs.addAlternatives(map, new String[]{"IAcyrillic", "afii10049"});
        Glyphs.addAlternatives(map, new String[]{"acyrillic", "afii10065"});
        Glyphs.addAlternatives(map, new String[]{"becyrillic", "afii10066"});
        Glyphs.addAlternatives(map, new String[]{"vecyrillic", "afii10067"});
        Glyphs.addAlternatives(map, new String[]{"gecyrillic", "afii10068"});
        Glyphs.addAlternatives(map, new String[]{"decyrillic", "afii10069"});
        Glyphs.addAlternatives(map, new String[]{"iecyrillic", "afii10070"});
        Glyphs.addAlternatives(map, new String[]{"iocyrillic", "afii10071"});
        Glyphs.addAlternatives(map, new String[]{"zhecyrillic", "afii10072"});
        Glyphs.addAlternatives(map, new String[]{"zecyrillic", "afii10073"});
        Glyphs.addAlternatives(map, new String[]{"iicyrillic", "afii10074"});
        Glyphs.addAlternatives(map, new String[]{"iishortcyrillic", "afii10075"});
        Glyphs.addAlternatives(map, new String[]{"kacyrillic", "afii10076"});
        Glyphs.addAlternatives(map, new String[]{"elcyrillic", "afii10077"});
        Glyphs.addAlternatives(map, new String[]{"emcyrillic", "afii10078"});
        Glyphs.addAlternatives(map, new String[]{"encyrillic", "afii10079"});
        Glyphs.addAlternatives(map, new String[]{"ocyrillic", "afii10080"});
        Glyphs.addAlternatives(map, new String[]{"pecyrillic", "afii10081"});
        Glyphs.addAlternatives(map, new String[]{"ercyrillic", "afii10082"});
        Glyphs.addAlternatives(map, new String[]{"escyrillic", "afii10083"});
        Glyphs.addAlternatives(map, new String[]{"tecyrillic", "afii10084"});
        Glyphs.addAlternatives(map, new String[]{"ucyrillic", "afii10085"});
        Glyphs.addAlternatives(map, new String[]{"efcyrillic", "afii10086"});
        Glyphs.addAlternatives(map, new String[]{"khacyrillic", "afii10087"});
        Glyphs.addAlternatives(map, new String[]{"tsecyrillic", "afii10088"});
        Glyphs.addAlternatives(map, new String[]{"checyrillic", "afii10089"});
        Glyphs.addAlternatives(map, new String[]{"shacyrillic", "afii10090"});
        Glyphs.addAlternatives(map, new String[]{"shchacyrillic", "afii10091"});
        Glyphs.addAlternatives(map, new String[]{"hardsigncyrillic", "afii10092"});
        Glyphs.addAlternatives(map, new String[]{"yericyrillic", "afii10093"});
        Glyphs.addAlternatives(map, new String[]{"softsigncyrillic", "afii10094"});
        Glyphs.addAlternatives(map, new String[]{"ereversedcyrillic", "afii10095"});
        Glyphs.addAlternatives(map, new String[]{"iucyrillic", "afii10096"});
        Glyphs.addAlternatives(map, new String[]{"iacyrillic", "afii10097"});
        Glyphs.addAlternatives(map, new String[]{"Gheupturncyrillic", "afii10050"});
        Glyphs.addAlternatives(map, new String[]{"Djecyrillic", "afii10051"});
        Glyphs.addAlternatives(map, new String[]{"Gjecyrillic", "afii10052"});
        Glyphs.addAlternatives(map, new String[]{"Ecyrillic", "afii10053"});
        Glyphs.addAlternatives(map, new String[]{"Dzecyrillic", "afii10054"});
        Glyphs.addAlternatives(map, new String[]{"Icyrillic", "afii10055"});
        Glyphs.addAlternatives(map, new String[]{"Yicyrillic", "afii10056"});
        Glyphs.addAlternatives(map, new String[]{"Jecyrillic", "afii10057"});
        Glyphs.addAlternatives(map, new String[]{"Ljecyrillic", "afii10058"});
        Glyphs.addAlternatives(map, new String[]{"Njecyrillic", "afii10059"});
        Glyphs.addAlternatives(map, new String[]{"Tshecyrillic", "afii10060"});
        Glyphs.addAlternatives(map, new String[]{"Kjecyrillic", "afii10061"});
        Glyphs.addAlternatives(map, new String[]{"Ushortcyrillic", "afii10062"});
        Glyphs.addAlternatives(map, new String[]{"Dzhecyrillic", "afii10145"});
        Glyphs.addAlternatives(map, new String[]{"Yatcyrillic", "afii10146"});
        Glyphs.addAlternatives(map, new String[]{"Fitacyrillic", "afii10147"});
        Glyphs.addAlternatives(map, new String[]{"Izhitsacyrillic", "afii10148"});
        Glyphs.addAlternatives(map, new String[]{"gheupturncyrillic", "afii10098"});
        Glyphs.addAlternatives(map, new String[]{"djecyrillic", "afii10099"});
        Glyphs.addAlternatives(map, new String[]{"gjecyrillic", "afii10100"});
        Glyphs.addAlternatives(map, new String[]{"ecyrillic", "afii10101"});
        Glyphs.addAlternatives(map, new String[]{"dzecyrillic", "afii10102"});
        Glyphs.addAlternatives(map, new String[]{"icyrillic", "afii10103"});
        Glyphs.addAlternatives(map, new String[]{"yicyrillic", "afii10104"});
        Glyphs.addAlternatives(map, new String[]{"jecyrillic", "afii10105"});
        Glyphs.addAlternatives(map, new String[]{"ljecyrillic", "afii10106"});
        Glyphs.addAlternatives(map, new String[]{"njecyrillic", "afii10107"});
        Glyphs.addAlternatives(map, new String[]{"tshecyrillic", "afii10108"});
        Glyphs.addAlternatives(map, new String[]{"kjecyrillic", "afii10109"});
        Glyphs.addAlternatives(map, new String[]{"ushortcyrillic", "afii10110"});
        Glyphs.addAlternatives(map, new String[]{"dzhecyrillic", "afii10193"});
        Glyphs.addAlternatives(map, new String[]{"yatcyrillic", "afii10194"});
        Glyphs.addAlternatives(map, new String[]{"fitacyrillic", "afii10195"});
        Glyphs.addAlternatives(map, new String[]{"izhitsacyrillic", "afii10196"});
        CHARNAME_ALTERNATIVES = Collections.unmodifiableMap(map);
    }

    private Glyphs() {
    }

    private static void addAlternatives(Map map, String[] alternatives) {
        int i = 0;
        int c = alternatives.length;
        while (i < c) {
            String[] alt = new String[c - 1];
            int idx = 0;
            int j = 0;
            while (j < c) {
                if (i != j) {
                    alt[idx] = alternatives[j];
                    ++idx;
                }
                ++j;
            }
            map.put(alternatives[i], alt);
            ++i;
        }
    }

    private static String[] loadGlyphList(String filename, Map charNameToUnicodeMap) {
        ArrayList<String> lines = new ArrayList<String>();
        InputStream in = Glyphs.class.getResourceAsStream(filename);
        if (in == null) {
            throw new RuntimeException("Cannot load " + filename + ". The Glyphs class cannot properly be initialized!");
        }
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "US-ASCII"));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    lines.add(line);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Incompatible JVM! US-ASCII encoding is not supported. The Glyphs class cannot properly be initialized!");
            }
            catch (IOException iOException) {
                throw new RuntimeException("I/O error while loading " + filename + ". The Glyphs class cannot properly be initialized!");
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        String[] arr = new String[lines.size() * 2];
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        for (Object e : lines) {
            String unicode;
            String line = (String)e;
            int semicolon = line.indexOf(59);
            if (semicolon <= 0) continue;
            String charName = line.substring(0, semicolon);
            String rawUnicode = line.substring(semicolon + 1);
            buf.setLength(0);
            StringTokenizer tokenizer = new StringTokenizer(rawUnicode, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                assert (token.length() == 4);
                buf.append(Glyphs.hexToChar(token));
            }
            arr[pos] = unicode = buf.toString();
            arr[++pos] = charName;
            ++pos;
            assert (!charNameToUnicodeMap.containsKey(charName));
            charNameToUnicodeMap.put(charName, unicode);
        }
        return arr;
    }

    private static char hexToChar(String hex) {
        return (char)Integer.parseInt(hex, 16);
    }

    public static String charToGlyphName(char ch) {
        return Glyphs.stringToGlyph(Character.toString(ch));
    }

    public static String getUnicodeSequenceForGlyphName(String glyphName) {
        int period = glyphName.indexOf(46);
        if (period >= 0) {
            glyphName = glyphName.substring(0, period);
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(glyphName, "_", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String sequence = (String)CHARNAMES_TO_UNICODE.get(token);
            if (sequence == null) {
                if (token.startsWith("uni")) {
                    int len = token.length();
                    int pos = 3;
                    while (pos + 4 <= len) {
                        try {
                            sb.append(Glyphs.hexToChar(token.substring(pos, pos + 4)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                        pos += 4;
                    }
                    continue;
                }
                if (!token.startsWith("u")) continue;
                if (token.length() > 5) {
                    return null;
                }
                if (token.length() < 5) {
                    return null;
                }
                try {
                    sb.append(Glyphs.hexToChar(token.substring(1, 5)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            sb.append(sequence);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    @Deprecated
    public static String glyphToString(String name) {
        int i = 0;
        while (i < UNICODE_GLYPHS.length) {
            if (UNICODE_GLYPHS[i + 1].equals(name)) {
                return UNICODE_GLYPHS[i];
            }
            i += 2;
        }
        return "";
    }

    public static String stringToGlyph(String name) {
        int i = 0;
        while (i < UNICODE_GLYPHS.length) {
            if (UNICODE_GLYPHS[i].equals(name)) {
                return UNICODE_GLYPHS[i + 1];
            }
            i += 2;
        }
        i = 0;
        while (i < DINGBATS_GLYPHS.length) {
            if (DINGBATS_GLYPHS[i].equals(name)) {
                return DINGBATS_GLYPHS[i + 1];
            }
            i += 2;
        }
        return "";
    }

    public static String[] getCharNameAlternativesFor(String charName) {
        return (String[])CHARNAME_ALTERNATIVES.get(charName);
    }
}

