/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoader;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.JPEGConstants;
import org.apache.xmlgraphics.image.loader.impl.JPEGFile;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.io.XmlSourceUtil;
import org.apache.xmlgraphics.java2d.color.ColorSpaces;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class ImageLoaderRawJPEG
extends AbstractImageLoader
implements JPEGConstants {
    protected static final Log log = LogFactory.getLog(ImageLoaderRawJPEG.class);

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.RAW_JPEG;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Image loadImage(ImageInfo info, Map hints, ImageSessionContext session) throws ImageException, IOException {
        Source src;
        ByteArrayOutputStream iccStream;
        int sofType;
        boolean appeFound;
        ColorSpace colorSpace;
        block36: {
            if (!"image/jpeg".equals(info.getMimeType())) {
                throw new IllegalArgumentException("ImageInfo must be from a image with MIME type: image/jpeg");
            }
            colorSpace = null;
            appeFound = false;
            sofType = 0;
            iccStream = null;
            src = session.needSource(info.getOriginalURI());
            ImageInputStream in = ImageUtil.needImageInputStream(src);
            JPEGFile jpeg = new JPEGFile(in);
            in.mark();
            try {
                while (true) {
                    int segID = jpeg.readMarkerSegment();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Seg Marker: " + Integer.toHexString(segID)));
                    }
                    switch (segID) {
                        case 217: {
                            log.trace((Object)"EOI found. Stopping.");
                            break block36;
                        }
                        case 218: {
                            log.trace((Object)"SOS found. Stopping early.");
                            break block36;
                        }
                        case 0: 
                        case 216: {
                            break;
                        }
                        case 192: 
                        case 193: 
                        case 194: 
                        case 202: {
                            int reclen;
                            sofType = segID;
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("SOF: " + Integer.toHexString(sofType)));
                            }
                            in.mark();
                            try {
                                reclen = jpeg.readSegmentLength();
                                in.skipBytes(1);
                                in.skipBytes(2);
                                in.skipBytes(2);
                                int numComponents = in.readUnsignedByte();
                                if (numComponents == 1) {
                                    colorSpace = ColorSpace.getInstance(1003);
                                } else if (numComponents == 3) {
                                    colorSpace = ColorSpace.getInstance(1004);
                                } else {
                                    if (numComponents != 4) throw new ImageException("Unsupported ColorSpace for image " + info + ". The number of components supported are 1, 3 and 4.");
                                    colorSpace = ColorSpaces.getDeviceCMYKColorSpace();
                                }
                            }
                            finally {
                                in.reset();
                            }
                            in.skipBytes(reclen);
                            break;
                        }
                        case 226: {
                            int reclen;
                            in.mark();
                            try {
                                reclen = jpeg.readSegmentLength();
                                byte[] iccString = new byte[11];
                                in.readFully(iccString);
                                in.skipBytes(1);
                                if ("ICC_PROFILE".equals(new String(iccString, "US-ASCII"))) {
                                    in.skipBytes(2);
                                    int payloadSize = reclen - 2 - 12 - 2;
                                    if (this.ignoreColorProfile(hints)) {
                                        log.debug((Object)"Ignoring ICC profile data in JPEG");
                                        in.skipBytes(payloadSize);
                                    } else {
                                        byte[] buf = new byte[payloadSize];
                                        in.readFully(buf);
                                        if (iccStream == null) {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)"JPEG has an ICC profile");
                                                DataInputStream din = new DataInputStream(new ByteArrayInputStream(buf));
                                                log.debug((Object)("Declared ICC profile size: " + din.readInt()));
                                            }
                                            iccStream = new ByteArrayOutputStream();
                                        }
                                        iccStream.write(buf);
                                    }
                                }
                            }
                            finally {
                                in.reset();
                            }
                            in.skipBytes(reclen);
                            break;
                        }
                        case 238: {
                            int reclen;
                            in.mark();
                            try {
                                reclen = jpeg.readSegmentLength();
                                byte[] adobeHeader = new byte[5];
                                in.readFully(adobeHeader);
                                if ("Adobe".equals(new String(adobeHeader, "US-ASCII"))) {
                                    appeFound = true;
                                }
                            }
                            finally {
                                in.reset();
                            }
                            in.skipBytes(reclen);
                            break;
                        }
                        default: {
                            jpeg.skipCurrentMarkerSegment();
                            break;
                        }
                    }
                }
            }
            finally {
                in.reset();
            }
        }
        ICC_Profile iccProfile = this.buildICCProfile(info, colorSpace, iccStream);
        if (iccProfile == null && colorSpace == null) {
            throw new ImageException("ColorSpace could not be identified for JPEG image " + info);
        }
        boolean invertImage = false;
        if (!appeFound) return new ImageRawJPEG(info, XmlSourceUtil.needInputStream(src), sofType, colorSpace, iccProfile, invertImage);
        if (colorSpace.getType() != 9) return new ImageRawJPEG(info, XmlSourceUtil.needInputStream(src), sofType, colorSpace, iccProfile, invertImage);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JPEG has an Adobe APPE marker. Note: CMYK Image will be inverted. (" + info.getOriginalURI() + ")"));
        }
        invertImage = true;
        return new ImageRawJPEG(info, XmlSourceUtil.needInputStream(src), sofType, colorSpace, iccProfile, invertImage);
    }

    private ICC_Profile buildICCProfile(ImageInfo info, ColorSpace colorSpace, ByteArrayOutputStream iccStream) throws IOException, ImageException {
        if (iccStream != null && iccStream.size() > 0) {
            int padding;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Effective ICC profile size: " + iccStream.size()));
            }
            if ((padding = (4 - iccStream.size() % 4) % 4) != 0) {
                try {
                    iccStream.write(new byte[padding]);
                }
                catch (IOException ioe) {
                    throw new IOException("Error while aligning ICC stream: " + ioe.getMessage());
                }
            }
            ICC_Profile iccProfile = null;
            try {
                iccProfile = ColorProfileUtil.getICC_Profile(iccStream.toByteArray());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JPEG has an ICC profile: " + iccProfile.toString()));
                }
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)("An ICC profile is present in the JPEG file but it is invalid (" + iae.getMessage() + "). The color profile will be ignored. (" + info.getOriginalURI() + ")"));
                return null;
            }
            if (iccProfile.getNumComponents() != colorSpace.getNumComponents()) {
                log.warn((Object)("The number of components of the ICC profile (" + iccProfile.getNumComponents() + ") doesn't match the image (" + colorSpace.getNumComponents() + "). Ignoring the ICC color profile."));
                return null;
            }
            return iccProfile;
        }
        return null;
    }
}

