/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ess;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificate
extends ASN1Object {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static SigningCertificate getInstance(Object o) {
        if (o instanceof SigningCertificate) {
            return (SigningCertificate)((Object)o);
        }
        if (o != null) {
            return new SigningCertificate(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    private SigningCertificate(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.certs = ASN1Sequence.getInstance((Object)seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.policies = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
        }
    }

    public SigningCertificate(ESSCertID essCertID) {
        this.certs = new DERSequence((ASN1Encodable)essCertID);
    }

    public ESSCertID[] getCerts() {
        ESSCertID[] cs = new ESSCertID[this.certs.size()];
        int i = 0;
        while (i != this.certs.size()) {
            cs[i] = ESSCertID.getInstance(this.certs.getObjectAt(i));
            ++i;
        }
        return cs;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] ps = new PolicyInformation[this.policies.size()];
        int i = 0;
        while (i != this.policies.size()) {
            ps[i] = PolicyInformation.getInstance((Object)this.policies.getObjectAt(i));
            ++i;
        }
        return ps;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add((ASN1Encodable)this.certs);
        if (this.policies != null) {
            v.add((ASN1Encodable)this.policies);
        }
        return new DERSequence(v);
    }
}

