/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;

public class ArchiveTimeStampChain
extends ASN1Object {
    private ASN1Sequence archiveTimeStamps;

    public static ArchiveTimeStampChain getInstance(Object obj) {
        if (obj instanceof ArchiveTimeStampChain) {
            return (ArchiveTimeStampChain)((Object)obj);
        }
        if (obj != null) {
            return new ArchiveTimeStampChain(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public ArchiveTimeStampChain(ArchiveTimeStamp archiveTimeStamp) {
        this.archiveTimeStamps = new DERSequence((ASN1Encodable)archiveTimeStamp);
    }

    public ArchiveTimeStampChain(ArchiveTimeStamp[] archiveTimeStamps) {
        this.archiveTimeStamps = new DERSequence((ASN1Encodable[])archiveTimeStamps);
    }

    private ArchiveTimeStampChain(ASN1Sequence sequence) {
        ASN1EncodableVector vector = new ASN1EncodableVector(sequence.size());
        Enumeration objects = sequence.getObjects();
        while (objects.hasMoreElements()) {
            vector.add((ASN1Encodable)ArchiveTimeStamp.getInstance(objects.nextElement()));
        }
        this.archiveTimeStamps = new DERSequence(vector);
    }

    public ArchiveTimeStamp[] getArchiveTimestamps() {
        ArchiveTimeStamp[] rv = new ArchiveTimeStamp[this.archiveTimeStamps.size()];
        int i = 0;
        while (i != rv.length) {
            rv[i] = ArchiveTimeStamp.getInstance(this.archiveTimeStamps.getObjectAt(i));
            ++i;
        }
        return rv;
    }

    public ArchiveTimeStampChain append(ArchiveTimeStamp archiveTimeStamp) {
        ASN1EncodableVector v = new ASN1EncodableVector(this.archiveTimeStamps.size() + 1);
        int i = 0;
        while (i != this.archiveTimeStamps.size()) {
            v.add(this.archiveTimeStamps.getObjectAt(i));
            ++i;
        }
        v.add((ASN1Encodable)archiveTimeStamp);
        return new ArchiveTimeStampChain((ASN1Sequence)new DERSequence(v));
    }

    public ASN1Primitive toASN1Primitive() {
        return this.archiveTimeStamps;
    }
}

