/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class PartialHashtree
extends ASN1Object {
    private final ASN1Sequence values;

    public static PartialHashtree getInstance(Object obj) {
        if (obj instanceof PartialHashtree) {
            return (PartialHashtree)((Object)obj);
        }
        if (obj != null) {
            return new PartialHashtree(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence values) {
        int i = 0;
        while (i != values.size()) {
            if (!(values.getObjectAt(i) instanceof ASN1OctetString)) {
                throw new IllegalArgumentException("unknown object in constructor: " + values.getObjectAt(i).getClass().getName());
            }
            ++i;
        }
        this.values = values;
    }

    public PartialHashtree(byte[] values) {
        this(new byte[][]{values});
    }

    public PartialHashtree(byte[][] values) {
        ASN1EncodableVector v = new ASN1EncodableVector(values.length);
        int i = 0;
        while (i != values.length) {
            v.add((ASN1Encodable)new DEROctetString(Arrays.clone((byte[])values[i])));
            ++i;
        }
        this.values = new DERSequence(v);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public byte[][] getValues() {
        byte[][] rv = new byte[this.values.size()][];
        int i = 0;
        while (i != rv.length) {
            rv[i] = Arrays.clone((byte[])ASN1OctetString.getInstance((Object)this.values.getObjectAt(i)).getOctets());
            ++i;
        }
        return rv;
    }

    public boolean containsHash(byte[] hash) {
        Enumeration hashes = this.values.getObjects();
        while (hashes.hasMoreElements()) {
            byte[] currentHash = ASN1OctetString.getInstance(hashes.nextElement()).getOctets();
            if (!Arrays.constantTimeAreEqual((byte[])hash, (byte[])currentHash)) continue;
            return true;
        }
        return false;
    }

    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

