/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.controlsfx.propertysheet;

import de.elpro.ui.controlsfx.propertysheet.ActionButton;
import de.elpro.ui.controlsfx.propertysheet.ActionItem;
import de.elpro.ui.controlsfx.propertysheet.Messages;
import de.elpro.ui.controlsfx.propertysheet.ValidatableItem;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import jidefx.scene.control.validation.Validator;

public abstract class PropertyItem<T>
implements ValidatableItem,
ActionItem {
    public static final Object NULL_OBJECT = new NullObject();
    public static final String DEFAULT_CATEGORY = Messages.getString("PropertyItem.DefaultCategory");
    private String category;
    private final String name;
    private final String description;
    private final ObservableValue<T> valueProperty;
    private final ObjectProperty<Node> editorProperty = new SimpleObjectProperty();
    private final BooleanProperty hasChangesProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty invalidProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty readOnlyProperty = new SimpleBooleanProperty();
    private final BooleanProperty hiddenProperty = new SimpleBooleanProperty();
    private Double editorMinHeight = null;
    private Double editorPrefHeight = null;
    private Double editorMaxHeight = null;
    private Priority editorVgrow = null;
    private final ObservableList<ActionButton> actionButtons = FXCollections.observableArrayList();
    private final ObjectProperty<Orientation> actionButtonsOrientation = new SimpleObjectProperty((Object)Orientation.HORIZONTAL);
    private T initialValue;
    private StringProperty promptText = new SimpleStringProperty();
    private Validator validator = null;

    public PropertyItem(String category, String name, String description, ObservableValue<T> valueProperty) {
        this.category = category != null ? category : DEFAULT_CATEGORY;
        this.name = name;
        this.description = description;
        this.valueProperty = valueProperty;
        this.initialValue = valueProperty.getValue();
        valueProperty.addListener((o, ov, nv) -> {
            if (nv == null && this.initialValue == null) {
                this.hasChangesProperty.set(false);
            } else if (nv == null) {
                this.hasChangesProperty.set(true);
            } else {
                this.hasChangesProperty.set(!nv.equals(this.initialValue));
            }
        });
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyProperty().set(readOnly);
    }

    public boolean isReadOnly() {
        return this.readOnlyProperty().get();
    }

    public BooleanProperty readOnlyProperty() {
        return this.readOnlyProperty;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category == null ? DEFAULT_CATEGORY : category;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getPromptText() {
        return (String)this.promptTextProperty().get();
    }

    public void setPromptText(String promptText) {
        this.promptTextProperty().set((Object)promptText);
    }

    public StringProperty promptTextProperty() {
        return this.promptText;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return this.valueProperty.getValue();
    }

    @Override
    public void setValue(Object arg0) {
        if (this.valueProperty instanceof WritableValue) {
            WritableValue writableValue = (WritableValue)this.valueProperty;
            if (writableValue instanceof Property && ((Property)writableValue).isBound()) {
                return;
            }
            if (arg0 == NULL_OBJECT) {
                writableValue.setValue(null);
            } else {
                writableValue.setValue(arg0);
            }
        }
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    public void forceValidate() {
        if (this.getEditor() != null && this.validator != null) {
            ValidationUtils.forceValidate(this.getEditor(), ValidationMode.ON_FLY);
        }
    }

    @Override
    public ReadOnlyBooleanProperty invalidProperty() {
        return this.invalidProperty;
    }

    @Override
    public void unbindInvalidProperty() {
        this.invalidProperty.unbind();
        this.invalidProperty.set(false);
    }

    @Override
    public void bindInvalidProperty(ReadOnlyBooleanProperty invalidProperty) {
        this.invalidProperty.bind((ObservableValue)invalidProperty);
    }

    public final ObservableValue<T> valueProperty() {
        return this.valueProperty;
    }

    public boolean isHidden() {
        return this.hiddenProperty().get();
    }

    public void setHidden(boolean isHidden) {
        this.hiddenProperty().set(isHidden);
    }

    public BooleanProperty hiddenProperty() {
        return this.hiddenProperty;
    }

    public Double getEditorMinHeight() {
        return this.editorMinHeight;
    }

    public void setEditorMinHeight(Double editorMinHeight) {
        this.editorMinHeight = editorMinHeight;
    }

    public Double getEditorPrefHeight() {
        return this.editorPrefHeight;
    }

    public void setEditorPrefHeight(Double editorPrefHeight) {
        this.editorPrefHeight = editorPrefHeight;
    }

    public Double getEditorMaxHeight() {
        return this.editorMaxHeight;
    }

    public void setEditorMaxHeight(Double editorMaxHeight) {
        this.editorMaxHeight = editorMaxHeight;
    }

    public Priority getEditorVgrow() {
        return this.editorVgrow;
    }

    public void setEditorVgrow(Priority editorVgrow) {
        this.editorVgrow = editorVgrow;
    }

    @Override
    public boolean isEditable() {
        return !this.isReadOnly() && this.valueProperty instanceof WritableValue;
    }

    @Override
    public Optional<ObservableValue<? extends Object>> getObservableValue() {
        return Optional.of(this.valueProperty);
    }

    @Override
    public ObservableList<ActionButton> getActionButtons() {
        return this.actionButtons;
    }

    @Override
    public ObjectProperty<Orientation> actionButtonsOrientationProperty() {
        return this.actionButtonsOrientation;
    }

    @Override
    public Orientation getActionButtonsOrientation() {
        return (Orientation)this.actionButtonsOrientationProperty().get();
    }

    @Override
    public void setActionButtonsOrientation(Orientation orientation) {
        this.actionButtonsOrientationProperty().set((Object)orientation);
    }

    protected void setHasChanges(boolean hasChanges) {
        this.hasChangesProperty.set(hasChanges);
    }

    public final void resetChanges() {
        this.initialValue = this.getValue();
        this.hasChangesProperty.set(false);
    }

    public final ReadOnlyBooleanProperty hasChangesProperty() {
        return ReadOnlyBooleanWrapper.readOnlyBooleanProperty((ReadOnlyProperty)this.hasChangesProperty);
    }

    public void setEditor(Node editor) {
        this.editorProperty.set((Object)editor);
    }

    @Override
    public Node getEditor() {
        return (Node)this.editorProperty.get();
    }

    public Property<Node> editorProperty() {
        return this.editorProperty;
    }

    private static class NullObject
    implements Comparable<Object> {
        private NullObject() {
        }

        public String toString() {
            return null;
        }

        @Override
        public int compareTo(Object o) {
            if (this.equals(o)) {
                return 0;
            }
            return -1;
        }
    }
}

