/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ui.controlsfx.skins;

import de.elpro.ui.controlsfx.propertysheet.ActionButton;
import de.elpro.ui.controlsfx.propertysheet.ActionItem;
import de.elpro.ui.controlsfx.propertysheet.PageItem;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.controlsfx.propertysheet.ValidatableItem;
import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import jidefx.scene.control.decoration.DecorationPane;
import jidefx.scene.control.validation.ValidationGroup;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationUtils;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.PropertyEditor;
import org.controlsfx.tools.Borders;

public class PropertySheetSkin
extends SkinBase<PropertySheet> {
    private static final int MIN_COLUMN_WIDTH = 100;
    private static final String TAB_ERROR_CSS_CLASS = "tab-error";
    private final BorderPane content;
    private final ToolBar toolbar;
    private final SegmentedButton modeButton = ActionUtils.createSegmentedButton(new ActionChangeMode(PropertySheet.Mode.NAME), new ActionChangeMode(PropertySheet.Mode.CATEGORY));
    private final TextField searchField = TextFields.createClearableTextField();

    public PropertySheetSkin(PropertySheet control) {
        super((Control)control);
        this.toolbar = new ToolBar();
        this.toolbar.managedProperty().bind((ObservableValue)this.toolbar.visibleProperty());
        this.toolbar.setFocusTraversable(true);
        this.modeButton.managedProperty().bind((ObservableValue)this.modeButton.visibleProperty());
        ((ToggleButton)this.modeButton.getButtons().get(((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())).ordinal())).setSelected(true);
        this.toolbar.getItems().add((Object)this.modeButton);
        this.searchField.setPromptText(Localization.localize(Localization.asKey("property.sheet.search.field.prompt")));
        this.searchField.setMinWidth(0.0);
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.SOMETIMES);
        this.searchField.managedProperty().bind((ObservableValue)this.searchField.visibleProperty());
        this.toolbar.getItems().add((Object)this.searchField);
        this.content = new BorderPane();
        this.content.setTop((Node)this.toolbar);
        this.getChildren().add((Object)this.content);
        this.registerChangeListener((ObservableValue)control.modeProperty(), e -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)control.propertyEditorFactory(), e -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)control.titleFilter(), e -> this.refreshProperties());
        this.registerChangeListener((ObservableValue)this.searchField.textProperty(), e -> ((PropertySheet)this.getSkinnable()).setTitleFilter(this.searchField.getText()));
        this.registerChangeListener((ObservableValue)control.modeSwitcherVisibleProperty(), e -> this.updateToolbar());
        this.registerChangeListener((ObservableValue)control.searchBoxVisibleProperty(), e -> this.updateToolbar());
        this.registerChangeListener((ObservableValue)control.categoryComparatorProperty(), e -> this.refreshProperties());
        control.getItems().addListener(change -> this.refreshProperties());
        this.refreshProperties();
        this.updateToolbar();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private void updateToolbar() {
        this.modeButton.setVisible(((PropertySheet)this.getSkinnable()).isModeSwitcherVisible());
        this.searchField.setVisible(((PropertySheet)this.getSkinnable()).isSearchBoxVisible());
        this.toolbar.setVisible(this.modeButton.isVisible() || this.searchField.isVisible());
    }

    private void refreshProperties() {
        this.content.setCenter(this.buildPropertySheetContainer());
    }

    private Node buildPropertySheetContainer() {
        LinkedList<String> categories = new LinkedList<String>();
        TreeMap<Object, ArrayList<PropertySheet.Item>> categoryMap = new TreeMap<Object, ArrayList<PropertySheet.Item>>();
        for (PropertySheet.Item p : ((PropertySheet)this.getSkinnable()).getItems()) {
            ArrayList<PropertySheet.Item> list;
            Object category = p.getCategory();
            if (category == null) {
                category = "";
            }
            if (!categories.contains(category)) {
                categories.add((String)category);
            }
            if ((list = (ArrayList<PropertySheet.Item>)categoryMap.get(category)) == null) {
                list = new ArrayList<PropertySheet.Item>();
                categoryMap.put(category, list);
            }
            list.add(p);
        }
        switch ((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())) {
            case CATEGORY: {
                TabPane tabPane = new TabPane();
                tabPane.setSide(Side.BOTTOM);
                for (String category : categories) {
                    Tab tab = new Tab(category);
                    List items = (List)categoryMap.get(category);
                    ScrollPane scrollPane = null;
                    if (items.size() == 1 && items.get(0) instanceof PageItem && ((PageItem)items.get(0)).getEditor() != null) {
                        PageItem pageItem = (PageItem)items.get(0);
                        Node editor = pageItem.getEditor();
                        scrollPane = new ScrollPane((Node)new BorderPane(editor));
                        scrollPane.setFitToHeight(true);
                        if (pageItem.getValidator() != null) {
                            ValidationUtils.install(editor, pageItem.getObservableValue().get(), pageItem.getValidator(), ValidationMode.ON_FLY);
                            ValidationGroup validationGroup = new ValidationGroup(editor);
                            pageItem.bindInvalidProperty(validationGroup.invalidProperty());
                            ValidationUtils.forceValidate(editor, ValidationMode.ON_FLY);
                        }
                    } else {
                        PropertyPane props = new PropertyPane(items);
                        scrollPane = new ScrollPane((Node)props);
                    }
                    LinkedList<ValidatableItem> validatableItems = new LinkedList<ValidatableItem>();
                    for (PropertySheet.Item item : items) {
                        ValidatableItem validatableItem;
                        if (!(item instanceof ValidatableItem) || (validatableItem = (ValidatableItem)item).getValidator() == null) continue;
                        validatableItems.add(validatableItem);
                    }
                    if (!validatableItems.isEmpty()) {
                        Runnable checkTabErrors = () -> {
                            for (ValidatableItem validatableItem : validatableItems) {
                                if (!validatableItem.invalidProperty().get()) continue;
                                if (!tab.getStyleClass().contains((Object)TAB_ERROR_CSS_CLASS)) {
                                    tab.getStyleClass().add((Object)TAB_ERROR_CSS_CLASS);
                                }
                                return;
                            }
                            tab.getStyleClass().remove((Object)TAB_ERROR_CSS_CLASS);
                        };
                        validatableItems.forEach(vi -> vi.invalidProperty().addListener(il -> checkTabErrors.run()));
                        checkTabErrors.run();
                    }
                    scrollPane.setFitToWidth(true);
                    scrollPane.setFitToHeight(true);
                    tab.setClosable(false);
                    tab.setContent((Node)new DecorationPane((Parent)scrollPane));
                    tabPane.getTabs().add((Object)tab);
                }
                return tabPane;
            }
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        if (categories.size() > 1) {
            VBox gridPane = new VBox(5.0);
            for (Object category : categories) {
                if (!((String)category).isEmpty()) {
                    Node group = Borders.wrap((Node)new PropertyPane((List)categoryMap.get(category))).lineBorder().innerPadding(3.0, 0.0, 3.0, 0.0).outerPadding(10.0, 3.0, 0.0, 3.0).title((String)category).thickness(1.0).radius(0.0, 5.0, 5.0, 0.0).buildAll();
                    gridPane.getChildren().add((Object)group);
                    continue;
                }
                PropertyPane pane = new PropertyPane((List)categoryMap.get(category));
                gridPane.getChildren().add((Object)pane);
            }
            scrollPane.setContent((Node)gridPane);
        } else {
            PropertyPane pane = new PropertyPane((List<PropertySheet.Item>)((PropertySheet)this.getSkinnable()).getItems());
            scrollPane.setContent((Node)pane);
        }
        return new DecorationPane((Parent)scrollPane);
    }

    private class ActionChangeMode
    extends Action {
        private final Image CATEGORY_IMAGE;
        private final Image NAME_IMAGE;

        public ActionChangeMode(PropertySheet.Mode mode) {
            super("");
            this.CATEGORY_IMAGE = new Image("/de/elpro/ui/controlsfx/skins/format-indent-more.png");
            this.NAME_IMAGE = new Image("/de/elpro/ui/controlsfx/skins/format-line-spacing-triple.png");
            this.setEventHandler(ae -> ((PropertySheet)PropertySheetSkin.this.getSkinnable()).modeProperty().set((Object)mode));
            if (mode == PropertySheet.Mode.CATEGORY) {
                this.setGraphic((Node)new ImageView(this.CATEGORY_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.bycategory")));
            } else if (mode == PropertySheet.Mode.NAME) {
                this.setGraphic((Node)new ImageView(this.NAME_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.byname")));
            } else {
                this.setText("???");
            }
        }
    }

    private class PropertyPane
    extends GridPane {
        public PropertyPane(List<PropertySheet.Item> properties) {
            this(properties, 0);
        }

        public PropertyPane(List<PropertySheet.Item> properties, int nestingLevel) {
            this.setPadding(new Insets(5.0, 15.0, 5.0, (double)(15 + nestingLevel * 10)));
            this.getStyleClass().add((Object)"property-pane");
            this.setItems(properties);
        }

        public void setItems(List<PropertySheet.Item> properties) {
            this.getChildren().clear();
            String filter = ((PropertySheet)PropertySheetSkin.this.getSkinnable()).titleFilter().get();
            filter = filter == null ? "" : filter.trim().toLowerCase();
            int row = 0;
            for (PropertySheet.Item item : properties) {
                Node editorContainer;
                PropertyItem propertyItem;
                Node editor;
                if (item instanceof SeparatorItem) {
                    Separator separator = new Separator(Orientation.HORIZONTAL);
                    this.add((Node)separator, 0, row++, 2, 1);
                    continue;
                }
                String title = item.getName();
                if (!filter.isEmpty() && title.toLowerCase().indexOf(filter) < 0) continue;
                Label label = new Label(title);
                label.setMinWidth(100.0);
                label.setPadding(new Insets(4.0, 0.0, 0.0, 1.0));
                GridPane.setMargin((Node)label, (Insets)new Insets(2.0));
                String description = item.getDescription();
                if (description != null && !description.trim().isEmpty()) {
                    label.setTooltip(new Tooltip(description));
                }
                if ((editor = (propertyItem = item instanceof PropertyItem ? (PropertyItem)item : null) != null && propertyItem.getEditor() != null ? propertyItem.getEditor() : this.getEditor(item)) instanceof Region) {
                    Region region = (Region)editor;
                    region.setMinWidth(100.0);
                    region.setMaxWidth(Double.MAX_VALUE);
                    if (propertyItem != null) {
                        if (propertyItem.getEditorMinHeight() != null) {
                            region.setMinHeight(propertyItem.getEditorMinHeight().doubleValue());
                        }
                        if (propertyItem.getEditorPrefHeight() != null) {
                            region.setPrefHeight(propertyItem.getEditorPrefHeight().doubleValue());
                        }
                        if (propertyItem.getEditorMaxHeight() != null) {
                            region.setMaxHeight(propertyItem.getEditorMaxHeight().doubleValue());
                        }
                    }
                }
                if (item instanceof ActionItem) {
                    BorderPane actionContainer = new BorderPane(editor);
                    actionContainer.getStyleClass().add((Object)"action-item-container");
                    ActionItem actionItem = (ActionItem)((Object)item);
                    actionContainer.setRight(this.createActionButtons(actionItem));
                    InvalidationListener il = o -> actionContainer.setRight(this.createActionButtons(actionItem));
                    actionItem.getActionButtons().addListener(il);
                    actionItem.actionButtonsOrientationProperty().addListener(il);
                    actionContainer.setMinWidth(100.0);
                    actionContainer.setMaxWidth(Double.MAX_VALUE);
                    BorderPane.setAlignment((Node)editor, (Pos)Pos.TOP_LEFT);
                    editorContainer = actionContainer;
                } else {
                    editorContainer = editor;
                }
                label.setLabelFor(editor);
                GridPane.setValignment((Node)label, (VPos)VPos.TOP);
                GridPane.setHgrow((Node)editorContainer, (Priority)Priority.ALWAYS);
                if (propertyItem != null && propertyItem.getEditorVgrow() != null) {
                    GridPane.setVgrow((Node)editorContainer, (Priority)propertyItem.getEditorVgrow());
                }
                GridPane.setMargin((Node)editorContainer, (Insets)new Insets(2.0));
                this.addRow(row, new Node[]{label, editorContainer});
                if (propertyItem != null) {
                    propertyItem.setEditor(editor);
                    int rowN = row;
                    propertyItem.editorProperty().addListener((o, ov, nv) -> {
                        label.setLabelFor(nv);
                        propertyItem.unbindInvalidProperty();
                        if (ov != null) {
                            ValidationUtils.uninstall(ov);
                            this.getChildren().remove(ov);
                        }
                        if (nv != null) {
                            GridPane.setMargin((Node)nv, (Insets)new Insets(2.0));
                            this.add((Node)nv, 1, rowN);
                            if (propertyItem.getValidator() != null) {
                                ValidationUtils.install(nv, propertyItem.valueProperty(), propertyItem.getValidator(), ValidationMode.ON_FLY);
                                ValidationGroup validationGroup = new ValidationGroup((Node)nv);
                                propertyItem.bindInvalidProperty(validationGroup.invalidProperty());
                                propertyItem.forceValidate();
                            }
                        }
                    });
                    if (propertyItem.getValidator() != null) {
                        ValidationUtils.install(editor, propertyItem.valueProperty(), propertyItem.getValidator(), ValidationMode.ON_FLY);
                        ValidationGroup validationGroup = new ValidationGroup(editor);
                        propertyItem.bindInvalidProperty(validationGroup.invalidProperty());
                        propertyItem.forceValidate();
                    }
                    Runnable onHide = () -> {
                        this.getChildren().remove((Object)label);
                        if (propertyItem.getEditor() != null) {
                            this.getChildren().remove((Object)editorContainer);
                            this.getChildren().remove((Object)propertyItem.getEditor());
                        }
                    };
                    int rowIndexCopy = row;
                    Runnable onShow = () -> {
                        Node itemEditor;
                        if (!this.getChildren().contains((Object)label)) {
                            this.add((Node)label, 0, rowIndexCopy);
                        }
                        if ((itemEditor = propertyItem.getEditor()) != null && !this.getChildren().contains((Object)editorContainer)) {
                            if (editorContainer != itemEditor && editorContainer instanceof BorderPane && itemEditor.getStyleClass().contains((Object)"action-item-container")) {
                                ((BorderPane)editorContainer).setCenter(itemEditor);
                            }
                            this.add(editorContainer, 1, rowIndexCopy);
                        }
                    };
                    propertyItem.hiddenProperty().addListener(i -> {
                        if (propertyItem.isHidden()) {
                            Platform.runLater((Runnable)onHide);
                        } else {
                            Platform.runLater((Runnable)onShow);
                        }
                    });
                    if (propertyItem.isHidden()) {
                        onHide.run();
                    }
                }
                ++row;
            }
        }

        private Node getEditor(PropertySheet.Item item) {
            PropertyEditor editor = (PropertyEditor)((PropertySheet)PropertySheetSkin.this.getSkinnable()).getPropertyEditorFactory().call((Object)item);
            if (editor == null) {
                editor = new AbstractPropertyEditor<Object, TextField>(item, new TextField(), true){
                    {
                        ((TextField)this.getEditor()).setEditable(false);
                        ((TextField)this.getEditor()).setDisable(true);
                    }

                    @Override
                    protected ObservableValue<Object> getObservableValue() {
                        return (ObservableValue)((TextField)this.getEditor()).textProperty();
                    }

                    @Override
                    public void setValue(Object value) {
                        ((TextField)this.getEditor()).setText(value == null ? "" : value.toString());
                    }
                };
            }
            editor.setValue(item.getValue());
            return editor.getEditor();
        }

        public Node createActionButtons(ActionItem actionItem) {
            HBox box;
            if (actionItem.getActionButtons().isEmpty()) {
                return null;
            }
            ArrayList<Button> buttons = new ArrayList<Button>();
            for (ActionButton actionButton : actionItem.getActionButtons()) {
                Button button = new Button(actionButton.getLabel(), actionButton.getGrafic());
                button.setOnAction(e -> {
                    if (actionButton.getAction() != null) {
                        actionButton.getAction().run();
                    }
                });
                if (actionButton.getDisableProperty() != null) {
                    button.disableProperty().bind((ObservableValue)actionButton.getDisableProperty());
                }
                buttons.add(button);
            }
            if (actionItem.getActionButtonsOrientation() == Orientation.HORIZONTAL) {
                box = new HBox(5.0, (Node[])buttons.toArray(Node[]::new));
                return box;
            }
            box = new VBox(5.0, (Node[])buttons.toArray(Node[]::new));
            return box;
        }
    }
}

