/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.parser.number;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.Operation;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.AggregatorsParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public class NumberParser<T extends Number>
implements Parser<T> {
    private String errorString = "";

    @Override
    public Predicate<T> parse(String text) {
        this.errorString = "";
        Predicate aggregation = this.aggregate(text);
        if (aggregation == null) {
            Optional<NumberOperation> optionalOperation = Stream.of(NumberOperation.values()).filter(opr -> text.startsWith(opr.get())).filter(opr -> text.length() > opr.length()).findFirst();
            if (optionalOperation.isPresent()) {
                NumberOperation operation = optionalOperation.get();
                String numText = this.trim(text, operation.length());
                if (!this.isNumeric(numText)) {
                    this.errorString = Localization.localize(Localization.asKey("parser.text.error.number.input"));
                    return null;
                }
                return operation.operate(this.convert(numText));
            }
            this.errorString = Localization.localize(Localization.asKey("parser.text.error.start.operator"));
            return null;
        }
        return aggregation;
    }

    @Override
    public List<String> operators() {
        return Stream.concat(Arrays.stream(NumberOperation.values()).map(Operation::get), AggregatorsParser.getStrings()).collect(Collectors.toList());
    }

    @Override
    public String getSymbol(String text) {
        return Arrays.stream(NumberOperation.values()).filter(op -> op.get().equals(text)).map(Operation::getSymbol).findFirst().orElse(NumberParser.i18nString("symbol.default"));
    }

    @Override
    public boolean isValid(String text) {
        this.parse(text);
        return this.errorString.isEmpty();
    }

    @Override
    public String getErrorMessage() {
        return this.errorString;
    }

    private boolean isNumeric(String str) {
        return !str.isEmpty() && str.matches("-?\\d+(\\.\\d+)?");
    }

    private String trim(String text, int startIndex) {
        return text.substring(startIndex, text.length()).trim();
    }

    private double convert(String numText) {
        return Double.parseDouble(numText);
    }

    private static String i18nString(String key) {
        return Localization.localize(Localization.asKey("parser.text.operator." + key));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum NumberOperation implements Operation<Number, Number>
    {
        EQUALS("text.equals", "symbol.equals"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() == num.doubleValue();
            }
        }
        ,
        NOT_EQUALS("text.notequals", "symbol.notequals"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() != num.doubleValue();
            }
        }
        ,
        GREATER_THAN_EQUALS("text.greaterthanequals", "symbol.greaterthanequals"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() >= num.doubleValue();
            }
        }
        ,
        GREATER_THAN("text.greaterthan", "symbol.greaterthan"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() > num.doubleValue();
            }
        }
        ,
        LESS_THAN_EQUALS("text.lessthanequals", "symbol.lessthanequals"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() <= num.doubleValue();
            }
        }
        ,
        LESS_THAN("text.lessthan", "symbol.lessthan"){

            @Override
            public Predicate<Number> operate(Number num) {
                return t -> t != null && t.doubleValue() < num.doubleValue();
            }
        };

        private final String opr;
        private final String symbol;

        private NumberOperation(String opr, String symbol) {
            this.opr = NumberParser.i18nString(opr);
            this.symbol = NumberParser.i18nString(symbol);
        }

        @Override
        public int length() {
            return this.opr.length();
        }

        @Override
        public String get() {
            return this.opr;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }
    }
}

