/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import jidefx.scene.control.decoration.DecorationDelegate;
import jidefx.scene.control.decoration.DecorationSupport;

@DefaultProperty(value="content")
public class DecorationPane
extends StackPane
implements DecorationSupport {
    private Parent _content;
    private DecorationDelegate _decorationDelegate = new DecorationDelegate((Region)this);

    public DecorationPane() {
    }

    public DecorationPane(Parent content) {
        this.setContent(content);
    }

    protected void initializeStyle() {
        this.getStyleClass().setAll((Object[])new String[]{"decoration-support"});
    }

    protected void initializeChildren() {
    }

    protected void registerListeners() {
    }

    protected void unregisterListeners() {
    }

    protected void layoutChildren() {
        if (this.getContent().getParent() != this) {
            throw new IllegalStateException("The content is not added to the Decoration. If you override initializeChildren method, please make sure you call super.initializeChildren first.");
        }
        this._decorationDelegate.prepareDecorations();
        super.layoutChildren();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DecorationPane.this._decorationDelegate.layoutDecorations();
            }
        });
    }

    protected double computeMinWidth(double height) {
        return this.getContent().minWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
    }

    protected double computeMinHeight(double width) {
        return this.getContent().minHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
    }

    protected double computeMaxWidth(double height) {
        return this.getContent().maxWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
    }

    protected double computeMaxHeight(double width) {
        return this.getContent().maxHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
    }

    protected double computePrefWidth(double height) {
        return this.getContent().prefWidth(height) + this.getPadding().getLeft() + this.getPadding().getRight();
    }

    protected double computePrefHeight(double width) {
        return this.getContent().prefHeight(width) + this.getPadding().getTop() + this.getPadding().getBottom();
    }

    public Parent getContent() {
        return this._content;
    }

    public void setContent(Parent content) {
        if (this._content == content) {
            return;
        }
        this.unregisterListeners();
        this.getChildren().clear();
        this._content = content;
        if (this._content != null) {
            this.getChildren().add((Object)this.getContent());
            this.initializeChildren();
            this.initializeStyle();
            this.registerListeners();
        }
    }

    @Override
    public void positionInArea(Node child, double areaX, double areaY, double areaWidth, double areaHeight, double areaBaselineOffset, HPos hAlignment, VPos vAlignment) {
        super.positionInArea(child, areaX, areaY, areaWidth, areaHeight, areaBaselineOffset, hAlignment, vAlignment);
    }
}

