/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import jidefx.scene.control.decoration.Decorator;

public class DecorationUtils {
    private static final String PROPERTY_DECORATOR = "Decoration.Decorator";
    private static final String PROPERTY_TARGET_NODE_PADDING = "Decoration.Target.Node.Padding";
    private static final String PROPERTY_TARGET_DECORATOR_STATUS = "Decoration.Target.Decorator.Status";
    private static final String PROPERTY_TARGET_DECORATOR_STATUS_CLEANED = "cleaned";
    private static final String PROPERTY_DECORATOR_ANIMATION_STATUS = "Decoration.Decorator.Animation.Status";
    private static final String PROPERTY_DECORATOR_ANIMATION_STATUS_PLAYED = "played";

    public static void install(Node targetNode, Decorator decorator) {
        if (targetNode != null && decorator != null) {
            decorator.getNode().setVisible(false);
            Object object = DecorationUtils.getDecorators(targetNode);
            if (object instanceof Decorator) {
                if (!object.equals(decorator)) {
                    DecorationUtils.installAll(targetNode, (Decorator)object, decorator);
                }
            } else if (object instanceof Decorator[]) {
                Decorator[] oldDecorators = (Decorator[])object;
                if (!Arrays.asList(oldDecorators).contains(decorator)) {
                    Decorator[] newDecorators = new Decorator[oldDecorators.length + 1];
                    System.arraycopy(oldDecorators, 0, newDecorators, 0, oldDecorators.length);
                    newDecorators[oldDecorators.length] = decorator;
                    targetNode.getProperties().put((Object)PROPERTY_DECORATOR, (Object)newDecorators);
                }
            } else {
                targetNode.getProperties().put((Object)PROPERTY_DECORATOR, (Object)decorator);
            }
            if (targetNode instanceof Parent) {
                ((Parent)targetNode).requestLayout();
            }
        }
    }

    public static void installAll(Node targetNode, Decorator ... decorators) {
        if (targetNode != null && decorators != null) {
            Decorator[] decoratorArray = decorators;
            int n = decorators.length;
            int n2 = 0;
            while (n2 < n) {
                Decorator decorator = decoratorArray[n2];
                if (decorator != null) {
                    decorator.getNode().setVisible(false);
                }
                ++n2;
            }
            targetNode.getProperties().put((Object)PROPERTY_DECORATOR, (Object)decorators);
        }
    }

    public static void installAll(List<Node> targetNodes, Supplier<Decorator> decoratorFactory) {
        for (Node node : targetNodes) {
            DecorationUtils.install(node, decoratorFactory.get());
        }
    }

    public static boolean hasDecorators(Node targetNode) {
        Object object = targetNode.getProperties().get((Object)PROPERTY_DECORATOR);
        return object instanceof Decorator || object instanceof Decorator[];
    }

    public static Object getDecorators(Node targetNode) {
        return targetNode.getProperties().get((Object)PROPERTY_DECORATOR);
    }

    public static void uninstall(Node targetNode) {
        if (targetNode != null) {
            targetNode.getProperties().remove((Object)PROPERTY_DECORATOR);
            targetNode.getProperties().remove((Object)PROPERTY_TARGET_DECORATOR_STATUS);
            if (targetNode instanceof Parent) {
                ((Parent)targetNode).requestLayout();
            }
        }
    }

    public static void uninstall(Node targetNode, Decorator decorator) {
        if (targetNode != null && decorator != null) {
            Object object = targetNode.getProperties().get((Object)PROPERTY_DECORATOR);
            if (object instanceof Decorator && object.equals(decorator)) {
                targetNode.getProperties().remove((Object)PROPERTY_DECORATOR);
            } else if (object instanceof Decorator[]) {
                Decorator[] oldDecorators = (Decorator[])object;
                if (oldDecorators.length == 1) {
                    if (oldDecorators[0].equals(decorator)) {
                        targetNode.getProperties().remove((Object)PROPERTY_DECORATOR);
                    }
                } else {
                    Decorator[] tempDecorators = new Decorator[oldDecorators.length];
                    int j = 0;
                    Decorator[] decoratorArray = oldDecorators;
                    int n = oldDecorators.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Decorator oldDecorator = decoratorArray[n2];
                        if (!oldDecorator.equals(decorator)) {
                            tempDecorators[j++] = oldDecorator;
                        }
                        ++n2;
                    }
                    if (j == 0) {
                        targetNode.getProperties().remove((Object)PROPERTY_DECORATOR);
                    } else if (j < oldDecorators.length) {
                        Decorator[] newDecorators = new Decorator[j];
                        System.arraycopy(tempDecorators, 0, newDecorators, 0, j);
                        targetNode.getProperties().put((Object)PROPERTY_DECORATOR, (Object)newDecorators);
                    }
                }
            }
            if (targetNode instanceof Parent) {
                ((Parent)targetNode).requestLayout();
            }
        }
    }

    private static boolean isVisible(Node c) {
        Node parent = c;
        while (parent != null) {
            if (!parent.isVisible()) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private static Bounds computeDecorationBounds(Node targetNode, Node decorationNode, Decorator decorator) {
        double width = decorationNode.prefWidth(-1.0);
        double height = decorationNode.prefHeight(-1.0);
        Bounds targetBounds = targetNode.getLayoutBounds();
        double x = targetBounds.getMinX() - width / 2.0;
        double y = targetBounds.getMinY() - height / 2.0;
        double targetWidth = targetBounds.getWidth();
        double targetHeight = targetBounds.getHeight();
        if (targetWidth <= 0.0) {
            targetWidth = targetNode.prefWidth(-1.0);
        }
        if (targetHeight <= 0.0) {
            targetHeight = targetNode.prefHeight(-1.0);
        }
        double baselineOffset = targetNode.getBaselineOffset();
        Pos pos = decorator.getPos();
        switch (pos) {
            case TOP_CENTER: {
                x += targetWidth / 2.0;
                break;
            }
            case TOP_RIGHT: {
                x += targetWidth;
                break;
            }
            case CENTER_LEFT: {
                y += targetHeight / 2.0;
                break;
            }
            case CENTER: {
                x += targetWidth / 2.0;
                y += targetHeight / 2.0;
                break;
            }
            case CENTER_RIGHT: {
                x += targetWidth;
                y += targetHeight / 2.0;
                break;
            }
            case BOTTOM_LEFT: {
                y += targetHeight;
                break;
            }
            case BOTTOM_CENTER: {
                x += targetWidth / 2.0;
                y += targetHeight;
                break;
            }
            case BOTTOM_RIGHT: {
                x += targetWidth;
                y += targetHeight;
                break;
            }
            case BASELINE_LEFT: {
                y += baselineOffset - decorationNode.getBaselineOffset() + height / 2.0;
                break;
            }
            case BASELINE_CENTER: {
                x += targetWidth / 2.0;
                y += baselineOffset - decorationNode.getBaselineOffset() + height / 2.0;
                break;
            }
            case BASELINE_RIGHT: {
                x += targetWidth;
                y += baselineOffset - decorationNode.getBaselineOffset() + height / 2.0;
            }
        }
        Point2D decoratorPosOffset = decorator.getPosOffset();
        if (decorator.isValueInPercent()) {
            x += decoratorPosOffset.getX() * width / 100.0;
            y += decoratorPosOffset.getY() * height / 100.0;
        } else {
            x += decoratorPosOffset.getX();
            y += decoratorPosOffset.getY();
        }
        return DecorationUtils.adjustBounds(decorationNode.getLayoutBounds(), (Bounds)new BoundingBox(x, y, width, height));
    }

    static Bounds computeDecorationBounds(Node parentNode, Node targetNode, Node decorateNode, Decorator decorator) {
        return parentNode.screenToLocal(targetNode.localToScreen(DecorationUtils.computeDecorationBounds(targetNode, decorateNode, decorator)));
    }

    static <T extends Node> boolean isTargetDecoratorCleaned(T targetNode) {
        return targetNode != null && PROPERTY_TARGET_DECORATOR_STATUS_CLEANED.equals(targetNode.getProperties().get((Object)PROPERTY_TARGET_DECORATOR_STATUS));
    }

    public static void setTargetDecoratorCleaned(Node targetNode, boolean clean) {
        if (targetNode == null) {
            return;
        }
        if (clean) {
            targetNode.getProperties().put((Object)PROPERTY_TARGET_DECORATOR_STATUS, (Object)PROPERTY_TARGET_DECORATOR_STATUS_CLEANED);
        } else {
            targetNode.getProperties().remove((Object)PROPERTY_TARGET_DECORATOR_STATUS);
        }
    }

    static Insets getTargetPadding(Region targetNode) {
        if (targetNode == null) {
            return null;
        }
        Object insets = targetNode.getProperties().get((Object)PROPERTY_TARGET_NODE_PADDING);
        if (insets instanceof Insets) {
            return (Insets)insets;
        }
        Insets padding = targetNode.getPadding();
        DecorationUtils.setTargetPadding(targetNode, padding);
        return padding;
    }

    static void setTargetPadding(Region targetNode, Insets rawInsets) {
        if (targetNode == null) {
            return;
        }
        targetNode.getProperties().put((Object)PROPERTY_TARGET_NODE_PADDING, (Object)rawInsets);
    }

    public static boolean isAnimationPlayed(Node decorateNode) {
        if (decorateNode == null) {
            return false;
        }
        Object status = decorateNode.getProperties().get((Object)PROPERTY_DECORATOR_ANIMATION_STATUS);
        return status != null && status.equals(PROPERTY_DECORATOR_ANIMATION_STATUS_PLAYED);
    }

    public static void setAnimationPlayed(Node decorateNode, boolean played) {
        if (decorateNode == null) {
            return;
        }
        if (played) {
            decorateNode.getProperties().put((Object)PROPERTY_DECORATOR_ANIMATION_STATUS, (Object)PROPERTY_DECORATOR_ANIMATION_STATUS_PLAYED);
        } else {
            decorateNode.getProperties().remove((Object)PROPERTY_DECORATOR_ANIMATION_STATUS);
        }
    }

    static <T extends Node> Insets computePadding(Region targetNode, Decorator<T> decorator) {
        Bounds decorationBounds;
        Bounds boundsInLocal;
        BoundingBox actualBounds;
        boolean inside;
        T node = decorator.getNode();
        Pos pos = decorator.getPos();
        Point2D offset = decorator.getPosOffset();
        boolean valueInPercentOrPixels = decorator.isValueInPercent();
        if (offset == null) {
            offset = new Point2D(0.0, 0.0);
        }
        Insets targetPadding = DecorationUtils.getTargetPadding(targetNode);
        double w = node.prefWidth(-1.0);
        double h = node.prefHeight(-1.0);
        double right = 0.0;
        double left = 0.0;
        double x = offset.getX();
        offset.getY();
        if (valueInPercentOrPixels) {
            x *= w / 100.0;
        }
        if (inside = (actualBounds = new BoundingBox((boundsInLocal = targetNode.getBoundsInLocal()).getMinX() + targetPadding.getLeft(), boundsInLocal.getMinY() + targetPadding.getTop(), boundsInLocal.getWidth() - targetPadding.getLeft() - targetPadding.getRight(), boundsInLocal.getHeight() - targetPadding.getTop() - targetPadding.getBottom())).intersects(decorationBounds = DecorationUtils.computeDecorationBounds((Node)targetNode, node, decorator))) {
            switch (pos) {
                case TOP_LEFT: 
                case CENTER_LEFT: 
                case BOTTOM_LEFT: 
                case BASELINE_LEFT: {
                    left = Math.max(0.0, x + w / 2.0 - targetPadding.getLeft() + 1.0);
                    break;
                }
                case TOP_RIGHT: 
                case CENTER_RIGHT: 
                case BOTTOM_RIGHT: 
                case BASELINE_RIGHT: {
                    right = Math.max(0.0, -x + w / 2.0 - targetPadding.getLeft() + 1.0);
                }
            }
        }
        return new Insets(0.0, right, 0.0, left);
    }

    private static Bounds adjustBounds(Bounds decorateLocalBounds, Bounds targetLocalBounds) {
        return new BoundingBox(targetLocalBounds.getMinX() - decorateLocalBounds.getMinX(), targetLocalBounds.getMinY() - decorateLocalBounds.getMinY(), targetLocalBounds.getWidth(), targetLocalBounds.getHeight());
    }

    private static Insets adjustPadding(Bounds decorateLocalBounds, Insets padding) {
        return new Insets(padding.getTop() - decorateLocalBounds.getMinY(), padding.getRight() - decorateLocalBounds.getMinX(), padding.getBottom() - decorateLocalBounds.getMinY(), padding.getLeft() - decorateLocalBounds.getMinX());
    }
}

