/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.decoration;

import javafx.animation.Transition;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import jidefx.animation.AnimationType;
import jidefx.animation.AnimationUtils;
import jidefx.scene.control.decoration.DecorationUtils;

public class Decorator<T extends Node> {
    protected ReadOnlyObjectWrapper<T> _nodeProperty;
    protected ReadOnlyObjectWrapper<Pos> _posProperty;
    protected ReadOnlyObjectWrapper<Insets> _paddingProperty;
    protected ReadOnlyObjectWrapper<Point2D> _offsetProperty;
    protected ReadOnlyBooleanWrapper _valueInPercentProperty;
    protected ReadOnlyObjectWrapper<Transition> _transitionProperty;

    public Decorator() {
    }

    public Decorator(T node) {
        this(node, Pos.TOP_RIGHT);
    }

    public Decorator(T node, Pos pos) {
        this(node, pos, null);
    }

    public Decorator(T node, Pos pos, Point2D offset) {
        this(node, pos, offset, null);
    }

    public Decorator(T node, Pos pos, Point2D offset, Insets padding) {
        this(node, pos, offset, padding, AnimationType.NONE);
    }

    public Decorator(T node, Pos pos, Point2D offset, Insets padding, AnimationType type) {
        this(node, pos, offset, padding, true, AnimationUtils.createTransition(node, type));
    }

    public Decorator(T node, Pos pos, Point2D offset, Insets padding, boolean valueInPercentOrPixels, Transition transition) {
        this.nodePropertyImpl().set(node);
        this.posPropertyImpl().set((Object)(pos == null ? Pos.TOP_RIGHT : pos));
        this.offsetPropertyImpl().set((Object)(offset == null ? new Point2D(0.0, 0.0) : offset));
        this.valueInPercentPropertyImpl().set(valueInPercentOrPixels);
        this.paddingPropertyImpl().set((Object)padding);
        this.transitionPropertyImpl().set((Object)transition);
    }

    public ReadOnlyObjectProperty<T> nodeProperty() {
        return this.nodePropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyObjectWrapper<T> nodePropertyImpl() {
        if (this._nodeProperty == null) {
            this._nodeProperty = new ReadOnlyObjectWrapper();
        }
        return this._nodeProperty;
    }

    public T getNode() {
        return (T)((Node)this.nodePropertyImpl().get());
    }

    public ReadOnlyObjectProperty<Pos> posProperty() {
        return this.posPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyObjectWrapper<Pos> posPropertyImpl() {
        if (this._posProperty == null) {
            this._posProperty = new ReadOnlyObjectWrapper((Object)Pos.TOP_RIGHT);
        }
        return this._posProperty;
    }

    public Pos getPos() {
        return (Pos)this.posProperty().get();
    }

    public ReadOnlyObjectProperty<Point2D> offsetProperty() {
        return this.offsetPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyObjectWrapper<Point2D> offsetPropertyImpl() {
        if (this._offsetProperty == null) {
            this._offsetProperty = new ReadOnlyObjectWrapper((Object)new Point2D(0.0, 0.0));
        }
        return this._offsetProperty;
    }

    public Point2D getPosOffset() {
        return (Point2D)this.offsetProperty().get();
    }

    public ReadOnlyObjectProperty<Insets> paddingProperty() {
        return this.paddingPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyObjectWrapper<Insets> paddingPropertyImpl() {
        if (this._paddingProperty == null) {
            this._paddingProperty = new ReadOnlyObjectWrapper();
        }
        return this._paddingProperty;
    }

    public Insets getPadding() {
        return (Insets)this.paddingProperty().get();
    }

    public ReadOnlyObjectProperty<Transition> transitionProperty() {
        return this.transitionPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyObjectWrapper<Transition> transitionPropertyImpl() {
        if (this._transitionProperty == null) {
            this._transitionProperty = new ReadOnlyObjectWrapper<Transition>(){

                protected void invalidated() {
                    super.invalidated();
                    DecorationUtils.setAnimationPlayed(Decorator.this.getNode(), false);
                }
            };
        }
        return this._transitionProperty;
    }

    public ReadOnlyBooleanProperty valueInPercentProperty() {
        return this.valueInPercentPropertyImpl().getReadOnlyProperty();
    }

    protected ReadOnlyBooleanWrapper valueInPercentPropertyImpl() {
        if (this._valueInPercentProperty == null) {
            this._valueInPercentProperty = new ReadOnlyBooleanWrapper(true);
        }
        return this._valueInPercentProperty;
    }

    public boolean isValueInPercent() {
        return this.valueInPercentProperty().get();
    }

    public Transition getTransition() {
        return (Transition)this.transitionProperty().get();
    }
}

