/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.validation;

import java.util.Arrays;
import java.util.function.Function;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import jidefx.animation.AnimationType;
import jidefx.animation.AnimationUtils;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.validation.ValidationDecorationType;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationFontAwesomeIcons;
import jidefx.scene.control.validation.ValidationIcons;
import jidefx.scene.control.validation.ValidationUtils;

public class ValidationDecorators {
    private static final Double DEFAULT_TOOLTIP_OFFSET_X = 15.0;
    private static final Double DEFAULT_TOOLTIP_OFFSET_Y = 15.0;
    public static final String PROPERTY_VALIDATION_DECORATOR = "validation-decorator";
    public static final String PROPERTY_REQUIRED_VALIDATION_DECORATOR = "required-validation-decorator";

    public static Decorator<Label> graphicDecoratorCreator(Node targetNode, Decorator oldDecorator, ValidationEvent event) {
        ImageView graphic;
        String url = ValidationIcons.getInstance().getValidationResultIcon(event.getEventType());
        ImageView imageView = graphic = url != null ? new ImageView(url) : null;
        if (oldDecorator != null && ValidationDecorators.exists(targetNode, oldDecorator)) {
            Label label = (Label)oldDecorator.getNode();
            label.setGraphic((Node)graphic);
            label.setTooltip((Tooltip)ValidationDecorators.createTooltip(event.getMessage(), label));
            DecorationUtils.setAnimationPlayed((Node)label, false);
            return oldDecorator;
        }
        return ValidationDecorators.createAndInstallValidationDecorator(targetNode, event, ValidationDecorationType.GRAPHIC);
    }

    public static Decorator<Label> fontAwesomeDecoratorCreator(Node targetNode, Decorator oldDecorator, ValidationEvent event) {
        String fontAwesomeIcon = ValidationFontAwesomeIcons.getInstance().getValidationFontAwesomeIcon(event.getEventType());
        if (oldDecorator != null && ValidationDecorators.exists(targetNode, oldDecorator)) {
            Label label = (Label)oldDecorator.getNode();
            label.setText(fontAwesomeIcon);
            label.setTooltip((Tooltip)ValidationDecorators.createTooltip(event.getMessage(), label));
            DecorationUtils.setAnimationPlayed((Node)label, false);
            return oldDecorator;
        }
        return ValidationDecorators.createAndInstallValidationDecorator(targetNode, event, ValidationDecorationType.FONT_AWESOME);
    }

    public static void defaultDecorationClickBehavior(MouseEvent mouseEvent) {
        Label label;
        if (mouseEvent.getTarget() != null && mouseEvent.getTarget() instanceof Label && (label = (Label)mouseEvent.getTarget()).getTooltip() != null) {
            Point2D point = label.localToScene(DEFAULT_TOOLTIP_OFFSET_X.doubleValue(), DEFAULT_TOOLTIP_OFFSET_Y.doubleValue());
            label.getTooltip().setAutoHide(true);
            label.getTooltip().show((Node)label, point.getX() + label.getScene().getX() + label.getScene().getWindow().getX(), point.getY() + label.getScene().getY() + label.getScene().getWindow().getY());
        }
    }

    public static boolean exists(Node targetNode, Decorator resultDecorator) {
        Object o = DecorationUtils.getDecorators(targetNode);
        return o != null && (o.equals(resultDecorator) || o instanceof Decorator[] && Arrays.asList((Decorator[])o).contains(resultDecorator));
    }

    public static ValidationUtils.TooltipFix createTooltip(String message, Label label) {
        ValidationUtils.TooltipFix tooltip = null;
        if (message != null && message.trim().length() > 0) {
            tooltip = new ValidationUtils.TooltipFix((Node)label);
            tooltip.setText(message);
            tooltip.setAutoHide(true);
            tooltip.setConsumeAutoHidingEvents(false);
        }
        return tooltip;
    }

    public static Decorator<Label> createAndInstallValidationDecorator(Node targetNode, ValidationEvent event, ValidationDecorationType type) {
        Label label = new Label();
        label.getStyleClass().add((Object)PROPERTY_VALIDATION_DECORATOR);
        label.setTooltip((Tooltip)ValidationDecorators.createTooltip(event.getMessage(), label));
        switch (type) {
            case GRAPHIC: {
                String url = ValidationIcons.getInstance().getValidationResultIcon(event.getEventType());
                label.setGraphic((Node)(url != null ? new ImageView(url) : null));
                break;
            }
            case FONT_AWESOME: {
                label.setText(ValidationFontAwesomeIcons.getInstance().getValidationFontAwesomeIcon(event.getEventType()));
                label.setStyle("-fx-font-family: FontAwesome;");
            }
        }
        label.addEventHandler(MouseEvent.MOUSE_CLICKED, ValidationDecorators::defaultDecorationClickBehavior);
        Decorator<Label> newDecorator = null;
        newDecorator = targetNode instanceof Cell ? new Decorator<Label>(label, Pos.CENTER_RIGHT, new Point2D(-60.0, 0.0), new Insets(0.0, 100.0, 0.0, 0.0), AnimationType.TADA) : new Decorator<Label>(label, Pos.BOTTOM_LEFT, new Point2D(0.0, 0.0), new Insets(0.0, 0.0, 0.0, 0.0), AnimationType.TADA);
        DecorationUtils.install(targetNode, newDecorator);
        targetNode.getParent().requestLayout();
        return newDecorator;
    }

    public static Decorator<Label> graphicRequiredCreator(Node targetNode) {
        Image image = new Image("/jidefx/scene/control/decoration/required-indicator.png");
        Label lblRequired = new Label("", (Node)new ImageView(image));
        lblRequired.getStyleClass().add((Object)PROPERTY_REQUIRED_VALIDATION_DECORATOR);
        Decorator<Label> requiredDecorator = new Decorator<Label>(lblRequired, Pos.TOP_LEFT, new Point2D(image.getWidth() / 2.0, image.getHeight() / 2.0), new Insets(0.0, 0.0, 0.0, 0.0), false, AnimationUtils.createTransition(targetNode, AnimationType.NONE));
        return requiredDecorator;
    }

    public static Decorator<Label> fontAwesomeRequiredCreator(Node targetNode) {
        Label lblRequired = new Label();
        lblRequired.setText("\uf005");
        lblRequired.setStyle("-fx-font-family: FontAwesome;");
        lblRequired.getStyleClass().add((Object)PROPERTY_REQUIRED_VALIDATION_DECORATOR);
        Decorator<Label> requiredDecorator = new Decorator<Label>(lblRequired, Pos.TOP_LEFT, new Point2D(0.0, 0.0), new Insets(0.0, 0.0, 0.0, 0.0));
        return requiredDecorator;
    }

    public static Decorator<Label> installRequiredDecorator(Node targetNode, Function<Node, Decorator<Label>> requiredDecoratorCreator) {
        Decorator<Label> decorator = requiredDecoratorCreator.apply(targetNode);
        DecorationUtils.install(targetNode, decorator);
        targetNode.getParent().requestLayout();
        return decorator;
    }
}

