/*
 * Decompiled with CFR 0.152.
 */
package jidefx.scene.control.validation;

import java.util.Map;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationStatus;
import jidefx.scene.control.validation.ValidationUtils;

public class ValidationGroup {
    private ObservableMap<Node, ValidationStatus> validationNodes = FXCollections.observableHashMap();
    private BooleanProperty invalidProperty = new SimpleBooleanProperty();

    public ValidationGroup(Node ... targetNodes) {
        Node[] nodeArray = targetNodes;
        int n = targetNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node != null) {
                this.validationNodes.put((Object)node, (Object)ValidationUtils.getValidationStatus(node));
                node.addEventHandler(ValidationEvent.ANY, event -> this.validationNodes.put((Object)((Node)event.getTarget()), (Object)ValidationUtils.getValidationStatus((Node)event.getTarget())));
            }
            ++n2;
        }
        this.validationNodes.addListener(change -> {
            Stream<Map.Entry> entryStream = this.validationNodes.entrySet().stream().filter(entry -> entry.getValue() == ValidationStatus.VALIDATION_ERROR);
            this.invalidProperty.set(entryStream.count() > 0L);
        });
    }

    public Boolean isInvalid() {
        return this.invalidProperty.get();
    }

    public ReadOnlyBooleanProperty invalidProperty() {
        return this.invalidProperty;
    }

    public void addValidationNode(Node targetNode) {
        this.validationNodes.put((Object)targetNode, (Object)ValidationUtils.getValidationStatus(targetNode));
    }

    public void removeValidationNode(Node targetNode) {
        this.validationNodes.remove((Object)targetNode);
    }
}

