/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerUtils {
    public static Handler enableLogger(String loggerName, Level level) {
        Logger log = Logger.getLogger(loggerName);
        log.setLevel(level);
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.err.print(record.getMessage());
                Object[] params = record.getParameters();
                if (params != null) {
                    if (params.length > 0) {
                        System.err.print("= ");
                    }
                    int i = 0;
                    while (i < params.length) {
                        System.err.print(params[i]);
                        if (i < params.length - 1) {
                            System.err.print(", ");
                        }
                        ++i;
                    }
                }
                System.err.println();
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        log.addHandler(handler);
        return handler;
    }

    public static void disableLogger(String loggerName, Handler handler) {
        Logger log = Logger.getLogger(loggerName);
        log.setLevel(null);
        log.removeHandler(handler);
    }
}

