/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

import java.util.Collection;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;

public class PredefinedShapes {
    private static PredefinedShapes _instance = new PredefinedShapes();
    private static final String STYLE_CLASS_DEFAULT = "predefined-shape";

    public static PredefinedShapes getInstance() {
        return _instance;
    }

    public static void setInstance(PredefinedShapes instance) {
        _instance = instance;
    }

    public Shape createArrowIcon(double size) {
        Color strokeColor = new Color(0.3, 0.3, 0.3, 1.0);
        Color fillColor = new Color(0.2, 0.2, 0.2, 1.0);
        double width = size;
        double height = size / 2.0;
        double strokeWidth = 0.0;
        Polygon triangle = new Polygon(new double[]{0.0, 0.0, width, 0.0, height, width / 2.0, 0.0, 0.0});
        triangle.setStroke((Paint)strokeColor);
        triangle.setStrokeLineCap(StrokeLineCap.ROUND);
        triangle.setStrokeWidth(strokeWidth);
        triangle.setFill((Paint)fillColor);
        triangle.setPickOnBounds(true);
        triangle.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-filter-icon"});
        return triangle;
    }

    public Shape createClearIcon(double size) {
        Color circleFillColor = new Color(0.5, 0.5, 0.5, 1.0);
        double radius = size / 2.0;
        double crossStrokeWidth = size * 0.2;
        double crossHalfLength = radius * 0.4;
        Circle circle = new Circle(radius, radius, radius);
        circle.setStrokeWidth(0.0);
        Line crossLineLeft = new Line(radius - crossHalfLength, radius - crossHalfLength, radius + crossHalfLength, radius + crossHalfLength);
        crossLineLeft.setStrokeWidth(crossStrokeWidth);
        crossLineLeft.setStrokeLineCap(StrokeLineCap.ROUND);
        Line crossLineRight = new Line(radius - crossHalfLength, radius + crossHalfLength, radius + crossHalfLength, radius - crossHalfLength);
        crossLineRight.setStrokeWidth(crossStrokeWidth);
        crossLineRight.setStrokeLineCap(StrokeLineCap.ROUND);
        Shape shape = Shape.subtract((Shape)Shape.subtract((Shape)circle, (Shape)crossLineLeft), (Shape)crossLineRight);
        shape.setFill((Paint)circleFillColor);
        shape.setPickOnBounds(true);
        shape.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-clear-icon"});
        return shape;
    }

    public Group createCloseIcon(double size) {
        Color fillColor = new Color(0.0, 0.0, 0.0, 1.0);
        Color strokeColor = new Color(1.0, 1.0, 1.0, 1.0);
        double radius = size / 2.0;
        double strokeWidth = size * 0.1;
        double crossHalfLength = radius * 0.4;
        Circle circle = new Circle(radius, radius, radius);
        circle.setStrokeWidth(strokeWidth);
        circle.setFill((Paint)fillColor);
        circle.setStroke((Paint)strokeColor);
        Line crossLineLeft = new Line(radius - crossHalfLength, radius - crossHalfLength, radius + crossHalfLength, radius + crossHalfLength);
        crossLineLeft.setStrokeWidth(strokeWidth);
        crossLineLeft.setStrokeLineCap(StrokeLineCap.ROUND);
        crossLineLeft.setStrokeType(StrokeType.CENTERED);
        crossLineLeft.setStroke((Paint)strokeColor);
        crossLineLeft.setFill((Paint)strokeColor);
        Line crossLineRight = new Line(radius - crossHalfLength, radius + crossHalfLength, radius + crossHalfLength, radius - crossHalfLength);
        crossLineRight.setStrokeWidth(strokeWidth);
        crossLineRight.setStrokeLineCap(StrokeLineCap.ROUND);
        crossLineRight.setStrokeType(StrokeType.CENTERED);
        crossLineRight.setStroke((Paint)strokeColor);
        crossLineRight.setFill((Paint)strokeColor);
        Group node = new Group(new Node[]{circle, crossLineRight, crossLineLeft});
        node.setPickOnBounds(true);
        node.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-close-icon"});
        return node;
    }

    public Shape createMagnifierIcon(double size) {
        return this.createMagnifierIcon(size, false);
    }

    public Shape createMagnifierIcon(double size, boolean showArrow) {
        Shape shape;
        Color strokeColor = new Color(0.3, 0.3, 0.3, 1.0);
        Color fillColor = new Color(1.0, 1.0, 1.0, 0.0);
        double ratio = 0.6;
        double strokeWidth = size / 10.0;
        double circleRadius = size * ratio / 2.0;
        Circle mirror = new Circle(circleRadius, circleRadius, circleRadius);
        Line handle = new Line(circleRadius * 2.0, circleRadius, size, circleRadius);
        Shape magnifier = Shape.union((Shape)mirror, (Shape)handle);
        magnifier.setRotate(135.0);
        if (showArrow) {
            Shape arrow = this.createArrowIcon(3.0);
            arrow.setLayoutX(size);
            arrow.setLayoutY(size - 7.0);
            shape = Shape.union((Shape)magnifier, (Shape)arrow);
        } else {
            shape = magnifier;
        }
        shape.setStrokeWidth(strokeWidth);
        shape.setStroke((Paint)strokeColor);
        shape.setFill((Paint)fillColor);
        shape.setPickOnBounds(true);
        shape.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-magnifier-icon"});
        return shape;
    }

    public Shape createFilterIcon(double size) {
        Color strokeColor = new Color(0.3, 0.3, 0.3, 1.0);
        Color fillColor = new Color(1.0, 1.0, 1.0, 0.0);
        double strokeWidth = size / 20.0 + 1.0;
        double top = 0.35;
        double footTilt = 0.2;
        Polygon filter = new Polygon(new double[]{0.0, 0.0, size * top, size * top, size * top, size, size * (1.0 - top), size * (1.0 - footTilt), size * (1.0 - top), size * top, size, 0.0});
        filter.setStroke((Paint)strokeColor);
        filter.setStrokeWidth(strokeWidth);
        filter.setFill((Paint)fillColor);
        filter.setPickOnBounds(true);
        filter.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-filter-icon"});
        return filter;
    }

    public Shape createKeyIcon(double size) {
        Color strokeColor = new Color(0.2, 0.2, 0.2, 1.0);
        Color fillColor = new Color(1.0, 1.0, 1.0, 0.0);
        double stroke = 1.0 + size / 20.0;
        double circleRadius = size / 3.0;
        double lineLength = circleRadius * 0.3;
        double lineStartX = size / 6.0;
        double lineStartY = size / 20.0;
        Circle circle = new Circle(size - circleRadius, size - circleRadius, circleRadius);
        Line trunk = new Line(0.0, 0.0, size - (circleRadius + circleRadius / Math.sqrt(2.0)) - 1.0, size - (circleRadius + circleRadius / Math.sqrt(2.0)) - 1.0);
        Line teeth = new Line(lineStartX, lineStartY, lineStartX + lineLength, lineStartY + lineLength);
        Shape shape = Shape.union((Shape)circle, (Shape)Shape.union((Shape)trunk, (Shape)teeth));
        shape.setStrokeWidth(stroke);
        shape.setStroke((Paint)strokeColor);
        shape.setFill((Paint)fillColor);
        shape.setPickOnBounds(true);
        shape.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-key-icon"});
        return shape;
    }

    public Shape createCalendarIcon(double size) {
        Color fillColor = new Color(0.3, 0.3, 0.3, 1.0);
        double width = size;
        double height = size;
        double lineWidth = width / 8.0;
        double padding = width / 16.0;
        double topLineHeight = 1.5 * lineWidth;
        Rectangle board = new Rectangle(0.0, lineWidth - 1.0, width, height - lineWidth + 1.0);
        board.setArcHeight(lineWidth * 2.0);
        board.setArcWidth(lineWidth * 2.0);
        board.setStrokeWidth(0.0);
        Rectangle content = new Rectangle(padding, 3.0 * lineWidth, width - 2.0 * padding, height - 4.0 * lineWidth);
        content.setArcWidth(lineWidth);
        content.setArcHeight(lineWidth);
        content.setStrokeWidth(0.0);
        Line line1 = new Line(2.0 * lineWidth, 0.0, 2.0 * lineWidth, topLineHeight);
        line1.setStrokeWidth(lineWidth);
        line1.setStrokeLineCap(StrokeLineCap.ROUND);
        Line line11 = new Line(2.0 * lineWidth, 0.0, 2.0 * lineWidth, topLineHeight);
        line11.setStrokeWidth(lineWidth * 2.0);
        line11.setStrokeLineCap(StrokeLineCap.ROUND);
        Line line2 = new Line(width - 2.0 * lineWidth, 0.0, width - 2.0 * lineWidth, topLineHeight);
        line2.setStrokeWidth(lineWidth);
        line2.setStrokeLineCap(StrokeLineCap.ROUND);
        Line line21 = new Line(width - 2.0 * lineWidth, 0.0, width - 2.0 * lineWidth, topLineHeight);
        line21.setStrokeWidth(lineWidth * 2.0);
        line21.setStrokeLineCap(StrokeLineCap.ROUND);
        Rectangle dot = new Rectangle(0.0, 0.0, lineWidth, lineWidth);
        dot.setStrokeLineCap(StrokeLineCap.BUTT);
        Shape shape = Shape.union((Shape)Shape.union((Shape)Shape.subtract((Shape)Shape.subtract((Shape)Shape.subtract((Shape)board, (Shape)content), (Shape)line11), (Shape)line21), (Shape)line1), (Shape)line2);
        int x = 0;
        while (x < 4) {
            int y = 0;
            while (y < 2) {
                dot.setX(lineWidth * 1.2 + 1.5 * lineWidth * (double)x);
                dot.setY(3.8 * lineWidth + 1.5 * lineWidth * (double)y);
                shape = Shape.union((Shape)shape, (Shape)dot);
                ++y;
            }
            ++x;
        }
        shape.setFill((Paint)fillColor);
        shape.setPickOnBounds(true);
        shape.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-calendar-icon"});
        return shape;
    }

    public Shape createClockIcon(double size) {
        Color fillColor = new Color(0.3, 0.3, 0.3, 1.0);
        double radius = size / 2.0;
        double lineWidth = size / 16.0;
        double dotRadius = size / 16.0;
        double padding = size / 8.0;
        Circle board = new Circle(radius, radius, radius);
        board.setStrokeWidth(0.0);
        Circle dot1 = new Circle(padding, radius, dotRadius);
        dot1.setStrokeWidth(0.0);
        Circle dot2 = new Circle(radius * 2.0 - padding, radius, dotRadius);
        dot2.setStrokeWidth(0.0);
        Circle dot3 = new Circle(radius, padding, dotRadius);
        dot3.setStrokeWidth(0.0);
        Circle dot4 = new Circle(radius, radius * 2.0 - padding, dotRadius);
        dot4.setStrokeWidth(0.0);
        Line hour = new Line(radius, radius, radius * 2.0 - padding * 1.5, padding * 1.5);
        hour.setStrokeWidth(lineWidth);
        hour.setStrokeLineCap(StrokeLineCap.ROUND);
        Line minute = new Line(radius, radius, padding * 2.0, padding * 2.0);
        minute.setStrokeWidth(lineWidth);
        minute.setStrokeLineCap(StrokeLineCap.ROUND);
        Shape shape = Shape.subtract((Shape)Shape.subtract((Shape)Shape.subtract((Shape)Shape.subtract((Shape)Shape.subtract((Shape)Shape.subtract((Shape)board, (Shape)dot1), (Shape)dot2), (Shape)dot3), (Shape)dot4), (Shape)minute), (Shape)hour);
        shape.setFill((Paint)fillColor);
        shape.setPickOnBounds(true);
        shape.getStyleClass().addAll((Object[])new String[]{STYLE_CLASS_DEFAULT, "predefined-clock-icon"});
        return shape;
    }

    public Shape createArrowedIcon(Shape shape) {
        return this.createArrowedIcon(shape, Pos.BOTTOM_RIGHT, 0.4);
    }

    public Shape createArrowedIcon(Shape shape, Pos pos, double ratio) {
        double width = shape.prefWidth(-1.0);
        double height = shape.prefHeight(-1.0);
        double arrowWidth = width * ratio;
        double arrowHeight = arrowWidth / 2.0 + 2.0;
        Shape arrowIcon = PredefinedShapes.getInstance().createArrowIcon(arrowWidth);
        switch (pos) {
            case BOTTOM_RIGHT: {
                arrowIcon.setLayoutX(width + 1.0);
                arrowIcon.setLayoutY(height - arrowHeight);
                break;
            }
            case BOTTOM_LEFT: {
                arrowIcon.setLayoutX(-arrowWidth - 1.0);
                arrowIcon.setLayoutY(height - arrowHeight);
                break;
            }
            case TOP_RIGHT: {
                arrowIcon.setLayoutX(width + 1.0);
                arrowIcon.setLayoutY(arrowHeight / 2.0);
                break;
            }
            case TOP_LEFT: {
                arrowIcon.setLayoutX(-arrowWidth - 1.0);
                arrowIcon.setLayoutY(arrowHeight / 2.0);
            }
        }
        Shape union = Shape.union((Shape)shape, (Shape)arrowIcon);
        union.setStrokeWidth(shape.getStrokeWidth());
        union.setStroke(shape.getStroke());
        union.setFill(shape.getFill());
        union.getStyleClass().addAll((Collection)shape.getStyleClass());
        return union;
    }

    public Shape createPlusIcon(double size) {
        Color fillColor = new Color(0.3, 0.3, 0.3, 1.0);
        double width = 0.2;
        double v = size * (1.0 - width) / 2.0;
        Polygon shape = new Polygon(new double[]{0.0, v, v, v, v, 0.0, size - v, 0.0, size - v, v, size, v, size, size - v, size - v, size - v, size - v, size, v, size, v, size - v, 0.0, size - v});
        shape.setStrokeLineCap(StrokeLineCap.ROUND);
        shape.setStroke((Paint)fillColor);
        return shape;
    }

    public Shape createMinusIcon(double size) {
        Color fillColor = new Color(0.3, 0.3, 0.3, 1.0);
        double width = 0.2;
        Rectangle shape = new Rectangle(0.0, 0.0, size, size * width);
        shape.setStroke((Paint)fillColor);
        return shape;
    }
}

