/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils;

public class TypeUtils {
    private static final int WRAPPER_TYPE_INDEX = 0;
    private static final int PRIMITIVE_TYPE_INDEX = 1;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class, Boolean.TYPE, "Z"}, {Character.class, Character.TYPE, "C"}, {Byte.class, Byte.TYPE, "B"}, {Short.class, Short.TYPE, "S"}, {Integer.class, Integer.TYPE, "I"}, {Long.class, Long.TYPE, "J"}, {Float.class, Float.TYPE, "F"}, {Double.class, Double.TYPE, "D"}};

    public static boolean isPrimitive(Class<?> primitive) {
        Object[][] objectArray = PRIMITIVE_ARRAY_TYPES;
        int n = PRIMITIVE_ARRAY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] primitiveArrayType = objectArray[n2];
            if (primitiveArrayType[1] == primitive) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(Class<?> wrapperType) {
        Object[][] objectArray = PRIMITIVE_ARRAY_TYPES;
        int n = PRIMITIVE_ARRAY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] primitiveArrayType = objectArray[n2];
            if (primitiveArrayType[0] == wrapperType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class<?> convertPrimitiveToWrapperType(Class<?> primitive) {
        Object[][] objectArray = PRIMITIVE_ARRAY_TYPES;
        int n = PRIMITIVE_ARRAY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] primitiveArrayType = objectArray[n2];
            if (primitiveArrayType[1] == primitive) {
                return (Class)primitiveArrayType[0];
            }
            ++n2;
        }
        return primitive;
    }

    public static Class<?> convertWrapperToPrimitiveType(Class<?> wrapperType) {
        Object[][] objectArray = PRIMITIVE_ARRAY_TYPES;
        int n = PRIMITIVE_ARRAY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] primitiveArrayType = objectArray[n2];
            if (primitiveArrayType[0] == wrapperType) {
                return (Class)primitiveArrayType[1];
            }
            ++n2;
        }
        return wrapperType;
    }

    public static boolean isNumericType(Class<?> type) {
        return type != null && (Number.class.isAssignableFrom(type) || type == Double.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Short.TYPE || type == Long.TYPE);
    }
}

