/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;

public enum Platform {
    WINDOWS("windows"),
    OSX("mac"),
    UNIX("unix"),
    UNKNOWN("");

    private static Platform current;
    private String platformId;

    static {
        current = Platform.getCurrentPlatform();
    }

    private Platform(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public static Platform getCurrent() {
        return current;
    }

    private static Platform getCurrentPlatform() {
        String javafxPlatform;
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return WINDOWS;
        }
        if (osName.startsWith("Mac")) {
            return OSX;
        }
        if (osName.startsWith("SunOS")) {
            return UNIX;
        }
        if (osName.startsWith("Linux") && !"android".equals(javafxPlatform = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("javafx.platform");
            }
        })) && !"Dalvik".equals(System.getProperty("java.vm.name"))) {
            return UNIX;
        }
        return UNKNOWN;
    }
}

