/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.AdaptableScopes;
import org.eclipse.gef.common.adapt.inject.AdapterInjectionSupport;
import org.eclipse.gef.common.adapt.inject.AdapterMap;
import org.eclipse.gef.common.reflect.Types;

public class AdapterInjector
implements MembersInjector<IAdaptable> {
    private BindingTargetVisitor<Object, TypeToken<?>> ADAPTER_TYPE_INFERRER = new BindingTargetVisitor<Object, TypeToken<?>>(){

        public TypeToken<?> visit(ConstructorBinding<? extends Object> binding) {
            return TypeToken.of((Type)binding.getKey().getTypeLiteral().getType());
        }

        public TypeToken<?> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(LinkedKeyBinding<? extends Object> binding) {
            Binding linkedKeyBinding = AdapterInjector.this.injector.getBinding(binding.getLinkedKey());
            return (TypeToken)linkedKeyBinding.acceptTargetVisitor((BindingTargetVisitor)this);
        }

        public TypeToken<?> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderInstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    };
    private MultibindingsTargetVisitor<Object, MapBinderBinding<?>> ADAPTER_MAP_BINDING_FILTER = new MultibindingsTargetVisitor<Object, MapBinderBinding<?>>(){

        public MapBinderBinding<?> visit(ConstructorBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(LinkedKeyBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(MapBinderBinding<? extends Object> mapbinding) {
            return mapbinding;
        }

        public MapBinderBinding<?> visit(MultibinderBinding<? extends Object> multibinding) {
            return null;
        }

        public MapBinderBinding<?> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(ProviderInstanceBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public MapBinderBinding<?> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    };
    private final List<IAdaptable> deferredInstances = new ArrayList<IAdaptable>();
    private Injector injector;
    private final Method method;
    private AdapterInjectionSupport.LoggingMode loggingMode;

    public AdapterInjector(Method method, AdapterInjectionSupport.LoggingMode loggingMode) {
        this.method = method;
        this.loggingMode = loggingMode;
    }

    private void deferAdapterInjection(IAdaptable adaptable, final Runnable runnable) {
        if (adaptable instanceof IAdaptable.Bound) {
            ReadOnlyObjectProperty adaptableProperty = ((IAdaptable.Bound)((Object)adaptable)).adaptableProperty();
            if (adaptableProperty.get() == null) {
                adaptableProperty.addListener((ChangeListener)new ChangeListener<IAdaptable>(){

                    public void changed(ObservableValue<? extends IAdaptable> observable, IAdaptable oldValue, IAdaptable newValue) {
                        if (newValue != null) {
                            observable.removeListener((ChangeListener)this);
                            AdapterInjector.this.deferAdapterInjection(newValue, runnable);
                        }
                    }
                });
            } else {
                this.deferAdapterInjection((IAdaptable)adaptableProperty.get(), runnable);
            }
        } else {
            runnable.run();
        }
    }

    private TypeToken<?> inferAdapterType(AdapterKey<?> adapterKey, Binding<?> binding, Object adapter, List<String> issues) {
        TypeToken bindingInferredType = (TypeToken)binding.acceptTargetVisitor(this.ADAPTER_TYPE_INFERRER);
        this.validateAdapterBinding(adapterKey, binding, adapter, bindingInferredType, issues);
        TypeToken bindingKeyType = adapterKey.getKey();
        return bindingKeyType != null ? bindingKeyType : (bindingInferredType != null ? bindingInferredType : TypeToken.of(adapter.getClass()));
    }

    protected void injectAdapters(IAdaptable adaptable) {
        this.deferAdapterInjection(adaptable, () -> {
            ArrayList<String> issues = new ArrayList<String>();
            this.performAdapterInjection(adaptable, issues);
            for (String issue : issues) {
                if (!AdapterInjectionSupport.LoggingMode.DEVELOPMENT.equals((Object)this.loggingMode) && !issue.startsWith("*** ERROR")) continue;
                System.err.println(issue);
            }
        });
    }

    public void injectMembers(IAdaptable instance) {
        if (this.injector == null) {
            this.deferredInstances.add(instance);
        } else {
            this.injectAdapters(instance);
        }
    }

    private boolean isContextApplicable(IAdaptable injectionTarget, AdapterMap.BoundAdapter[] injectionContext) {
        int contextIndex = 0;
        String contextRole = injectionContext[contextIndex].adapterRole();
        TypeToken<?> contextType = Types.deserialize(injectionContext[contextIndex].adapterType());
        IAdaptable chainElement = injectionTarget;
        while (chainElement instanceof IAdaptable.Bound) {
            Object nextChainElement = ((IAdaptable.Bound)((Object)chainElement)).getAdaptable();
            if (nextChainElement == null) {
                throw new IllegalStateException("Adapter injection seems to have been performed while the adaptable chain is not complete yet. The adaptable is not yet set.");
            }
            if (nextChainElement.getAdapterKey((IAdaptable)chainElement) == null) {
                throw new IllegalStateException("Adapter injection seems to have been performed while the adaptable chain is not complete yet. The adapter is not yet set.");
            }
            if (contextRole.equals(nextChainElement.getAdapterKey((IAdaptable)chainElement).getRole()) && contextType.isSupertypeOf(chainElement.getClass())) {
                if (++contextIndex == injectionContext.length) {
                    return true;
                }
                contextRole = injectionContext[contextIndex].adapterRole();
                contextType = Types.deserialize(injectionContext[contextIndex].adapterType());
            }
            chainElement = nextChainElement;
        }
        return false;
    }

    private void performAdapterInjection(IAdaptable adaptable, List<String> issues) {
        AdaptableScopes.enter(adaptable);
        for (Map.Entry entry : this.injector.getAllBindings().entrySet()) {
            AdapterMap keyAnnotation;
            MapBinderBinding adapterMapBinding = null;
            Key key = (Key)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            if (key.getAnnotationType() != null && AdapterMap.class.equals((Object)key.getAnnotationType()) && (keyAnnotation = (AdapterMap)key.getAnnotation()).adaptableType().isAssignableFrom(adaptable.getClass())) {
                if (keyAnnotation.adaptableContext().length != 0) {
                    if (this.isContextApplicable(adaptable, keyAnnotation.adaptableContext())) {
                        adapterMapBinding = (MapBinderBinding)binding.acceptTargetVisitor(this.ADAPTER_MAP_BINDING_FILTER);
                    }
                } else {
                    adapterMapBinding = (MapBinderBinding)binding.acceptTargetVisitor(this.ADAPTER_MAP_BINDING_FILTER);
                }
            }
            if (adapterMapBinding == null) continue;
            for (Map.Entry adapterBinding : adapterMapBinding.getEntries()) {
                AdapterKey adapterKey = (AdapterKey)adapterBinding.getKey();
                Object adapter = ((Binding)adapterBinding.getValue()).getProvider().get();
                TypeToken<?> adapterType = this.inferAdapterType(adapterKey, (Binding)adapterBinding.getValue(), adapter, issues);
                try {
                    this.method.setAccessible(true);
                    this.method.invoke((Object)adaptable, adapterType, adapter, adapterKey.getRole());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        AdaptableScopes.leave(adaptable);
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (IAdaptable instance : this.deferredInstances) {
            this.injectAdapters(instance);
        }
        this.deferredInstances.clear();
    }

    private void validateAdapterBinding(AdapterKey<?> adapterKey, Binding<?> binding, Object adapter, TypeToken<?> bindingInferredType, List<String> issues) {
        TypeToken<?> bindingKeyType = adapterKey.getKey();
        if (bindingInferredType != null) {
            if (bindingKeyType != null) {
                if (bindingKeyType.equals(bindingInferredType)) {
                    issues.add("*** INFO: The actual type of adapter " + adapter + " could already be inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "          The redundant type key " + bindingKeyType + " may be omitted in the adapter key of the binding, using " + ("default".equals(adapterKey.getRole()) ? "AdapterKey.defaultRole()" : " AdapterKey.role(" + adapterKey.getRole() + ")") + " instead.");
                } else if (bindingInferredType.getType() instanceof ParameterizedType) {
                    issues.add("*** WARNING: The given key type " + bindingKeyType + " does not seem to match the actual type of adapter " + adapter + " which was inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "             The adapter will only be retrievable via key types assignable to " + bindingKeyType + ". You should probably adjust your binding.");
                } else if (!bindingInferredType.getRawType().equals(bindingKeyType.getRawType())) {
                    issues.add("*** ERROR: The given key (raw) type " + bindingKeyType.getRawType().getName() + " does not match the actual (raw) type of adapter " + adapter + " which was inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "           The adapter will only be retrievable via key types assignable to " + bindingKeyType + ". You need to adjust your binding.");
                }
            }
        } else if (bindingKeyType == null) {
            issues.add("*** WARNING: The actual type of adapter " + adapter + " could not be inferred from the binding at " + binding.getSource() + ". The adapter will only be retrievable via key types assignable to " + TypeToken.of(adapter.getClass()) + ", which is the actual type inferred from the instance.\n" + "             You should probably adjust your binding to provide a type key using " + ("default".equals(adapterKey.getRole()) ? "AdapterKey.get(<type>)" : "AdapterKey.get(<type>, " + adapterKey.getRole() + ")") + ".");
        } else if (!bindingKeyType.getRawType().isAssignableFrom(adapter.getClass()) || !adapter.getClass().isAnonymousClass() && !adapter.getClass().isAssignableFrom(bindingKeyType.getRawType())) {
            issues.add("*** ERROR: The given key (raw) type " + bindingKeyType.getRawType().getName() + " does not match the actual (raw) type of adapter " + adapter + ", which was inferred as " + adapter.getClass().getName() + ".\n" + "           You need to adjust your binding.");
        } else {
            issues.add("*** WARNING: The actual type of adapter " + adapter + " could not be inferred from the binding at " + binding.getSource() + ". Therefore, the given type key " + bindingKeyType + " can not be confirmed.\n" + "             Make sure the provided type key " + bindingKeyType + " matches to the actual type of the adapter.");
        }
    }
}

