/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.adapt.inject;

import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.common.adapt.inject.AdapterMap;
import org.eclipse.gef.common.reflect.Types;

class AdapterMapImpl
implements AdapterMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<? extends IAdaptable> adaptableType;
    private AdapterMap.BoundAdapter[] adaptableContext = new AdapterMap.BoundAdapter[0];

    public AdapterMapImpl(Class<? extends IAdaptable> adaptableType) {
        this.adaptableType = adaptableType;
    }

    public AdapterMapImpl(Class<? extends IAdaptable> adaptableType, AdapterMap.BoundAdapter ... adaptableContext) {
        this.adaptableType = adaptableType;
        this.adaptableContext = adaptableContext;
    }

    @Override
    public AdapterMap.BoundAdapter[] adaptableContext() {
        return this.adaptableContext;
    }

    public Class<? extends IAdaptable> adaptableType() {
        return this.adaptableType;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return AdapterMap.class;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AdapterMap)) {
            return false;
        }
        AdapterMap other = (AdapterMap)obj;
        return this.adaptableType.equals(other.adaptableType()) && Arrays.equals(this.adaptableContext, other.adaptableContext());
    }

    @Override
    public int hashCode() {
        return 127 * "type".hashCode() ^ Arrays.hashCode(this.adaptableContext) + 127 * "role".hashCode() ^ Arrays.hashCode(this.adaptableContext);
    }

    @Override
    public String toString() {
        return "@" + AdapterMap.class.getName() + "(adaptableType=" + this.adaptableType + ", " + "adaptableContext=" + Arrays.toString(this.adaptableContext) + ")";
    }

    static class BoundAdapterImpl
    implements AdapterMap.BoundAdapter,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String adapterType = null;
        private String adapterRole = "default";

        public BoundAdapterImpl(String adapterType) {
            TypeToken<?> type = Types.deserialize(adapterType);
            if (!TypeToken.of(IAdaptable.class).isSupertypeOf(type) || !TypeToken.of(IAdaptable.Bound.class).isSupertypeOf(type)) {
                throw new IllegalArgumentException("Context element has to be IAdaptable and IAdaptable.Bound, which does not hold for " + type.toString());
            }
            this.adapterType = adapterType;
        }

        public BoundAdapterImpl(String adapterType, String adapterRole) {
            this(adapterType);
            this.adapterRole = adapterRole;
        }

        @Override
        public String adapterRole() {
            return this.adapterRole;
        }

        @Override
        public String adapterType() {
            return this.adapterType;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return AdapterMap.BoundAdapter.class;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof AdapterMap.BoundAdapter)) {
                return false;
            }
            AdapterMap.BoundAdapter other = (AdapterMap.BoundAdapter)obj;
            return this.adapterType.equals(other.adapterType()) && this.adapterRole.equals(other.adapterRole());
        }

        @Override
        public int hashCode() {
            return 127 * "adapterType".hashCode() ^ this.adapterType.hashCode() + 127 * "adapterRole".hashCode() ^ this.adapterRole.hashCode();
        }

        @Override
        public String toString() {
            return "@" + AdapterMap.BoundAdapter.class.getName() + "(adapterType=" + this.adapterType + ", " + "adapterRole=" + this.adapterRole + ")";
        }
    }
}

