/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.common.reflect;

import com.google.common.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Base64;

public class Types {
    public static <T> TypeToken<T> argumentOf(Class<?> contextClass) {
        while (contextClass != null && !(contextClass.getGenericSuperclass() instanceof ParameterizedType)) {
            contextClass = contextClass.getSuperclass();
        }
        return TypeToken.of((Type)((ParameterizedType)contextClass.getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    public static final TypeToken<?> deserialize(String string) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(string));
            ObjectInputStream ois = new ObjectInputStream(bis);
            TypeToken typeToken = (TypeToken)ois.readObject();
            ois.close();
            return typeToken;
        }
        catch (ClassCastException | ClassNotFoundException exception) {
            throw new IllegalArgumentException("String does not seem to be of type TokeToken.");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not deserialize TypeToken.");
        }
    }

    public static final String serialize(TypeToken<?> typeToken) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(typeToken);
            os.close();
            return Base64.getEncoder().encodeToString(bos.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Could not serialize " + typeToken);
        }
    }
}

