/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.anchors;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.common.beans.property.ReadOnlySetMultimapProperty;
import org.eclipse.gef.common.beans.property.ReadOnlySetMultimapWrapper;
import org.eclipse.gef.common.beans.property.ReadOnlySetWrapperEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.common.collections.SetMultimapChangeListener;
import org.eclipse.gef.fx.anchors.AbstractAnchor;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.ChopBoxStrategy;
import org.eclipse.gef.fx.anchors.IComputationStrategy;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;

public class DynamicAnchor
extends AbstractAnchor {
    private SetMultimapChangeListener<AnchorKey, IComputationStrategy.Parameter<?>> anchoredComputationParametersChangeListener = new SetMultimapChangeListener<AnchorKey, IComputationStrategy.Parameter<?>>(){
        private Map<AnchorKey, ChangeListener<Object>> valueChangeListeners = new HashMap<AnchorKey, ChangeListener<Object>>();

        public void onChanged(SetMultimapChangeListener.Change<? extends AnchorKey, ? extends IComputationStrategy.Parameter<?>> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    if (change.getKey() == null) {
                        throw new IllegalStateException("Attempt to put <null> key into reference point map!");
                    }
                    if (change.getValuesAdded().contains(null)) {
                        throw new IllegalStateException("Attempt to put <null> value for key " + change.getKey() + " into reference point map!");
                    }
                    for (IComputationStrategy.Parameter p : change.getValuesAdded()) {
                        final AnchorKey key = (AnchorKey)change.getKey();
                        ChangeListener<Object> l = this.valueChangeListeners.get(key);
                        if (l == null) {
                            l = new ChangeListener<Object>(){

                                public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                                    DynamicAnchor.this.updatePosition(key);
                                }
                            };
                            this.valueChangeListeners.put(key, l);
                        }
                        p.addListener(l);
                    }
                } else if (change.wasRemoved()) {
                    for (IComputationStrategy.Parameter p : change.getValuesRemoved()) {
                        p.removeListener(this.valueChangeListeners.get(change.getKey()));
                    }
                }
                DynamicAnchor.this.updatePosition((AnchorKey)change.getKey());
            }
        }
    };
    private IComputationStrategy computationStrategy;
    private ObservableSet<IComputationStrategy.Parameter<?>> anchorageComputationParameters = FXCollections.observableSet(new HashSet());
    private ReadOnlySetWrapper<IComputationStrategy.Parameter<?>> anchorageComputationParametersProperty = new ReadOnlySetWrapperEx(this.anchorageComputationParameters);
    private ObservableSetMultimap<AnchorKey, IComputationStrategy.Parameter<?>> anchoredComputationParameters = CollectionUtils.observableHashMultimap();
    private ReadOnlySetMultimapWrapper<AnchorKey, IComputationStrategy.Parameter<?>> anchoredComputationParametersProperty = new ReadOnlySetMultimapWrapper(this.anchoredComputationParameters);
    private SetChangeListener<IComputationStrategy.Parameter<?>> anchorageComputationParametersChangeListener = new SetChangeListener<IComputationStrategy.Parameter<?>>(){
        private ChangeListener<Object> valueChangeListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                DynamicAnchor.this.updatePositions();
            }
        };

        public void onChanged(SetChangeListener.Change<? extends IComputationStrategy.Parameter<?>> change) {
            if (change.wasRemoved()) {
                ((IComputationStrategy.Parameter)((Object)change.getElementRemoved())).removeListener(this.valueChangeListener);
            }
            if (change.wasAdded()) {
                ((IComputationStrategy.Parameter)((Object)change.getElementAdded())).addListener(this.valueChangeListener);
            }
            DynamicAnchor.this.updatePositions();
        }
    };

    public DynamicAnchor(Node anchorage) {
        this(anchorage, new ChopBoxStrategy());
    }

    public DynamicAnchor(final Node anchorage, IComputationStrategy computationStrategy) {
        super(anchorage);
        this.setComputationStrategy(computationStrategy);
        this.anchorageComputationParameters.addListener(this.anchorageComputationParametersChangeListener);
        this.anchoredComputationParameters.addListener(this.anchoredComputationParametersChangeListener);
        if (computationStrategy.getRequiredParameters().contains(AnchorageReferenceGeometry.class)) {
            this.getComputationParameter(AnchorageReferenceGeometry.class).bind(new ObjectBinding<IGeometry>(){
                {
                    this.bind(new Observable[]{node.layoutBoundsProperty()});
                }

                protected IGeometry computeValue() {
                    return NodeUtils.getShapeOutline(anchorage);
                }
            });
        }
    }

    protected ReadOnlySetProperty<IComputationStrategy.Parameter<?>> anchorageComputationParametersProperty() {
        return this.anchorageComputationParametersProperty.getReadOnlyProperty();
    }

    protected ReadOnlySetMultimapProperty<AnchorKey, IComputationStrategy.Parameter<?>> anchoredComputationParametersProperty() {
        return this.anchoredComputationParametersProperty.getReadOnlyProperty();
    }

    @Override
    public void attach(AnchorKey key) {
        this.initAnchoredParameters(key);
        super.attach(key);
    }

    private void clearAnchoredParameters(AnchorKey key) {
        this.anchoredComputationParameters.removeAll((Object)key);
    }

    @Override
    protected Point computePosition(AnchorKey key) {
        Set<IComputationStrategy.Parameter<?>> parameters = this.getParameters(key);
        for (Class<? extends IComputationStrategy.Parameter<?>> clazz : this.computationStrategy.getRequiredParameters()) {
            IComputationStrategy.Parameter<?> p = IComputationStrategy.Parameter.get(parameters, clazz);
            if (p != null && (p.get() != null || p.isOptional())) continue;
            return null;
        }
        Point point = this.computationStrategy.computePositionInScene(this.getAnchorage(), key.getAnchored(), parameters);
        Point position = FX2Geometry.toPoint((Point2D)key.getAnchored().sceneToLocal(Geometry2FX.toFXPoint((Point)point)));
        return position;
    }

    @Override
    public void detach(AnchorKey key) {
        super.detach(key);
        this.clearAnchoredParameters(key);
    }

    public <T extends IComputationStrategy.Parameter<?>> T getComputationParameter(AnchorKey key, Class<T> parameterType) {
        Object parameter = IComputationStrategy.Parameter.get(this.anchorageComputationParametersProperty(), parameterType);
        if (parameter != null) {
            return parameter;
        }
        parameter = IComputationStrategy.Parameter.get(this.anchoredComputationParametersProperty().get((Object)key), parameterType);
        if (parameter != null) {
            return parameter;
        }
        try {
            parameter = (IComputationStrategy.Parameter)((Object)parameterType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            if (IComputationStrategy.Parameter.Kind.ANCHORED.equals((Object)((IComputationStrategy.Parameter)((Object)parameter)).getKind())) {
                this.anchoredComputationParametersProperty().put((Object)key, parameter);
            } else {
                this.anchorageComputationParametersProperty().add(parameter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parameter;
    }

    public <T extends IComputationStrategy.Parameter<?>> T getComputationParameter(Class<T> parameterType) {
        Object parameter = IComputationStrategy.Parameter.get(this.anchorageComputationParametersProperty(), parameterType);
        if (parameter != null) {
            return parameter;
        }
        try {
            parameter = (IComputationStrategy.Parameter)((Object)parameterType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!IComputationStrategy.Parameter.Kind.ANCHORAGE.equals((Object)((IComputationStrategy.Parameter)((Object)parameter)).getKind())) {
            throw new IllegalArgumentException("Specified parameter type " + parameterType.getSimpleName() + " is anchored, it has to be queried per AdapterKey.");
        }
        this.anchorageComputationParametersProperty().add(parameter);
        return parameter;
    }

    public IComputationStrategy getComputationStrategy() {
        return this.computationStrategy;
    }

    protected Set<IComputationStrategy.Parameter<?>> getParameters(AnchorKey key) {
        HashSet parameters = new HashSet();
        parameters.addAll((Collection<IComputationStrategy.Parameter<?>>)this.anchorageComputationParameters);
        parameters.addAll(this.anchoredComputationParameters.get((Object)key));
        return parameters;
    }

    private void initAnchorageParameters() {
        for (Class<IComputationStrategy.Parameter<?>> paramType : this.computationStrategy.getRequiredParameters()) {
            if (!IComputationStrategy.Parameter.Kind.ANCHORAGE.equals((Object)IComputationStrategy.Parameter.getKind(paramType)) || IComputationStrategy.Parameter.get(this.anchorageComputationParameters, paramType) != null) continue;
            try {
                IComputationStrategy.Parameter<?> p = paramType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.anchorageComputationParameters.add(p);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create instance of parameter type " + paramType, e);
            }
        }
    }

    private void initAnchoredParameters(AnchorKey key) {
        Set<IComputationStrategy.Parameter<?>> parameters = this.getParameters(key);
        for (Class<IComputationStrategy.Parameter<?>> paramType : this.computationStrategy.getRequiredParameters()) {
            if (!IComputationStrategy.Parameter.Kind.ANCHORED.equals((Object)IComputationStrategy.Parameter.getKind(paramType)) || IComputationStrategy.Parameter.get(parameters, paramType) != null) continue;
            try {
                IComputationStrategy.Parameter<?> p = paramType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!IComputationStrategy.Parameter.Kind.ANCHORED.equals((Object)p.getKind())) continue;
                this.anchoredComputationParameters.put((Object)key, p);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Could not create instance of parameter type " + paramType, e);
            }
        }
    }

    public void setComputationStrategy(IComputationStrategy computationStrategy) {
        for (AnchorKey key : this.getKeys()) {
            this.clearAnchoredParameters(key);
        }
        this.computationStrategy = computationStrategy;
        this.initAnchorageParameters();
        for (AnchorKey key : this.getKeys()) {
            this.initAnchoredParameters(key);
        }
    }

    public static class AnchorageReferenceGeometry
    extends IComputationStrategy.Parameter<IGeometry> {
        public AnchorageReferenceGeometry() {
            this((IGeometry)new Rectangle());
        }

        public AnchorageReferenceGeometry(IGeometry defaultValue) {
            super(IComputationStrategy.Parameter.Kind.ANCHORAGE);
            this.set(defaultValue);
        }
    }

    public static class AnchorageReferencePosition
    extends IComputationStrategy.Parameter<Point> {
        public AnchorageReferencePosition() {
            this((Point)null);
        }

        public AnchorageReferencePosition(Point defaultValue) {
            super(IComputationStrategy.Parameter.Kind.ANCHORAGE);
            this.set(defaultValue);
        }
    }

    public static class AnchoredReferencePoint
    extends IComputationStrategy.Parameter<Point> {
        public AnchoredReferencePoint() {
            this(new Point());
        }

        public AnchoredReferencePoint(Point defaultValue) {
            super(IComputationStrategy.Parameter.Kind.ANCHORED);
            this.set(defaultValue);
        }
    }

    public static class PreferredOrientation
    extends IComputationStrategy.Parameter<Orientation> {
        public PreferredOrientation() {
            this(Orientation.VERTICAL);
        }

        public PreferredOrientation(Orientation orientation) {
            super(IComputationStrategy.Parameter.Kind.ANCHORED, true);
            this.set(orientation);
        }
    }
}

