/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.gestures;

import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.gestures.AbstractGesture;

public abstract class AbstractMouseDragGesture
extends AbstractGesture {
    private Node pressed;
    private Point2D startMousePosition;
    private EventHandler<? super MouseEvent> mouseFilter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            AbstractMouseDragGesture.this.onMouseEvent(event);
        }
    };

    protected abstract void drag(Node var1, MouseEvent var2, double var3, double var5);

    public Node getPressed() {
        return this.pressed;
    }

    protected void onMouseEvent(MouseEvent event) {
        EventType type = event.getEventType();
        if (this.pressed == null && type.equals(MouseEvent.MOUSE_PRESSED)) {
            EventTarget target = event.getTarget();
            if (target instanceof Node) {
                this.pressed = (Node)target;
                this.startMousePosition = new Point2D(event.getSceneX(), event.getSceneY());
                this.press(this.pressed, event);
            }
            return;
        }
        if (this.pressed == null) {
            return;
        }
        if (type.equals(MouseEvent.MOUSE_EXITED_TARGET) || type.equals(MouseEvent.MOUSE_ENTERED_TARGET)) {
            return;
        }
        boolean dragged = type.equals(MouseEvent.MOUSE_DRAGGED);
        boolean released = false;
        if (!(dragged || (released = type.equals(MouseEvent.MOUSE_RELEASED)) || event.isPrimaryButtonDown() || event.isSecondaryButtonDown() || event.isMiddleButtonDown())) {
            released = true;
        }
        if (dragged || released) {
            double x = event.getSceneX();
            double dx = x - this.startMousePosition.getX();
            double y = event.getSceneY();
            double dy = y - this.startMousePosition.getY();
            if (dragged) {
                this.drag(this.pressed, event, dx, dy);
            } else {
                this.release(this.pressed, event, dx, dy);
                this.pressed = null;
            }
        }
    }

    protected abstract void press(Node var1, MouseEvent var2);

    @Override
    protected void register() {
        this.getScene().addEventFilter(MouseEvent.ANY, this.mouseFilter);
    }

    protected abstract void release(Node var1, MouseEvent var2, double var3, double var5);

    @Override
    protected void unregister() {
        this.getScene().removeEventFilter(MouseEvent.ANY, this.mouseFilter);
    }
}

