/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.gestures;

import javafx.animation.PauseTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;
import org.eclipse.gef.fx.gestures.AbstractGesture;

public abstract class AbstractScrollGesture
extends AbstractGesture {
    public static final int DEFAULT_FINISH_DELAY_MILLIS = 180;
    private boolean inScroll;
    private PauseTransition finishDelayTransition = new PauseTransition(Duration.millis((double)180.0));
    private EventHandler<ActionEvent> onFinishDelayTransition = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            AbstractScrollGesture.this.inScroll = false;
            AbstractScrollGesture.this.scrollFinished();
        }
    };
    private EventHandler<? super ScrollEvent> scrollFilter;

    public AbstractScrollGesture() {
        this.finishDelayTransition.setCycleCount(1);
        this.finishDelayTransition.setOnFinished(this.onFinishDelayTransition);
        this.scrollFilter = new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                AbstractScrollGesture.this.playFinishDelayTransition();
                if (!AbstractScrollGesture.this.inScroll) {
                    AbstractScrollGesture.this.inScroll = true;
                    AbstractScrollGesture.this.scrollStarted(event);
                } else {
                    AbstractScrollGesture.this.scroll(event);
                }
            }
        };
    }

    protected long getFinishDelayMillis() {
        return 180L;
    }

    protected void playFinishDelayTransition() {
        this.finishDelayTransition.stop();
        this.finishDelayTransition.setDuration(Duration.millis((double)this.getFinishDelayMillis()));
        this.finishDelayTransition.playFromStart();
    }

    @Override
    protected void register() {
        this.getScene().addEventFilter(ScrollEvent.SCROLL, this.scrollFilter);
    }

    protected abstract void scroll(ScrollEvent var1);

    protected abstract void scrollFinished();

    protected abstract void scrollStarted(ScrollEvent var1);

    @Override
    protected void unregister() {
        this.getScene().removeEventFilter(ScrollEvent.SCROLL, this.scrollFilter);
    }
}

