/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerPropertyBase;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef.common.beans.property.ReadOnlyListPropertyBaseEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.common.collections.ListListenerHelperEx;
import org.eclipse.gef.fx.anchors.AnchorKey;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.anchors.StaticAnchor;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.PolylineInterpolator;
import org.eclipse.gef.fx.nodes.StraightRouter;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.PolyBezier;

public class Connection
extends Group {
    private static final String START_ROLE = "start";
    private static final String END_ROLE = "end";
    private static final String CONTROL_POINT_ROLE_PREFIX = "controlpoint-";
    private ObjectProperty<Node> curveProperty = new SimpleObjectProperty();
    private ObjectProperty<Node> startDecorationProperty = null;
    private ObjectProperty<Node> endDecorationProperty = null;
    private ObjectProperty<IConnectionRouter> routerProperty = new SimpleObjectProperty((Object)new StraightRouter());
    private ObjectProperty<IConnectionInterpolator> interpolatorProperty = new SimpleObjectProperty((Object)new PolylineInterpolator());
    private TreeMap<AnchorKey, IAnchor> anchorsByKeys = new TreeMap(new Comparator<AnchorKey>(){

        @Override
        public int compare(AnchorKey o1, AnchorKey o2) {
            if (o1.getId().equals(o2.getId())) {
                return 0;
            }
            if (Connection.this.getStartAnchorKey().getId().equals(o1.getId())) {
                return -1;
            }
            if (Connection.this.getEndAnchorKey().getId().equals(o1.getId())) {
                return 1;
            }
            if (Connection.this.getStartAnchorKey().getId().equals(o2.getId())) {
                return 1;
            }
            if (Connection.this.getEndAnchorKey().getId().equals(o2.getId())) {
                return -1;
            }
            return Connection.this.getControlAnchorIndex(o1) - Connection.this.getControlAnchorIndex(o2);
        }
    });
    private Map<AnchorKey, Point> hintsByKeys = new HashMap<AnchorKey, Point>();
    private ObservableList<IAnchor> anchors = CollectionUtils.observableArrayList();
    private ObservableList<Point> points = CollectionUtils.observableArrayList();
    private PointsUnmodifiableProperty pointsUnmodifiableProperty = null;
    private AnchorsUnmodifiableProperty anchorsUnmodifiableProperty = null;
    private Map<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>> anchorsPCL = new HashMap<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>>();
    private ChangeListener<Node> decorationListener = new ChangeListener<Node>(){
        final ChangeListener<Bounds> decorationLayoutBoundsListener = new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                if (Connection.this.inRefresh) {
                    return;
                }
                Connection.this.refresh();
            }
        };

        public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
            if (Connection.this.inRefresh) {
                return;
            }
            if (oldValue != null) {
                oldValue.layoutBoundsProperty().removeListener(this.decorationLayoutBoundsListener);
            }
            if (newValue != null) {
                newValue.layoutBoundsProperty().addListener(this.decorationLayoutBoundsListener);
            }
            Connection.this.refresh();
        }
    };
    private boolean inRefresh = false;

    public Connection() {
        this.setAutoSizeChildren(false);
        this.routerProperty.addListener((ChangeListener)new ChangeListener<IConnectionRouter>(){

            public void changed(ObservableValue<? extends IConnectionRouter> observable, IConnectionRouter oldValue, IConnectionRouter newValue) {
                if (Connection.this.inRefresh) {
                    return;
                }
                Connection.this.refresh();
            }
        });
        this.interpolatorProperty.addListener((ChangeListener)new ChangeListener<IConnectionInterpolator>(){

            public void changed(ObservableValue<? extends IConnectionInterpolator> observable, IConnectionInterpolator oldValue, IConnectionInterpolator newValue) {
                Connection.this.refresh();
            }
        });
        this.curveProperty.addListener((ChangeListener)new ChangeListener<Node>(){
            private ChangeListener<Transform> transformListener = new ChangeListener<Transform>(){

                public void changed(ObservableValue<? extends Transform> observable, Transform oldValue, Transform newValue) {
                    Connection.this.refresh();
                }
            };
            private ChangeListener<Bounds> boundsListener = new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> observable, Bounds oldValue, Bounds newValue) {
                    Connection.this.refresh();
                }
            };

            public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                Connection.this.inRefresh = true;
                if (oldValue != null) {
                    Connection.this.getChildren().remove((Object)oldValue);
                    oldValue.localToParentTransformProperty().removeListener(this.transformListener);
                    oldValue.layoutBoundsProperty().removeListener(this.boundsListener);
                }
                if (newValue != null) {
                    newValue.layoutBoundsProperty().addListener(this.boundsListener);
                    newValue.localToParentTransformProperty().addListener(this.transformListener);
                    Connection.this.getChildren().add((Object)newValue);
                }
                Connection.this.reattachAnchorKeys(oldValue, newValue);
                Connection.this.inRefresh = false;
                Connection.this.refresh();
            }
        });
        this.setCurve((Node)new GeometryNode());
        this.setStartPoint(new Point());
        this.setEndPoint(new Point());
    }

    protected void addAnchor(AnchorKey anchorKey, IAnchor anchor) {
        if (anchorKey == null) {
            throw new IllegalArgumentException("anchorKey may not be null.");
        }
        if (anchorKey.getAnchored() != this.getCurve()) {
            throw new IllegalArgumentException("anchorKey may only be anchored to curveProperty node");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey startAnchorKey = this.getStartAnchorKey();
        AnchorKey endAnchorKey = this.getEndAnchorKey();
        ArrayList<IAnchor> controlAnchorsToMove = new ArrayList<IAnchor>();
        if (!anchorKey.equals(startAnchorKey) && !anchorKey.equals(endAnchorKey)) {
            int controlAnchorIndex = this.getControlAnchorIndex(anchorKey);
            int pointCount = this.anchorsByKeys.size();
            int i = pointCount - 1;
            while (i >= 0) {
                AnchorKey ak = this.getAnchorKey(i);
                if (!ak.equals(startAnchorKey) && !ak.equals(endAnchorKey) && this.getControlAnchorIndex(ak) >= controlAnchorIndex) {
                    IAnchor a = this.getAnchor(i);
                    this.unregisterPCL(ak, a);
                    controlAnchorsToMove.add(0, a);
                    int anchorIndex = this.getAnchorIndex(ak);
                    this.points.remove(anchorIndex);
                    this.anchors.remove(anchorIndex);
                    this.anchorsByKeys.remove(ak);
                    a.detach(ak);
                }
                --i;
            }
        }
        this.anchorsByKeys.put(anchorKey, anchor);
        anchor.attach(anchorKey);
        this.anchors.add(this.getAnchorIndex(anchorKey), (Object)anchor);
        this.points.add(this.getAnchorIndex(anchorKey), (Object)FX2Geometry.toPoint((Point2D)this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)anchor.getPosition(anchorKey)))));
        if (!anchorKey.equals(startAnchorKey) && !anchorKey.equals(endAnchorKey)) {
            int controlIndex = this.getControlAnchorIndex(anchorKey);
            int i = 0;
            while (i < controlAnchorsToMove.size()) {
                AnchorKey ak = this.getControlAnchorKey(controlIndex + i + 1);
                IAnchor a = (IAnchor)controlAnchorsToMove.get(i);
                this.anchorsByKeys.put(ak, a);
                a.attach(ak);
                int anchorIndex = this.getAnchorIndex(ak);
                this.anchors.add(anchorIndex, (Object)a);
                this.points.add(anchorIndex, (Object)FX2Geometry.toPoint((Point2D)this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)a.getPosition(ak)))));
                this.registerPCL(ak, a);
                ++i;
            }
        }
        this.registerPCL(anchorKey, anchor);
        this.refresh();
    }

    public void addControlAnchor(int index, IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        this.addAnchor(this.getControlAnchorKey(index), anchor);
    }

    public void addControlPoint(int index, Point controlPoint) {
        if (controlPoint == null) {
            throw new IllegalArgumentException("controlPoint may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, controlPoint);
        this.addControlAnchor(index, anchor);
    }

    public ReadOnlyListProperty<IAnchor> anchorsUnmodifiableProperty() {
        if (this.anchorsUnmodifiableProperty == null) {
            this.anchorsUnmodifiableProperty = new AnchorsUnmodifiableProperty();
        }
        return this.anchorsUnmodifiableProperty;
    }

    protected MapChangeListener<? super AnchorKey, ? super Point> createPCL(final AnchorKey anchorKey) {
        return new MapChangeListener<AnchorKey, Point>(){

            public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
                if (((AnchorKey)change.getKey()).equals(anchorKey) && change.wasAdded() && change.wasRemoved()) {
                    Point newPoint = FX2Geometry.toPoint((Point2D)Connection.this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)((Point)change.getValueAdded()))));
                    if (!((Point)Connection.this.points.get(Connection.this.getAnchorIndex(anchorKey))).equals((Object)newPoint)) {
                        Connection.this.points.set(Connection.this.getAnchorIndex(anchorKey), (Object)newPoint);
                        Connection.this.refresh();
                    }
                }
            }
        };
    }

    public ObjectProperty<Node> curveProperty() {
        return this.curveProperty;
    }

    public ObjectProperty<Node> endDecorationProperty() {
        if (this.endDecorationProperty == null) {
            this.endDecorationProperty = new SimpleObjectProperty();
            this.endDecorationProperty.addListener(this.decorationListener);
        }
        return this.endDecorationProperty;
    }

    public IAnchor getAnchor(int index) {
        return this.anchorsByKeys.get(this.getAnchorKey(index));
    }

    protected int getAnchorIndex(AnchorKey anchorKey) {
        int index = 0;
        Iterator<AnchorKey> iterator = this.anchorsByKeys.keySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(anchorKey)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected AnchorKey getAnchorKey(int anchorIndex) {
        return (AnchorKey)Iterators.get(this.anchorsByKeys.keySet().iterator(), (int)anchorIndex);
    }

    public ObservableList<IAnchor> getAnchorsUnmodifiable() {
        return FXCollections.unmodifiableObservableList(this.anchors);
    }

    public Point getCenter() {
        BezierCurve[] bezierCurves = null;
        bezierCurves = this.getCurve() instanceof GeometryNode && ((GeometryNode)this.getCurve()).getGeometry() instanceof ICurve ? ((ICurve)((GeometryNode)this.getCurve()).getGeometry()).toBezier() : PolyBezier.interpolateCubic((Point[])((Point[])this.getPointsUnmodifiable().toArray((Object[])new Point[0]))).toBezier();
        if (bezierCurves.length % 2 == 0) {
            return this.getPoint((int)((double)this.getPointsUnmodifiable().size() - 0.5) / 2);
        }
        return bezierCurves[bezierCurves.length / 2].get(0.5);
    }

    public IAnchor getControlAnchor(int index) {
        return this.anchorsByKeys.get(this.getControlAnchorKey(index));
    }

    protected int getControlAnchorIndex(AnchorKey key) {
        if (!key.getId().startsWith(CONTROL_POINT_ROLE_PREFIX)) {
            throw new IllegalArgumentException("Given AnchorKey " + key + " is no control anchor key.");
        }
        int index = Integer.parseInt(key.getId().substring(CONTROL_POINT_ROLE_PREFIX.length()));
        return index;
    }

    protected AnchorKey getControlAnchorKey(int index) {
        return new AnchorKey(this.getCurve(), CONTROL_POINT_ROLE_PREFIX + index);
    }

    public List<IAnchor> getControlAnchors() {
        int controlAnchorsCount = this.anchorsByKeys.size();
        if (this.anchorsByKeys.containsKey(this.getStartAnchorKey())) {
            --controlAnchorsCount;
        }
        if (this.anchorsByKeys.containsKey(this.getEndAnchorKey())) {
            --controlAnchorsCount;
        }
        ArrayList<IAnchor> controlAnchors = new ArrayList<IAnchor>(controlAnchorsCount);
        int i = 0;
        while (i < controlAnchorsCount) {
            IAnchor controlAnchor = this.getControlAnchor(i);
            if (controlAnchor == null) {
                throw new IllegalStateException("control anchor may never be null.");
            }
            controlAnchors.add(controlAnchor);
            ++i;
        }
        return controlAnchors;
    }

    public Point getControlPoint(int index) {
        int anchorIndex = this.getAnchorIndex(this.getControlAnchorKey(index));
        return anchorIndex < 0 ? null : (Point)this.points.get(anchorIndex);
    }

    public List<Point> getControlPoints() {
        int controlPointCount = this.getControlAnchors().size();
        ArrayList<Point> controlPoints = new ArrayList<Point>(controlPointCount);
        int i = 0;
        while (i < controlPointCount) {
            controlPoints.add(this.getControlPoint(i));
            ++i;
        }
        return controlPoints;
    }

    public Node getCurve() {
        return (Node)this.curveProperty.get();
    }

    public IAnchor getEndAnchor() {
        return this.anchorsByKeys.get(this.getEndAnchorKey());
    }

    protected AnchorKey getEndAnchorKey() {
        return new AnchorKey(this.getCurve(), END_ROLE);
    }

    public Node getEndDecoration() {
        if (this.endDecorationProperty == null) {
            return null;
        }
        return (Node)this.endDecorationProperty.get();
    }

    public Point getEndPoint() {
        int anchorIndex = this.getAnchorIndex(this.getEndAnchorKey());
        return anchorIndex < 0 ? null : (Point)this.points.get(anchorIndex);
    }

    public Point getEndPointHint() {
        AnchorKey endAnchorKey = this.getEndAnchorKey();
        if (this.hintsByKeys.containsKey(endAnchorKey)) {
            return this.hintsByKeys.get(endAnchorKey);
        }
        return null;
    }

    public IConnectionInterpolator getInterpolator() {
        return (IConnectionInterpolator)this.interpolatorProperty.get();
    }

    public Point getPoint(int index) {
        return (Point)this.points.get(index);
    }

    public ObservableList<Point> getPointsUnmodifiable() {
        return FXCollections.unmodifiableObservableList(this.points);
    }

    public IConnectionRouter getRouter() {
        return (IConnectionRouter)this.routerProperty.get();
    }

    public IAnchor getStartAnchor() {
        return this.anchorsByKeys.get(this.getStartAnchorKey());
    }

    protected AnchorKey getStartAnchorKey() {
        return new AnchorKey(this.getCurve(), START_ROLE);
    }

    public Node getStartDecoration() {
        if (this.startDecorationProperty == null) {
            return null;
        }
        return (Node)this.startDecorationProperty.get();
    }

    public Point getStartPoint() {
        int anchorIndex = this.getAnchorIndex(this.getStartAnchorKey());
        return anchorIndex < 0 ? null : (Point)this.points.get(anchorIndex);
    }

    public Point getStartPointHint() {
        AnchorKey startAnchorKey = this.getStartAnchorKey();
        if (this.hintsByKeys.containsKey(startAnchorKey)) {
            return this.hintsByKeys.get(startAnchorKey);
        }
        return null;
    }

    public ObjectProperty<IConnectionInterpolator> interpolatorProperty() {
        return this.interpolatorProperty;
    }

    public boolean isConnected(IAnchor anchor) {
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    public boolean isConnected(int index) {
        if (index < 0 || index >= this.getAnchorsUnmodifiable().size()) {
            throw new IllegalArgumentException("The given index is out of bounds.");
        }
        return this.isConnected(this.getAnchor(index));
    }

    public boolean isControlConnected(int index) {
        return this.isConnected(this.getControlAnchor(index));
    }

    public boolean isEndConnected() {
        return this.isConnected(this.getEndAnchor());
    }

    public boolean isStartConnected() {
        return this.isConnected(this.getStartAnchor());
    }

    public ReadOnlyListProperty<Point> pointsUnmodifiableProperty() {
        if (this.pointsUnmodifiableProperty == null) {
            this.pointsUnmodifiableProperty = new PointsUnmodifiableProperty();
        }
        return this.pointsUnmodifiableProperty;
    }

    protected void reattachAnchorKeys(Node oldAnchored, Node newAnchored) {
        if (oldAnchored == null) {
            if (!this.anchorsByKeys.isEmpty()) {
                throw new IllegalStateException("Re-attach failed: no previous curve, but anchor keys present.");
            }
            if (!this.hintsByKeys.isEmpty()) {
                throw new IllegalStateException("Re-attach failed: no previous curve, but anchor keys present.");
            }
            return;
        }
        if (newAnchored == null) {
            if (!this.anchorsByKeys.isEmpty()) {
                throw new IllegalStateException("Re-attach failed: no new curve, but anchor keys present.");
            }
            if (!this.hintsByKeys.isEmpty()) {
                throw new IllegalStateException("Re-attach failed: no new curve, but anchor keys present.");
            }
            return;
        }
        for (AnchorKey oldAk : new ArrayList<AnchorKey>(this.anchorsByKeys.keySet())) {
            IAnchor anchor = this.anchorsByKeys.get(oldAk);
            this.unregisterPCL(oldAk, anchor);
            this.anchorsByKeys.remove(oldAk);
            anchor.detach(oldAk);
            AnchorKey newAk = new AnchorKey(newAnchored, oldAk.getId());
            if (this.hintsByKeys.containsKey(oldAk)) {
                this.hintsByKeys.put(newAk, this.hintsByKeys.remove(oldAk));
            }
            this.anchorsByKeys.put(newAk, anchor);
            anchor.attach(newAk);
            this.registerPCL(newAk, anchor);
        }
    }

    protected void refresh() {
        IConnectionRouter router;
        Node endDecoration;
        if (this.inRefresh) {
            return;
        }
        this.inRefresh = true;
        for (AnchorKey ak : this.anchorsByKeys.keySet()) {
            this.unregisterPCL(ak, this.anchorsByKeys.get(ak));
        }
        this.getChildren().retainAll((Object[])new Node[]{this.getCurve()});
        Node startDecoration = this.getStartDecoration();
        if (startDecoration != null) {
            this.getChildren().add((Object)startDecoration);
        }
        if ((endDecoration = this.getEndDecoration()) != null) {
            this.getChildren().add((Object)endDecoration);
        }
        if ((router = this.getRouter()) == null) {
            throw new IllegalStateException("An IConnectionRouter is mandatory for a Connection.");
        }
        this.refreshPoints();
        router.route(this);
        this.refreshPoints();
        IConnectionInterpolator interpolator = this.getInterpolator();
        if (interpolator == null) {
            throw new IllegalStateException("An IConnectionInterpolator is mandatory for a Connection.");
        }
        interpolator.interpolate(this);
        this.refreshPoints();
        if (this.anchorsUnmodifiableProperty != null) {
            this.anchorsUnmodifiableProperty.fireValueChangedEvent();
        }
        if (this.pointsUnmodifiableProperty != null) {
            this.pointsUnmodifiableProperty.fireValueChangedEvent();
        }
        for (AnchorKey ak : this.anchorsByKeys.keySet()) {
            this.registerPCL(ak, this.anchorsByKeys.get(ak));
        }
        this.inRefresh = false;
    }

    private boolean refreshPoints() {
        boolean changed = false;
        int i = 0;
        while (i < this.points.size()) {
            Point position = this.getAnchor(i).getPosition(this.getAnchorKey(i));
            Point newPoint = FX2Geometry.toPoint((Point2D)this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)position)));
            if (!((Point)this.points.get(i)).equals((Object)newPoint)) {
                this.points.set(i, (Object)newPoint);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    private void registerPCL(AnchorKey anchorKey, IAnchor anchor) {
        if (!this.anchorsPCL.containsKey(anchorKey)) {
            MapChangeListener<? super AnchorKey, ? super Point> pcl = this.createPCL(anchorKey);
            this.anchorsPCL.put(anchorKey, pcl);
            anchor.positionsUnmodifiableProperty().addListener(pcl);
        }
    }

    public void removeAllControlAnchors() {
        this.removeAllControlPoints();
    }

    public void removeAllControlPoints() {
        int controlPointsCount = this.anchorsByKeys.size();
        if (this.anchorsByKeys.containsKey(this.getStartAnchorKey())) {
            --controlPointsCount;
        }
        if (this.anchorsByKeys.containsKey(this.getEndAnchorKey())) {
            --controlPointsCount;
        }
        int i = controlPointsCount - 1;
        while (i >= 0) {
            this.removeControlPoint(i);
            --i;
        }
    }

    protected void removeAnchor(AnchorKey anchorKey, IAnchor anchor) {
        if (anchorKey == null) {
            throw new IllegalArgumentException("anchorKey may not be null.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey startAnchorKey = this.getStartAnchorKey();
        AnchorKey endAnchorKey = this.getEndAnchorKey();
        this.unregisterPCL(anchorKey, anchor);
        ArrayList<IAnchor> controlAnchorsToMove = new ArrayList<IAnchor>();
        if (!anchorKey.equals(startAnchorKey) && !anchorKey.equals(endAnchorKey)) {
            int controlAnchorIndex = this.getControlAnchorIndex(anchorKey);
            int pointCount = this.anchorsByKeys.size();
            int i = pointCount - 1;
            while (i >= 0) {
                AnchorKey ak = this.getAnchorKey(i);
                if (!ak.equals(startAnchorKey) && !ak.equals(endAnchorKey) && this.getControlAnchorIndex(ak) > controlAnchorIndex) {
                    IAnchor a = this.getAnchor(i);
                    this.unregisterPCL(ak, a);
                    controlAnchorsToMove.add(0, a);
                    int anchorIndex = this.getAnchorIndex(ak);
                    this.points.remove(anchorIndex);
                    this.anchors.remove(anchorIndex);
                    this.anchorsByKeys.remove(ak);
                    a.detach(ak);
                }
                --i;
            }
        }
        this.points.remove(this.getAnchorIndex(anchorKey));
        this.anchors.remove(this.getAnchorIndex(anchorKey));
        this.anchorsByKeys.remove(anchorKey);
        anchor.detach(anchorKey);
        if (!anchorKey.equals(startAnchorKey) && !anchorKey.equals(endAnchorKey)) {
            int controlIndex = this.getControlAnchorIndex(anchorKey);
            int i = 0;
            while (i < controlAnchorsToMove.size()) {
                AnchorKey ak = this.getControlAnchorKey(controlIndex + i);
                IAnchor a = (IAnchor)controlAnchorsToMove.get(i);
                this.anchorsByKeys.put(ak, a);
                a.attach(ak);
                int anchorIndex = this.getAnchorIndex(ak);
                this.anchors.add(anchorIndex, (Object)a);
                this.points.add(anchorIndex, (Object)FX2Geometry.toPoint((Point2D)this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)a.getPosition(ak)))));
                this.registerPCL(ak, a);
                ++i;
            }
        }
        this.refresh();
    }

    public void removeControlAnchor(int index) {
        this.removeControlPoint(index);
    }

    public void removeControlPoint(int index) {
        if (index < 0 || index >= this.getControlPoints().size()) {
            throw new IllegalArgumentException("Index out of range (index: " + index + ", size: " + this.getControlPoints().size() + ").");
        }
        AnchorKey anchorKey = this.getControlAnchorKey(index);
        if (!this.anchorsByKeys.containsKey(anchorKey)) {
            throw new IllegalStateException("Inconsistent state: control anchor key for index " + index + " not registered.");
        }
        IAnchor oldAnchor = this.anchorsByKeys.get(anchorKey);
        if (oldAnchor == null) {
            throw new IllegalStateException("Inconsistent state: control anchor for index " + index + " is null.");
        }
        this.removeAnchor(anchorKey, oldAnchor);
    }

    public ObjectProperty<IConnectionRouter> routerProperty() {
        return this.routerProperty;
    }

    protected void setAnchor(AnchorKey anchorKey, IAnchor anchor) {
        if (anchorKey == null) {
            throw new IllegalArgumentException("anchorKey may not be null.");
        }
        if (anchorKey.getAnchored() != this.getCurve()) {
            throw new IllegalArgumentException("anchorKey may only be anchored to curveProperty node");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        IAnchor oldAnchor = this.anchorsByKeys.put(anchorKey, anchor);
        this.unregisterPCL(anchorKey, oldAnchor);
        oldAnchor.detach(anchorKey);
        anchor.attach(anchorKey);
        int anchorIndex = this.getAnchorIndex(anchorKey);
        this.anchors.set(anchorIndex, (Object)anchor);
        Point newPosition = FX2Geometry.toPoint((Point2D)this.getCurve().localToParent(Geometry2FX.toFXPoint((Point)anchor.getPosition(anchorKey))));
        if (!newPosition.equals(this.points.get(anchorIndex))) {
            this.points.set(anchorIndex, (Object)newPosition);
        }
        this.registerPCL(anchorKey, anchor);
        this.refresh();
    }

    public void setAnchors(List<IAnchor> anchors) {
        if (anchors.size() < 2) {
            throw new IllegalArgumentException("start end end anchorsByKeys have to be provided.");
        }
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        this.setStartAnchor(anchors.get(0));
        if (anchors.size() > 2) {
            this.setControlAnchors(anchors.subList(1, anchors.size() - 1));
        } else {
            this.removeAllControlPoints();
        }
        this.setEndAnchor(anchors.get(anchors.size() - 1));
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setControlAnchor(int index, IAnchor anchor) {
        if (index < 0 || index >= this.getControlAnchors().size()) {
            throw new IllegalArgumentException("index out of range.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getControlAnchorKey(index);
        IAnchor oldAnchor = this.anchorsByKeys.get(anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.setAnchor(anchorKey, anchor);
            } else {
                this.addAnchor(anchorKey, anchor);
            }
        }
    }

    public void setControlAnchors(List<IAnchor> anchors) {
        int controlSize = this.getControlAnchors().size();
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        int i = 0;
        while (i < controlSize && i < anchors.size()) {
            this.setControlAnchor(i, anchors.get(i));
            ++i;
        }
        while (i < anchors.size()) {
            this.addControlAnchor(i, anchors.get(i));
            ++i;
        }
        int initialRemovalIndex = i;
        while (i < controlSize) {
            this.removeControlAnchor(controlSize - 1 - (i - initialRemovalIndex));
            ++i;
        }
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setControlPoint(int index, Point controlPoint) {
        if (controlPoint == null) {
            throw new IllegalArgumentException("control point may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, controlPoint);
        this.setControlAnchor(index, anchor);
    }

    public void setControlPoints(List<Point> controlPoints) {
        int controlSize = this.getControlAnchors().size();
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        int i = 0;
        while (i < controlSize && i < controlPoints.size()) {
            this.setControlPoint(i, controlPoints.get(i));
            ++i;
        }
        while (i < controlPoints.size()) {
            this.addControlPoint(i, controlPoints.get(i));
            ++i;
        }
        int initialRemovalIndex = i;
        while (i < controlSize) {
            this.removeControlPoint(controlSize - 1 - (i - initialRemovalIndex));
            ++i;
        }
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setCurve(Node curve) {
        this.curveProperty.set((Object)curve);
    }

    public void setEndAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getEndAnchorKey();
        IAnchor oldAnchor = this.anchorsByKeys.get(anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.setAnchor(anchorKey, anchor);
            } else {
                this.addAnchor(anchorKey, anchor);
            }
        }
    }

    public void setEndDecoration(Node decoration) {
        this.endDecorationProperty().set((Object)decoration);
    }

    public void setEndPoint(Point endPoint) {
        if (endPoint == null) {
            throw new IllegalArgumentException("endPoint may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, endPoint);
        this.setEndAnchor(anchor);
    }

    public void setEndPointHint(Point endPositionHint) {
        AnchorKey endAnchorKey = this.getEndAnchorKey();
        if (endPositionHint == null) {
            if (this.hintsByKeys.containsKey(endAnchorKey)) {
                this.hintsByKeys.remove(endAnchorKey);
            }
        } else {
            this.hintsByKeys.put(endAnchorKey, endPositionHint);
        }
        this.refresh();
    }

    public void setInterpolator(IConnectionInterpolator interpolator) {
        this.interpolatorProperty.set((Object)interpolator);
    }

    public void setPoints(List<Point> points) {
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points have to be provided.");
        }
        boolean oldInRefresh = this.inRefresh;
        this.inRefresh = true;
        this.setStartPoint(points.get(0));
        if (points.size() > 2) {
            this.setControlPoints(points.subList(1, points.size() - 1));
        } else {
            this.removeAllControlPoints();
        }
        this.setEndPoint(points.get(points.size() - 1));
        this.inRefresh = oldInRefresh;
        this.refresh();
    }

    public void setRouter(IConnectionRouter router) {
        this.routerProperty.set((Object)router);
    }

    public void setStartAnchor(IAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getStartAnchorKey();
        IAnchor oldAnchor = this.anchorsByKeys.get(anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.setAnchor(anchorKey, anchor);
            } else {
                this.addAnchor(anchorKey, anchor);
            }
        }
    }

    public void setStartDecoration(Node decoration) {
        this.startDecorationProperty().set((Object)decoration);
    }

    public void setStartPoint(Point startPoint) {
        if (startPoint == null) {
            throw new IllegalArgumentException("startPoint may not be null.");
        }
        StaticAnchor anchor = new StaticAnchor((Node)this, startPoint);
        this.setStartAnchor(anchor);
    }

    public void setStartPointHint(Point startPositionHint) {
        AnchorKey startAnchorKey = this.getStartAnchorKey();
        if (startPositionHint == null) {
            if (this.hintsByKeys.containsKey(startAnchorKey)) {
                this.hintsByKeys.remove(startAnchorKey);
            }
        } else {
            this.hintsByKeys.put(startAnchorKey, startPositionHint);
        }
        this.refresh();
    }

    public ObjectProperty<Node> startDecorationProperty() {
        if (this.startDecorationProperty == null) {
            this.startDecorationProperty = new SimpleObjectProperty();
            this.startDecorationProperty.addListener(this.decorationListener);
        }
        return this.startDecorationProperty;
    }

    private void unregisterPCL(AnchorKey anchorKey, IAnchor anchor) {
        if (this.anchorsPCL.containsKey(anchorKey)) {
            anchor.positionsUnmodifiableProperty().removeListener(this.anchorsPCL.remove(anchorKey));
        }
    }

    private final class AnchorsUnmodifiableProperty
    extends LazyReadOnlyListPropertyBase<IAnchor> {
        private AnchorsUnmodifiableProperty() {
        }

        @Override
        public void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }

        public ObservableList<IAnchor> get() {
            return Connection.this.getAnchorsUnmodifiable();
        }
    }

    private abstract class LazyReadOnlyListPropertyBase<E>
    extends ReadOnlyListPropertyBaseEx<E> {
        private ReadOnlyBooleanProperty emptyProperty;
        private ReadOnlyIntegerProperty sizeProperty;
        private ObservableList<E> lazyValue = CollectionUtils.observableArrayList();

        public LazyReadOnlyListPropertyBase() {
            this.lazyValue.addListener(new ListChangeListener<E>(){

                public void onChanged(ListChangeListener.Change<? extends E> c) {
                    LazyReadOnlyListPropertyBase.this.fireValueChangedEvent((ListChangeListener.Change)new ListListenerHelperEx.AtomicChange((ObservableList)LazyReadOnlyListPropertyBase.this.get(), c));
                }
            });
        }

        public ReadOnlyBooleanProperty emptyProperty() {
            if (this.emptyProperty == null) {
                this.emptyProperty = new EmptyProperty();
            }
            return this.emptyProperty;
        }

        public void fireValueChangedEvent() {
            this.lazyValue.setAll((Collection)this.get());
        }

        public Object getBean() {
            return Connection.this;
        }

        public String getName() {
            return "points";
        }

        public ReadOnlyIntegerProperty sizeProperty() {
            if (this.sizeProperty == null) {
                this.sizeProperty = new SizeProperty();
            }
            return this.sizeProperty;
        }

        private class EmptyProperty
        extends ReadOnlyBooleanPropertyBase {
            private EmptyProperty() {
            }

            protected void fireValueChangedEvent() {
                super.fireValueChangedEvent();
            }

            public boolean get() {
                return LazyReadOnlyListPropertyBase.this.isEmpty();
            }

            public Object getBean() {
                return LazyReadOnlyListPropertyBase.this;
            }

            public String getName() {
                return "empty";
            }
        }

        private class SizeProperty
        extends ReadOnlyIntegerPropertyBase {
            private SizeProperty() {
            }

            protected void fireValueChangedEvent() {
                super.fireValueChangedEvent();
            }

            public int get() {
                return LazyReadOnlyListPropertyBase.this.size();
            }

            public Object getBean() {
                return LazyReadOnlyListPropertyBase.this;
            }

            public String getName() {
                return "size";
            }
        }
    }

    private final class PointsUnmodifiableProperty
    extends LazyReadOnlyListPropertyBase<Point> {
        private PointsUnmodifiableProperty() {
        }

        public ObservableList<Point> get() {
            return Connection.this.getPointsUnmodifiable();
        }

        @Override
        public String getName() {
            return "points";
        }
    }
}

