/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.nodes;

import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.fx.utils.Geometry2Shape;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.geometry.planar.Arc;
import org.eclipse.gef.geometry.planar.Ellipse;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IScalable;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.geometry.planar.ITranslatable;
import org.eclipse.gef.geometry.planar.Pie;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.geometry.planar.RoundedRectangle;

public class GeometryNode<T extends IGeometry>
extends Region {
    private static final double GEOMETRIC_SHAPE_MIN_WIDTH = 0.01;
    private static final double GEOMETRIC_SHAPE_MIN_HEIGHT = 0.01;
    private Path geometricShape = new Path();
    private Path clickableAreaShape = null;
    private DoubleProperty clickableAreaWidth = new SimpleDoubleProperty();
    private ObjectProperty<T> geometryProperty = new SimpleObjectProperty();
    private ChangeListener<T> geometryChangeListener = new ChangeListener<T>(){

        public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
            if (newValue != null) {
                GeometryNode.this.widthProperty().removeListener(GeometryNode.this.widthListener);
                GeometryNode.this.heightProperty().removeListener(GeometryNode.this.heightListener);
                GeometryNode.this.layoutXProperty().removeListener(GeometryNode.this.layoutXListener);
                GeometryNode.this.layoutYProperty().removeListener(GeometryNode.this.layoutYListener);
                GeometryNode.this.requestLayout();
                double computedWidth = GeometryNode.this.computePrefWidth(newValue);
                double computedHeight = GeometryNode.this.computePrefHeight(newValue);
                if (computedWidth != GeometryNode.this.getWidth() || computedHeight != GeometryNode.this.getHeight()) {
                    GeometryNode.super.resize(computedWidth, computedHeight);
                }
                double computedLayoutX = newValue.getBounds().getX() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getLeft();
                double computedLayoutY = newValue.getBounds().getY() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getTop();
                if (GeometryNode.this.getLayoutX() != computedLayoutX || GeometryNode.this.getLayoutY() != computedLayoutY) {
                    GeometryNode.super.relocate(computedLayoutX, computedLayoutY);
                }
                GeometryNode.this.widthProperty().addListener(GeometryNode.this.widthListener);
                GeometryNode.this.heightProperty().addListener(GeometryNode.this.heightListener);
                GeometryNode.this.layoutXProperty().addListener(GeometryNode.this.layoutXListener);
                GeometryNode.this.layoutYProperty().addListener(GeometryNode.this.layoutYListener);
                GeometryNode.this.updateShapes();
            }
        }
    };
    private ChangeListener<Number> widthListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            GeometryNode.this.geometryProperty.removeListener(GeometryNode.this.geometryChangeListener);
            GeometryNode.this.resizeGeometryToMatchLayoutBoundsSize(newValue.doubleValue(), GeometryNode.this.getHeight());
            GeometryNode.this.geometryProperty.addListener(GeometryNode.this.geometryChangeListener);
        }
    };
    private ChangeListener<Number> heightListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            GeometryNode.this.geometryProperty.removeListener(GeometryNode.this.geometryChangeListener);
            GeometryNode.this.resizeGeometryToMatchLayoutBoundsSize(GeometryNode.this.getWidth(), newValue.doubleValue());
            GeometryNode.this.geometryProperty.addListener(GeometryNode.this.geometryChangeListener);
        }
    };
    private ChangeListener<Number> layoutXListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            GeometryNode.this.geometryProperty.removeListener(GeometryNode.this.geometryChangeListener);
            GeometryNode.this.relocateGeometryToMatchLayoutXY(newValue.doubleValue(), GeometryNode.this.getLayoutY());
            GeometryNode.this.geometryProperty.addListener(GeometryNode.this.geometryChangeListener);
        }
    };
    private ChangeListener<Number> layoutYListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            GeometryNode.this.geometryProperty.removeListener(GeometryNode.this.geometryChangeListener);
            GeometryNode.this.relocateGeometryToMatchLayoutXY(GeometryNode.this.getLayoutX(), newValue.doubleValue());
            GeometryNode.this.geometryProperty.addListener(GeometryNode.this.geometryChangeListener);
        }
    };

    public GeometryNode() {
        this.setPickOnBounds(false);
        this.setGeometricShape(this.geometricShape);
        this.geometryProperty.addListener(this.geometryChangeListener);
        this.strokeWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                IGeometry geometry = (IGeometry)GeometryNode.this.geometryProperty.get();
                if (geometry == null) {
                    return;
                }
                GeometryNode.this.resize(GeometryNode.this.prefWidth(-1.0), GeometryNode.this.prefHeight(-1.0));
                Rectangle geometricBounds = geometry.getBounds();
                GeometryNode.this.relocate(geometricBounds.getX() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getLeft(), geometricBounds.getY() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getTop());
            }
        });
        this.strokeTypeProperty().addListener((ChangeListener)new ChangeListener<StrokeType>(){

            public void changed(ObservableValue<? extends StrokeType> observable, StrokeType oldValue, StrokeType newValue) {
                IGeometry geometry = (IGeometry)GeometryNode.this.geometryProperty.get();
                if (geometry == null) {
                    return;
                }
                GeometryNode.this.resize(GeometryNode.this.prefWidth(-1.0), GeometryNode.this.prefHeight(-1.0));
                Rectangle geometricBounds = geometry.getBounds();
                GeometryNode.this.relocate(geometricBounds.getX() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getLeft(), geometricBounds.getY() - GeometryNode.this.getStrokeOffset() - GeometryNode.this.getInsets().getTop());
            }
        });
        this.insetsProperty().addListener((ChangeListener)new ChangeListener<Insets>(){

            public void changed(ObservableValue<? extends Insets> observable, Insets oldValue, Insets newValue) {
                GeometryNode.this.resize(GeometryNode.this.prefWidth(-1.0), GeometryNode.this.prefHeight(-1.0));
            }
        });
        this.widthProperty().addListener(this.widthListener);
        this.heightProperty().addListener(this.heightListener);
        this.layoutXProperty().addListener(this.layoutXListener);
        this.layoutYProperty().addListener(this.layoutYListener);
    }

    public GeometryNode(T geom) {
        this();
        this.setGeometry(geom);
    }

    public DoubleProperty clickableAreaWidthProperty() {
        return this.clickableAreaWidth;
    }

    private double computeGeometryMinHeight(T geometry) {
        return geometry instanceof IShape ? 0.01 : 0.0;
    }

    private double computeGeometryMinWidth(T geometry) {
        return geometry instanceof IShape ? 0.01 : 0.0;
    }

    protected double computeMinHeight(double width) {
        return this.computeMinHeight((IGeometry)this.geometryProperty.get());
    }

    private double computeMinHeight(T geometry) {
        return this.computeGeometryMinHeight(geometry) + 2.0 * this.getStrokeOffset() + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    protected double computeMinWidth(double height) {
        return this.computeMinWidth((IGeometry)this.geometryProperty.get());
    }

    private double computeMinWidth(T geometry) {
        return this.computeGeometryMinWidth(geometry) + 2.0 * this.getStrokeOffset() + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    protected double computePrefHeight(double width) {
        return this.computePrefHeight((IGeometry)this.geometryProperty.get());
    }

    private double computePrefHeight(T geometry) {
        double geometricPrefHeight = Math.max(geometry != null ? geometry.getBounds().getHeight() : 0.0, this.computeGeometryMinHeight(geometry));
        return geometricPrefHeight + 2.0 * this.getStrokeOffset() + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    protected double computePrefWidth(double height) {
        return this.computePrefWidth((IGeometry)this.geometryProperty.get());
    }

    private double computePrefWidth(T geometry) {
        double geometricPrefWidth = Math.max(geometry != null ? geometry.getBounds().getWidth() : 0.0, this.computeGeometryMinWidth(geometry));
        return geometricPrefWidth + 2.0 * this.getStrokeOffset() + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    public final ObjectProperty<Paint> fillProperty() {
        return this.geometricShape.fillProperty();
    }

    public final ObjectProperty<FillRule> fillRuleProperty() {
        return this.geometricShape.fillRuleProperty();
    }

    public ObjectProperty<T> geometryProperty() {
        return this.geometryProperty;
    }

    public double getClickableAreaWidth() {
        return this.clickableAreaWidth.get();
    }

    public final Paint getFill() {
        return this.geometricShape.getFill();
    }

    public final FillRule getFillRule() {
        return this.geometricShape.getFillRule();
    }

    protected Path getGeometricShape() {
        return this.geometricShape;
    }

    public T getGeometry() {
        return (T)((IGeometry)this.geometryProperty.get());
    }

    private PathElement[] getPathElements() {
        return Geometry2Shape.toPathElements(((IGeometry)this.geometryProperty.get()).getTransformed(new AffineTransform().setToTranslation(-this.getLayoutX(), -this.getLayoutY())).toPath());
    }

    public final Paint getStroke() {
        return this.geometricShape.getStroke();
    }

    public final ObservableList<Double> getStrokeDashArray() {
        return this.geometricShape.getStrokeDashArray();
    }

    public final double getStrokeDashOffset() {
        return this.geometricShape.getStrokeDashOffset();
    }

    public final StrokeLineCap getStrokeLineCap() {
        return this.geometricShape.getStrokeLineCap();
    }

    public final StrokeLineJoin getStrokeLineJoin() {
        return this.geometricShape.getStrokeLineJoin();
    }

    public final double getStrokeMiterLimit() {
        return this.geometricShape.getStrokeMiterLimit();
    }

    private double getStrokeOffset() {
        double offset = 0.0;
        if (this.geometricShape.getStroke() != null && this.geometricShape.getStrokeType() != StrokeType.INSIDE) {
            offset = (this.geometricShape.getStrokeType() == StrokeType.CENTERED ? 0.5 : 1.0) * this.geometricShape.getStrokeWidth();
        }
        return offset;
    }

    public final StrokeType getStrokeType() {
        return this.geometricShape.getStrokeType();
    }

    public final double getStrokeWidth() {
        return this.geometricShape.getStrokeWidth();
    }

    public boolean isResizable() {
        return true;
    }

    public final boolean isSmooth() {
        return this.geometricShape.isSmooth();
    }

    public void relocate(double x, double y) {
        this.layoutXProperty().removeListener(this.layoutXListener);
        this.layoutYProperty().removeListener(this.layoutYListener);
        super.relocate(x, y);
        this.layoutXProperty().addListener(this.layoutXListener);
        this.layoutYProperty().addListener(this.layoutYListener);
        this.relocateGeometryToMatchLayoutXY(x, y);
    }

    public void relocateGeometry(double x, double y) {
        IGeometry geometry = (IGeometry)this.geometryProperty.getValue();
        Rectangle geometryBounds = geometry.getBounds();
        if (geometry instanceof ITranslatable) {
            this.geometryProperty.set((Object)((ITranslatable)geometry).getTranslated(x - geometryBounds.getX(), y - geometryBounds.getY()));
        } else {
            this.geometryProperty.set((Object)geometry.getTransformed(new AffineTransform().translate(x - geometryBounds.getX(), y - geometryBounds.getY())));
        }
    }

    private void relocateGeometryToMatchLayoutXY(double layoutX, double layoutY) {
        IGeometry geometry = (IGeometry)this.geometryProperty.get();
        if (geometry == null) {
            return;
        }
        this.geometryProperty.removeListener(this.geometryChangeListener);
        this.relocateGeometry(layoutX + this.getStrokeOffset() + this.getInsets().getLeft(), layoutY + this.getStrokeOffset() + this.getInsets().getTop());
        this.geometryProperty.addListener(this.geometryChangeListener);
        this.updateShapes();
    }

    public void resize(double width, double height) {
        if (width < this.minWidth(-1.0)) {
            throw new IllegalArgumentException("Cannot resize below mininmal width " + this.minWidth(-1.0) + ", so " + width + " is no valid width");
        }
        if (height < this.minHeight(-1.0)) {
            throw new IllegalArgumentException("Cannot resize below mininmal height " + this.minHeight(-1.0) + ", so " + height + " is no valid height");
        }
        this.widthProperty().removeListener(this.widthListener);
        this.heightProperty().removeListener(this.heightListener);
        super.resize(width, height);
        this.widthProperty().addListener(this.widthListener);
        this.heightProperty().addListener(this.heightListener);
        this.resizeGeometryToMatchLayoutBoundsSize(width, height);
    }

    public void resizeGeometry(double width, double height) {
        IGeometry geometry = (IGeometry)this.geometryProperty.getValue();
        double geometryMinWidth = this.computeGeometryMinWidth(geometry);
        if (width < geometryMinWidth) {
            throw new IllegalArgumentException("Cannot resize geometry below " + geometryMinWidth + ", so " + width + " is no valid width.");
        }
        double geometryMinHeight = this.computeGeometryMinHeight(geometry);
        if (height < geometryMinHeight) {
            throw new IllegalArgumentException("Cannot resize geometry below " + geometryMinHeight + ", so " + height + " is no valid height.");
        }
        if (geometry instanceof Rectangle) {
            this.geometryProperty.set((Object)((Rectangle)geometry).getCopy().setSize(width, height));
        } else if (geometry instanceof RoundedRectangle) {
            this.geometryProperty.set((Object)((RoundedRectangle)geometry).getCopy().setSize(width, height));
        } else if (geometry instanceof Ellipse) {
            this.geometryProperty.set((Object)((Ellipse)geometry).getCopy().setSize(width, height));
        } else if (geometry instanceof Pie) {
            this.geometryProperty.set((Object)((Pie)geometry).getCopy().setSize(width, height));
        } else if (geometry instanceof Arc) {
            this.geometryProperty.set((Object)((Arc)geometry).getCopy().setSize(width, height));
        } else {
            double sy;
            Rectangle geometricBounds = geometry.getBounds();
            double sx = geometricBounds.getWidth() == 0.0 ? 1.0 : width / geometricBounds.getWidth();
            double d = sy = geometricBounds.getHeight() == 0.0 ? 1.0 : height / geometricBounds.getHeight();
            if (geometry instanceof IScalable) {
                this.geometryProperty.set((Object)((IScalable)geometry).getScaled(sx, sy, geometricBounds.getX(), geometricBounds.getY()));
            } else {
                Point boundsOrigin = new Point(geometricBounds.getX(), geometricBounds.getY());
                this.geometryProperty.setValue((Object)geometry.getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, -boundsOrigin.x, -boundsOrigin.y)).getTransformed(new AffineTransform(sx, 0.0, 0.0, sy, 0.0, 0.0)).getTransformed(new AffineTransform(1.0, 0.0, 0.0, 1.0, boundsOrigin.x, boundsOrigin.y)));
            }
        }
    }

    private void resizeGeometryToMatchLayoutBoundsSize(double layoutBoundsWidth, double layoutBoundsHeight) {
        double geometryMinHeight;
        double geometryHeight;
        IGeometry geometry = (IGeometry)this.geometryProperty.get();
        if (geometry == null) {
            return;
        }
        this.geometryProperty.removeListener(this.geometryChangeListener);
        double strokeOffset = this.getStrokeOffset();
        double geometryWidth = layoutBoundsWidth - this.getInsets().getLeft() - this.getInsets().getRight() - 2.0 * strokeOffset;
        double geometryMinWidth = this.computeGeometryMinWidth(geometry);
        if (geometryWidth < geometryMinWidth) {
            geometryWidth = geometryMinWidth;
        }
        if ((geometryHeight = layoutBoundsHeight - this.getInsets().getTop() - this.getInsets().getBottom() - 2.0 * strokeOffset) < (geometryMinHeight = this.computeGeometryMinHeight(geometry))) {
            geometryHeight = geometryMinHeight;
        }
        this.resizeGeometry(geometryWidth, geometryHeight);
        this.geometryProperty.addListener(this.geometryChangeListener);
        this.updateShapes();
    }

    public void setClickableAreaWidth(double clickableAreaWidth) {
        this.clickableAreaWidth.set(clickableAreaWidth);
    }

    public final void setFill(Paint value) {
        this.geometricShape.setFill(value);
    }

    public final void setFillRule(FillRule value) {
        this.geometricShape.setFillRule(value);
    }

    protected void setGeometricShape(final Path geometricShape) {
        this.getChildren().add((Object)geometricShape);
        this.getStyleClass().addListener((ListChangeListener)new ListChangeListener<String>(){

            public void onChanged(ListChangeListener.Change<? extends String> c) {
                while (c.next()) {
                    if (c.wasPermutated() || c.wasUpdated()) {
                        geometricShape.getStyleClass().clear();
                        geometricShape.getStyleClass().addAll((Collection)GeometryNode.this.getStyleClass());
                        continue;
                    }
                    geometricShape.getStyleClass().removeAll((Collection)c.getRemoved());
                    geometricShape.getStyleClass().addAll((Collection)c.getAddedSubList());
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                geometricShape.setStyle(newValue);
            }
        });
        this.clickableAreaWidth.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null && newValue.doubleValue() > geometricShape.getStrokeWidth() && GeometryNode.this.clickableAreaShape == null && GeometryNode.this.geometryProperty.getValue() != null) {
                    GeometryNode.this.clickableAreaShape = new Path(GeometryNode.this.getPathElements());
                    GeometryNode.this.clickableAreaShape.setId("clickable area of GeometryNode " + this);
                    GeometryNode.this.clickableAreaShape.setStroke((Paint)Color.TRANSPARENT);
                    GeometryNode.this.clickableAreaShape.setMouseTransparent(false);
                    GeometryNode.this.clickableAreaShape.strokeWidthProperty().bind((ObservableValue)GeometryNode.this.clickableAreaWidthProperty());
                    GeometryNode.this.getChildren().add((Object)GeometryNode.this.clickableAreaShape);
                } else if ((newValue == null || newValue.doubleValue() <= geometricShape.getStrokeWidth()) && GeometryNode.this.clickableAreaShape != null) {
                    GeometryNode.this.getChildren().remove((Object)GeometryNode.this.clickableAreaShape);
                    GeometryNode.this.clickableAreaShape.strokeWidthProperty().unbind();
                    GeometryNode.this.clickableAreaShape = null;
                }
            }
        });
    }

    public void setGeometry(T geometry) {
        this.geometryProperty.setValue(geometry);
    }

    public final void setSmooth(boolean value) {
        this.geometricShape.setSmooth(value);
    }

    public final void setStroke(Paint value) {
        this.geometricShape.setStroke(value);
    }

    public final void setStrokeDashOffset(double value) {
        this.geometricShape.setStrokeDashOffset(value);
    }

    public final void setStrokeLineCap(StrokeLineCap value) {
        this.geometricShape.setStrokeLineCap(value);
    }

    public final void setStrokeLineJoin(StrokeLineJoin value) {
        this.geometricShape.setStrokeLineJoin(value);
    }

    public final void setStrokeMiterLimit(double value) {
        this.geometricShape.setStrokeMiterLimit(value);
    }

    public final void setStrokeType(StrokeType value) {
        this.geometricShape.setStrokeType(value);
    }

    public final void setStrokeWidth(double value) {
        this.geometricShape.setStrokeWidth(value);
    }

    public final BooleanProperty smoothProperty() {
        return this.geometricShape.smoothProperty();
    }

    public final DoubleProperty strokeDashOffsetProperty() {
        return this.geometricShape.strokeDashOffsetProperty();
    }

    public final ObjectProperty<StrokeLineCap> strokeLineCapProperty() {
        return this.geometricShape.strokeLineCapProperty();
    }

    public final ObjectProperty<StrokeLineJoin> strokeLineJoinProperty() {
        return this.geometricShape.strokeLineJoinProperty();
    }

    public final DoubleProperty strokeMiterLimitProperty() {
        return this.geometricShape.strokeMiterLimitProperty();
    }

    public final ObjectProperty<Paint> strokeProperty() {
        return this.geometricShape.strokeProperty();
    }

    public final ObjectProperty<StrokeType> strokeTypeProperty() {
        return this.geometricShape.strokeTypeProperty();
    }

    public final DoubleProperty strokeWidthProperty() {
        return this.geometricShape.strokeWidthProperty();
    }

    private void updateShapes() {
        if (this.clickableAreaShape != null) {
            this.updateShapes(this.geometricShape, this.clickableAreaShape);
        } else {
            this.updateShapes(this.geometricShape);
        }
    }

    private void updateShapes(Path ... paths) {
        Object[] pathElements = this.getPathElements();
        Path[] pathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            p.getElements().setAll(pathElements);
            ++n2;
        }
    }
}

