/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.graph;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;

public class Edge
implements IAttributeStore {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private Node source;
    private Node target;
    private Graph graph;

    public Edge(Map<String, Object> attributes, Node source, Node target) {
        this.attributesProperty.putAll(attributes);
        this.source = source;
        this.target = target;
    }

    public Edge(Node source, Node target) {
        this(new HashMap<String, Object>(), source, target);
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Edge {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attributesProperty);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attributesProperty.get(attrKey));
        }
        sb.append("} from " + this.getSource() + " to " + this.getTarget());
        return sb.toString();
    }

    public static class Builder {
        private List<Map.Entry<Object, Object>> attr = new ArrayList<Map.Entry<Object, Object>>();
        private Graph.Builder.Context context;
        private Object sourceNodeOrKey;
        private Object targetNodeOrKey;

        public Builder(Graph.Builder.Context context, Object sourceNodeOrKey, Object targetNodeOrKey) {
            this.context = context;
            if (context != null) {
                context.edgeBuilders.add(this);
            }
            this.sourceNodeOrKey = sourceNodeOrKey;
            this.targetNodeOrKey = targetNodeOrKey;
        }

        public Builder(Node sourceNode, Node targetNode) {
            this(null, sourceNode, targetNode);
        }

        public <T> Builder attr(BiConsumer<Edge, T> setter, T value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<BiConsumer<Edge, T>, T>(setter, value));
            return this;
        }

        public Builder attr(String key, Object value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
            return this;
        }

        public Graph build() {
            if (this.context == null) {
                throw new IllegalStateException("The builder is not chained.");
            }
            return this.context.builder.build();
        }

        public Edge buildEdge() {
            if (this.context == null && !(this.sourceNodeOrKey instanceof Node)) {
                throw new IllegalStateException("May only use builder keys in case of chained builders.");
            }
            if (this.context == null && !(this.targetNodeOrKey instanceof Node)) {
                throw new IllegalStateException("May only use builder keys in case of chained builders.");
            }
            Node sourceNode = this.sourceNodeOrKey instanceof Node ? (Node)this.sourceNodeOrKey : this.context.builder.findOrCreateNode(this.sourceNodeOrKey);
            Node targetNode = this.targetNodeOrKey instanceof Node ? (Node)this.targetNodeOrKey : this.context.builder.findOrCreateNode(this.targetNodeOrKey);
            Edge e = new Edge(sourceNode, targetNode);
            for (Map.Entry<Object, Object> s : this.attr) {
                if (s.getKey() instanceof String) {
                    e.attributesProperty().put((Object)((String)s.getKey()), s.getValue());
                    continue;
                }
                ((BiConsumer)s.getKey()).accept(e, s.getValue());
            }
            return e;
        }

        public Builder edge(Object sourceNodeOrKey, Object targetNodeOrKey) {
            Builder eb = new Builder(this.context, sourceNodeOrKey, targetNodeOrKey);
            return eb;
        }

        public Node.Builder node() {
            Node.Builder nb = new Node.Builder(this.context);
            this.context.nodeKeys.add(nb.getKey());
            return nb;
        }

        public Node.Builder node(Object key) {
            Node.Builder nb = new Node.Builder(this.context, key);
            this.context.nodeKeys.add(key);
            return nb;
        }
    }
}

