/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.graph;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Node;

public final class Graph
implements IAttributeStore {
    public static final String NODES_PROPERTY = "nodes";
    public static final String EDGES_PROPERTY = "edgesProperty";
    private final ReadOnlyListWrapper<Node> nodesProperty = new ReadOnlyListWrapperEx((Object)this, "nodes", CollectionUtils.observableArrayList());
    private final ReadOnlyListWrapper<Edge> edgesProperty = new ReadOnlyListWrapperEx((Object)this, "edgesProperty", CollectionUtils.observableArrayList());
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private Node nestingNode;

    public Graph() {
        this(new HashMap<String, Object>(), new ArrayList(), new ArrayList());
    }

    public Graph(Collection<? extends Node> nodes, Collection<? extends Edge> edges) {
        this(new HashMap<String, Object>(), nodes, edges);
    }

    public Graph(Map<String, Object> attributes, Collection<? extends Node> nodes, Collection<? extends Edge> edges) {
        this.attributesProperty.putAll(attributes);
        this.nodesProperty.addAll(nodes);
        this.edgesProperty.addAll(edges);
        for (Node node : nodes) {
            node.setGraph(this);
        }
        for (Edge edge : edges) {
            edge.setGraph(this);
        }
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<Edge> edgesProperty() {
        return this.edgesProperty.getReadOnlyProperty();
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public ObservableList<Edge> getEdges() {
        return this.edgesProperty.getReadOnlyProperty();
    }

    public Node getNestingNode() {
        return this.nestingNode;
    }

    public ObservableList<Node> getNodes() {
        return this.nodesProperty.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<Node> nodesProperty() {
        return this.nodesProperty.getReadOnlyProperty();
    }

    public void setNestingNode(Node nestingNode) {
        this.nestingNode = nestingNode;
        if (nestingNode.getNestedGraph() != this) {
            nestingNode.setNestedGraph(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph");
        sb.append(" attr {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attributesProperty);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attributesProperty.get(attrKey));
        }
        sb.append("}");
        sb.append(".nodes {");
        separator = false;
        for (Node n : this.getNodes()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(n.toString());
        }
        sb.append("}");
        sb.append(".edges {");
        separator = false;
        for (Edge e : this.getEdges()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(e.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private List<Map.Entry<Object, Object>> attr = new ArrayList<Map.Entry<Object, Object>>();
        private HashMap<Object, Node> nodes = new HashMap();
        private List<Edge> edges = new ArrayList<Edge>();
        private Context context = new Context();

        public Builder() {
            this.context.builder = this;
        }

        public <T> Builder attr(BiConsumer<Graph, T> setter, T value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<BiConsumer<Graph, T>, T>(setter, value));
            return this;
        }

        public Builder attr(String key, Object value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
            return this;
        }

        public Graph build() {
            for (Node.Builder nb : this.context.nodeBuilders.values()) {
                this.nodes.put(nb.getKey(), nb.buildNode());
            }
            for (Edge.Builder eb : this.context.edgeBuilders) {
                this.edges.add(eb.buildEdge());
            }
            ArrayList<Node> nodeList = new ArrayList<Node>();
            for (Object key : this.context.nodeKeys) {
                nodeList.add(this.nodes.get(key));
            }
            Graph g = new Graph(nodeList, this.edges);
            for (Map.Entry<Object, Object> s : this.attr) {
                if (s.getKey() instanceof String) {
                    g.attributesProperty().put((Object)((String)s.getKey()), s.getValue());
                    continue;
                }
                ((BiConsumer)s.getKey()).accept(g, s.getValue());
            }
            return g;
        }

        public Edge.Builder edge(Object sourceNodeOrKey, Object targetNodeOrKey) {
            Edge.Builder eb = new Edge.Builder(this.context, sourceNodeOrKey, targetNodeOrKey);
            return eb;
        }

        public Builder edges(Collection<Edge> edges) {
            return this.edges(edges.toArray(new Edge[0]));
        }

        public Builder edges(Edge ... edges) {
            this.edges.addAll(Arrays.asList(edges));
            return this;
        }

        protected Node findOrCreateNode(Object key) {
            if (this.nodes.containsKey(key)) {
                return this.nodes.get(key);
            }
            Node.Builder nodeBuilder = this.context.nodeBuilders.get(key);
            if (nodeBuilder == null) {
                return null;
            }
            this.context.nodeKeys.add(key);
            this.nodes.put(key, nodeBuilder.buildNode());
            return this.nodes.get(key);
        }

        public Node.Builder node() {
            Node.Builder nb = new Node.Builder(this.context);
            this.context.nodeKeys.add(nb.getKey());
            return nb;
        }

        public Node.Builder node(Object key) {
            if (this.context.nodeBuilders.containsKey(key)) {
                return this.context.nodeBuilders.get(key);
            }
            Node.Builder nb = new Node.Builder(this.context, key);
            this.context.nodeKeys.add(key);
            return nb;
        }

        public Builder nodes(Collection<Node> nodes) {
            return this.nodes(nodes.toArray(new Node[0]));
        }

        public Builder nodes(Node ... nodes) {
            Node[] nodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node n3 = nodeArray[n2];
                UUID key = UUID.randomUUID();
                this.context.nodeKeys.add(key);
                this.nodes.put(key, n3);
                ++n2;
            }
            return this;
        }

        protected class Context {
            protected Builder builder;
            protected Map<Object, Node.Builder> nodeBuilders = new HashMap<Object, Node.Builder>();
            protected List<Edge.Builder> edgeBuilders = new ArrayList<Edge.Builder>();
            protected List<Object> nodeKeys = new ArrayList<Object>();
            protected Map<Object, Node.Builder> nodeKeyToBuilderMap = new HashMap<Object, Node.Builder>();

            protected Context() {
            }
        }
    }
}

