/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.graph;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;

public class Node
implements IAttributeStore {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private Graph graph;
    private Graph nestedGraph;

    public Node() {
        this(new HashMap<String, Object>());
    }

    public Node(Map<String, Object> attributes) {
        this.attributesProperty.putAll(attributes);
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public Set<Edge> getAllIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> incoming = Collections.newSetFromMap(new IdentityHashMap());
        incoming.addAll(this.getIncomingEdges());
        if (this.graph.getNestingNode() != null) {
            incoming.addAll(this.graph.getNestingNode().getAllIncomingEdges());
        }
        return incoming;
    }

    public Set<Node> getAllNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getAllPredecessorNodes());
        neighbors.addAll(this.getAllSuccessorNodes());
        return neighbors;
    }

    public Set<Edge> getAllOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> outgoing = Collections.newSetFromMap(new IdentityHashMap());
        outgoing.addAll(this.getOutgoingEdges());
        if (this.graph.getNestingNode() != null) {
            outgoing.addAll(this.graph.getNestingNode().getAllOutgoingEdges());
        }
        return outgoing;
    }

    public Set<Node> getAllPredecessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Node> predecessors = Collections.newSetFromMap(new IdentityHashMap());
        predecessors.addAll(this.getPredecessorNodes());
        if (this.graph.getNestingNode() != null) {
            predecessors.addAll(this.graph.getNestingNode().getAllPredecessorNodes());
        }
        return predecessors;
    }

    public Set<Node> getAllSuccessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Node> successors = Collections.newSetFromMap(new IdentityHashMap());
        successors.addAll(this.getSuccessorNodes());
        if (this.graph.getNestingNode() != null) {
            successors.addAll(this.graph.getNestingNode().getAllSuccessorNodes());
        }
        return successors;
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set<Edge> getIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> incoming = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getTarget() != this) continue;
            incoming.add(e);
        }
        return incoming;
    }

    public Set<Node> getNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getPredecessorNodes());
        neighbors.addAll(this.getSuccessorNodes());
        return neighbors;
    }

    public Graph getNestedGraph() {
        return this.nestedGraph;
    }

    public Set<Edge> getOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> outgoing = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getSource() != this) continue;
            outgoing.add(e);
        }
        return outgoing;
    }

    public Set<Node> getPredecessorNodes() {
        Set<Node> predecessors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge incoming : this.getIncomingEdges()) {
            predecessors.add(incoming.getSource());
        }
        return predecessors;
    }

    public Set<Node> getSuccessorNodes() {
        Set<Node> successors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge outgoing : this.getOutgoingEdges()) {
            successors.add(outgoing.getTarget());
        }
        return successors;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setNestedGraph(Graph nestedGraph) {
        this.nestedGraph = nestedGraph;
        if (nestedGraph.getNestingNode() != this) {
            nestedGraph.setNestingNode(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attributesProperty);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attributesProperty.get(attrKey));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private Graph.Builder.Context context;
        private Object key;
        private List<Map.Entry<Object, Object>> attr = new ArrayList<Map.Entry<Object, Object>>();

        public Builder() {
            this(null);
        }

        public Builder(Graph.Builder.Context context) {
            this(context, null);
        }

        public Builder(Graph.Builder.Context context, Object key) {
            this.context = context;
            if (context != null) {
                this.key = key == null ? UUID.randomUUID() : key;
                this.context.nodeBuilders.put(this.key, this);
            }
        }

        public <T> Builder attr(BiConsumer<Node, T> setter, T value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<BiConsumer<Node, T>, T>(setter, value));
            return this;
        }

        public Builder attr(String key, Object value) {
            this.attr.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
            return this;
        }

        public Graph build() {
            return this.context.builder.build();
        }

        public Node buildNode() {
            Node n = new Node();
            for (Map.Entry<Object, Object> s : this.attr) {
                if (s.getKey() instanceof String) {
                    n.attributesProperty().put((Object)((String)s.getKey()), s.getValue());
                    continue;
                }
                ((BiConsumer)s.getKey()).accept(n, s.getValue());
            }
            return n;
        }

        public Edge.Builder edge(Object sourceNodeOrKey, Object targetNodeOrKey) {
            Edge.Builder eb = new Edge.Builder(this.context, sourceNodeOrKey, targetNodeOrKey);
            return eb;
        }

        protected Object getKey() {
            return this.key;
        }

        public Builder node() {
            Builder nb = new Builder(this.context);
            this.context.nodeKeys.add(nb.getKey());
            return nb;
        }

        public Builder node(Object key) {
            Builder nb = new Builder(this.context, key);
            this.context.nodeKeys.add(key);
            return nb;
        }
    }
}

