/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.fx.utils.CursorUtils;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverBehavior
extends AbstractBehavior {
    public static final String HOVER_FEEDBACK_PART_FACTORY = "HOVER_FEEDBACK_PART_FACTORY";
    public static final String HOVER_HANDLE_PART_FACTORY = "HOVER_HANDLE_PART_FACTORY";
    public static final int REMOVAL_DELAY_MILLIS = 500;
    public static final int CREATION_DELAY_MILLIS = 250;
    public static final double MOUSE_MOVE_THRESHOLD = 4.0;
    private ChangeListener<IVisualPart<? extends Node>> hoverObserver = new ChangeListener<IVisualPart<? extends Node>>(){

        public void changed(ObservableValue<? extends IVisualPart<? extends Node>> observable, IVisualPart<? extends Node> oldValue, IVisualPart<? extends Node> newValue) {
            HoverBehavior.this.onHoverChange(oldValue, newValue);
        }
    };
    private final Map<IVisualPart<? extends Node>, Effect> effects = new HashMap<IVisualPart<? extends Node>, Effect>();
    private Map<IVisualPart<? extends Node>, PauseTransition> handleCreationDelayTransitions = new IdentityHashMap<IVisualPart<? extends Node>, PauseTransition>();
    private Map<IVisualPart<? extends Node>, PauseTransition> handleRemovalDelayTransitions = new IdentityHashMap<IVisualPart<? extends Node>, PauseTransition>();
    private Point initialPointerLocation;
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            HoverBehavior.this.onMouseMove(event);
        }
    };
    private Map<IVisualPart<? extends Node>, ChangeListener<IVisualPart<? extends Node>>> hoveredParentChangeListeners = new IdentityHashMap<IVisualPart<? extends Node>, ChangeListener<IVisualPart<? extends Node>>>();

    @Override
    protected void doActivate() {
        HoverModel hoverModel = this.getHoverModel();
        hoverModel.hoverProperty().addListener(this.hoverObserver);
        IVisualPart<? extends Node> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(null, hover);
        }
    }

    @Override
    protected void doDeactivate() {
        HoverModel hoverModel = this.getHoverModel();
        IVisualPart<? extends Node> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(hover, null);
        }
        hoverModel.hoverProperty().removeListener(this.hoverObserver);
        this.stopAllDelays();
        this.clearFeedback();
        this.clearHandles();
    }

    @Override
    protected IFeedbackPartFactory getFeedbackPartFactory(IViewer viewer) {
        return this.getFeedbackPartFactory(viewer, HOVER_FEEDBACK_PART_FACTORY);
    }

    public Effect getHandleHoverFeedbackEffect(Map<Object, Object> contextMap) {
        DropShadow effect = new DropShadow();
        effect.setRadius(5.0);
        return effect;
    }

    @Override
    protected IHandlePartFactory getHandlePartFactory(IViewer viewer) {
        return this.getHandlePartFactory(viewer, HOVER_HANDLE_PART_FACTORY);
    }

    protected HoverModel getHoverModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        HoverModel hoverModel = (HoverModel)viewer.getAdapter(HoverModel.class);
        return hoverModel;
    }

    protected boolean isInCreationDelay(IVisualPart<? extends Node> part) {
        return this.handleCreationDelayTransitions.containsKey(part) && Animation.Status.RUNNING.equals((Object)this.handleCreationDelayTransitions.get(part).getStatus());
    }

    protected boolean isInRemovalDelay(IVisualPart<? extends Node> part) {
        return this.handleRemovalDelayTransitions.containsKey(part) && Animation.Status.RUNNING.equals((Object)this.handleRemovalDelayTransitions.get(part).getStatus());
    }

    protected void onCreationDelay(final IVisualPart<? extends Node> hoveredPart) {
        this.unregisterMouseHandler();
        this.initialPointerLocation = null;
        this.addHandles(hoveredPart);
        ChangeListener<IVisualPart<? extends Node>> parentChangeListener = new ChangeListener<IVisualPart<? extends Node>>(){

            public void changed(ObservableValue<? extends IVisualPart<? extends Node>> observable, IVisualPart<? extends Node> oldValue, IVisualPart<? extends Node> newValue) {
                HoverBehavior.this.hoveredParentChangeListeners.remove(hoveredPart);
                observable.removeListener((ChangeListener)this);
                HoverBehavior.this.stopRemovalDelay(hoveredPart);
                if (HoverBehavior.this.hasHandles(hoveredPart)) {
                    HoverBehavior.this.removeHandles(hoveredPart);
                }
                if (HoverBehavior.this.hasFeedback(hoveredPart)) {
                    HoverBehavior.this.removeFeedback(hoveredPart);
                }
            }
        };
        this.hoveredParentChangeListeners.put(hoveredPart, parentChangeListener);
        hoveredPart.parentProperty().addListener((ChangeListener)parentChangeListener);
        this.handleCreationDelayTransitions.remove(hoveredPart);
    }

    protected void onHover(IVisualPart<? extends Node> hoveredPart) {
        if (this.isInRemovalDelay(hoveredPart)) {
            this.stopRemovalDelay(hoveredPart);
        } else {
            this.addFeedback(hoveredPart);
            this.startCreationDelay(hoveredPart);
        }
    }

    private void onHoverChange(IVisualPart<? extends Node> oldHovered, IVisualPart<? extends Node> newHovered) {
        ObservableSetMultimap<IVisualPart<Node>, String> anchorages;
        if (oldHovered != null) {
            if (oldHovered instanceof IHandlePart) {
                if (!this.effects.containsKey(oldHovered)) {
                    throw new IllegalStateException("Cannot unhover/restore effect <" + oldHovered + ">.");
                }
                oldHovered.getVisual().setEffect(this.effects.remove(oldHovered));
                anchorages = oldHovered.getAnchoragesUnmodifiable();
                for (IVisualPart anchorage : anchorages.keySet()) {
                    if (!this.hasHandles(anchorage)) continue;
                    if (anchorage.getRoot() != null) {
                        this.startRemovalDelay(anchorage);
                    }
                    break;
                }
            } else {
                this.onUnhover(oldHovered);
            }
        }
        if (newHovered != null) {
            if (newHovered instanceof IHandlePart) {
                this.effects.put(newHovered, newHovered.getVisual().getEffect());
                newHovered.getVisual().setEffect(this.getHandleHoverFeedbackEffect(Collections.emptyMap()));
                anchorages = newHovered.getAnchoragesUnmodifiable();
                for (IVisualPart anchorage : anchorages.keySet()) {
                    if (!this.hasHandles(anchorage)) continue;
                    this.stopRemovalDelay(anchorage);
                    break;
                }
            } else {
                this.onHover(newHovered);
            }
        }
    }

    protected void onMouseMove(MouseEvent event) {
        double dx = event.getScreenX() - this.initialPointerLocation.x;
        double dy = event.getScreenY() - this.initialPointerLocation.y;
        if (Math.abs(dx) > 4.0 || Math.abs(dy) > 4.0) {
            this.initialPointerLocation = CursorUtils.getPointerLocation();
            for (PauseTransition transition : this.handleCreationDelayTransitions.values()) {
                transition.playFromStart();
            }
        }
    }

    protected void onRemovalDelay(IVisualPart<? extends Node> hoveredPart) {
        this.removeFeedback(hoveredPart);
        this.removeHandles(hoveredPart);
        if (this.hoveredParentChangeListeners.containsKey(hoveredPart)) {
            hoveredPart.parentProperty().removeListener(this.hoveredParentChangeListeners.remove(hoveredPart));
        }
    }

    protected void onUnhover(IVisualPart<? extends Node> hoveredPart) {
        if (!this.hasHandles(hoveredPart)) {
            if (this.isInCreationDelay(hoveredPart)) {
                this.stopCreationDelay(hoveredPart);
            }
            if (this.hasFeedback(hoveredPart)) {
                this.removeFeedback(hoveredPart);
            }
        } else if (hoveredPart.getRoot() == null || this.getHandles(hoveredPart).isEmpty()) {
            this.onRemovalDelay(hoveredPart);
        } else {
            this.startRemovalDelay(hoveredPart);
        }
    }

    protected void registerMouseHandler(IVisualPart<? extends Node> part) {
        this.initialPointerLocation = CursorUtils.getPointerLocation();
        Scene scene = part.getVisual().getScene();
        scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
        scene.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseMoveHandler);
    }

    protected void startCreationDelay(final IVisualPart<? extends Node> hoveredPart) {
        this.registerMouseHandler(hoveredPart);
        PauseTransition transition = new PauseTransition(Duration.millis((double)250.0));
        this.handleCreationDelayTransitions.put(hoveredPart, transition);
        transition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                HoverBehavior.this.onCreationDelay(hoveredPart);
            }
        });
        transition.play();
    }

    protected void startRemovalDelay(final IVisualPart<? extends Node> hoveredPart) {
        PauseTransition transition = new PauseTransition(Duration.millis((double)500.0));
        this.handleRemovalDelayTransitions.put(hoveredPart, transition);
        transition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                HoverBehavior.this.onRemovalDelay(hoveredPart);
            }
        });
        transition.play();
    }

    protected void stopAllDelays() {
        for (PauseTransition transition : this.handleCreationDelayTransitions.values()) {
            transition.stop();
        }
        this.handleCreationDelayTransitions.clear();
        for (PauseTransition transition : this.handleRemovalDelayTransitions.values()) {
            transition.stop();
        }
        this.handleCreationDelayTransitions.clear();
    }

    protected void stopCreationDelay(IVisualPart<? extends Node> part) {
        PauseTransition transition = this.handleCreationDelayTransitions.remove(part);
        if (transition != null) {
            transition.stop();
        }
        this.unregisterMouseHandler();
    }

    protected void stopRemovalDelay(IVisualPart<? extends Node> part) {
        PauseTransition transition = this.handleRemovalDelayTransitions.remove(part);
        if (transition != null) {
            transition.stop();
        }
    }

    protected void unregisterMouseHandler() {
        Scene scene = this.getHost().getVisual().getScene();
        scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
        scene.removeEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseMoveHandler);
        this.initialPointerLocation = null;
    }
}

