/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.gef.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.common.dispose.IDisposable;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class SelectionModel
implements IDisposable {
    public static final String SELECTION_PROPERTY = "selection";
    private ObservableList<IContentPart<? extends Node>> selection = CollectionUtils.observableArrayList();
    private ObservableList<IContentPart<? extends Node>> selectionUnmodifiable = FXCollections.unmodifiableObservableList(this.selection);
    private ReadOnlyListWrapper<IContentPart<? extends Node>> selectionUnmodifiableProperty = new ReadOnlyListWrapperEx((Object)this, "selection", this.selectionUnmodifiable);

    public void appendToSelection(IContentPart<? extends Node> toBeAppended) {
        this.appendToSelection(Collections.singletonList(toBeAppended));
    }

    public void appendToSelection(List<? extends IContentPart<? extends Node>> toBeAppended) {
        List<IContentPart<? extends Node>> newSelection = this.getSelectionCopy();
        newSelection.removeAll(toBeAppended);
        for (IContentPart<? extends Node> iContentPart : toBeAppended) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public void dispose() {
        this.selection.clear();
    }

    private List<IContentPart<? extends Node>> getSelectionCopy() {
        return new ArrayList<IContentPart<? extends Node>>((Collection<IContentPart<? extends Node>>)this.selection);
    }

    public ObservableList<IContentPart<? extends Node>> getSelectionUnmodifiable() {
        return this.selectionUnmodifiable;
    }

    public boolean isSelected(IContentPart<? extends Node> contentPart) {
        return this.selection.contains(contentPart);
    }

    public void prependToSelection(IContentPart<? extends Node> toBePrepended) {
        this.prependToSelection(Collections.singletonList(toBePrepended));
    }

    public void prependToSelection(List<? extends IContentPart<? extends Node>> toBePrepended) {
        List<IContentPart<? extends Node>> newSelection = this.getSelectionCopy();
        newSelection.removeAll(toBePrepended);
        int i = 0;
        for (IContentPart<? extends Node> iContentPart : toBePrepended) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(i++, iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }

    public void removeFromSelection(Collection<? extends IContentPart<? extends Node>> contentParts) {
        this.selection.removeAll(contentParts);
    }

    public void removeFromSelection(IContentPart<? extends Node> contentPart) {
        this.selection.remove(contentPart);
    }

    public ReadOnlyListProperty<IContentPart<? extends Node>> selectionUnmodifiableProperty() {
        return this.selectionUnmodifiableProperty.getReadOnlyProperty();
    }

    public void setSelection(IContentPart<? extends Node> newSelection) {
        this.setSelection(Collections.singletonList(newSelection));
    }

    public void setSelection(List<? extends IContentPart<? extends Node>> selection) {
        ArrayList<IContentPart<? extends Node>> newSelection = new ArrayList<IContentPart<? extends Node>>();
        int i = 0;
        for (IContentPart<? extends Node> iContentPart : selection) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(i++, iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }
}

