/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.models.FocusModel;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class ChangeFocusOperation
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Change Focus";
    private IViewer viewer;
    private IContentPart<? extends Node> oldFocused;
    private IContentPart<? extends Node> newFocused;

    public ChangeFocusOperation(IViewer viewer, IContentPart<? extends Node> newFocused) {
        this(DEFAULT_LABEL, viewer, newFocused);
    }

    public ChangeFocusOperation(String label, IViewer viewer, IContentPart<? extends Node> newFocused) {
        super(label);
        this.viewer = viewer;
        this.oldFocused = this.getFocusModel().getFocus();
        this.newFocused = newFocused;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getFocusModel().setFocus(this.newFocused);
        return Status.OK_STATUS;
    }

    protected FocusModel getFocusModel() {
        return (FocusModel)this.viewer.getAdapter(FocusModel.class);
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.oldFocused == this.newFocused;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setNewFocused(IContentPart<? extends Node> newFocused) {
        this.newFocused = newFocused;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getFocusModel().setFocus(this.oldFocused);
        return Status.OK_STATUS;
    }
}

