/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import java.util.HashMap;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.listeners.VisualChangeListener;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.AbstractVisualPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public abstract class AbstractFeedbackPart<V extends Node>
extends AbstractVisualPart<V>
implements IFeedbackPart<V> {
    private final Map<IVisualPart<? extends Node>, Integer> anchorageLinkCount = new HashMap<IVisualPart<? extends Node>, Integer>();
    private final Map<IVisualPart<? extends Node>, VisualChangeListener> visualChangeListeners = new HashMap<IVisualPart<? extends Node>, VisualChangeListener>();
    private ListChangeListener<Point> geometryListener = new ListChangeListener<Point>(){

        public void onChanged(ListChangeListener.Change<? extends Point> c) {
            AbstractFeedbackPart.this.refreshVisual();
        }
    };

    @Override
    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        throw new UnsupportedOperationException("IFeedbackParts do not support children");
    }

    @Override
    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        int count;
        int n = count = this.anchorageLinkCount.get(anchorage) == null ? 0 : this.anchorageLinkCount.get(anchorage);
        if (count == 0) {
            Node anchorageVisual = anchorage.getVisual();
            final boolean[] doIt = new boolean[]{true};
            VisualChangeListener listener = new VisualChangeListener(){

                protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
                    if (doIt[0]) {
                        doIt[0] = false;
                        AbstractFeedbackPart.this.refreshVisual();
                        doIt[0] = true;
                    }
                }

                protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
                    if (doIt[0]) {
                        doIt[0] = false;
                        AbstractFeedbackPart.this.refreshVisual();
                        doIt[0] = true;
                    }
                }
            };
            this.visualChangeListeners.put(anchorage, listener);
            listener.register(anchorage.getVisual(), this.getVisual());
            if (anchorageVisual instanceof Connection) {
                Connection connection = (Connection)anchorageVisual;
                connection.pointsUnmodifiableProperty().addListener(this.geometryListener);
            }
        }
        this.anchorageLinkCount.put(anchorage, count + 1);
    }

    @Override
    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        int count = this.anchorageLinkCount.get(anchorage);
        if (count == 1) {
            this.visualChangeListeners.remove(anchorage).unregister();
            Node anchorageVisual = anchorage.getVisual();
            if (anchorageVisual instanceof Connection) {
                ((Connection)anchorageVisual).pointsUnmodifiableProperty().removeListener(this.geometryListener);
            }
        }
        if (count > 1) {
            this.anchorageLinkCount.put(anchorage, count - 1);
        } else {
            this.anchorageLinkCount.remove(anchorage);
        }
    }

    @Override
    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        throw new UnsupportedOperationException("IFeedbackParts do not support this");
    }
}

