/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.geometry.planar.ICurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.IShape;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.CircleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.RectangleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.SquareSegmentHandlePart;
import org.eclipse.gef.mvc.fx.providers.ResizableTransformableBoundsProvider;

public class DefaultSelectionHandlePartFactory
implements IHandlePartFactory {
    public static final String INSERT_HANDLE_COLOR_PROVIDER = "INSERT_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_INSERT_HANDLE_COLOR = Color.WHITE;
    public static final String MOVE_HANDLE_COLOR_PROVIDER = "MOVE_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_MOVE_HANDLE_COLOR = Color.web((String)"#7986cb");
    public static final String CONNECTED_HANDLE_COLOR_PROVIDER = "CONNECTED_HANDLE_COLOR_PROVIDER";
    public static final Color DEFAULT_CONNECTED_HANDLE_COLOR = Color.RED;
    public static final String SELECTION_HANDLES_GEOMETRY_PROVIDER = "SELECTION_HANDLES_GEOMETRY_PROVIDER";
    public static final String MULTI_SELECTION_HANDLES_GEOMETRY_PROVIDER = "MULTI_SELECTION_HANDLES_GEOMETRY_PROVIDER";
    protected static final double BENDPOINT_CREATE_HANDLE_MINIMUM_SEGMENT_LENGTH = 30.0;
    protected static final double SEGMENT_MOVE_HANDLE_MINIMUM_SEGMENT_LENGTH = 5.0;
    protected static final double SEGMENT_CREATE_HANDLE_MINIMUM_SEGMENT_LENGTH = 45.0;
    @Inject
    private Injector injector;

    private static Provider<BezierCurve[]> createSegmentsProvider(final Provider<? extends IGeometry> geometryProvider) {
        return new Provider<BezierCurve[]>(){

            public BezierCurve[] get() {
                IGeometry geometry = (IGeometry)geometryProvider.get();
                if (geometry instanceof IShape) {
                    ArrayList<BezierCurve> segments = new ArrayList<BezierCurve>();
                    ICurve[] iCurveArray = ((IShape)geometry).getOutlineSegments();
                    int n = iCurveArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICurve os = iCurveArray[n2];
                        segments.addAll(Arrays.asList(os.toBezier()));
                        ++n2;
                    }
                    return segments.toArray(new BezierCurve[0]);
                }
                if (geometry instanceof ICurve) {
                    return ((ICurve)geometry).toBezier();
                }
                throw new IllegalStateException("Unable to deduce segments from geometry: Expected IShape or ICurve but got: " + geometry);
            }
        };
    }

    @Override
    public List<IHandlePart<? extends Node>> createHandleParts(List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        if (targets.size() == 1) {
            return this.createSingleSelectionHandleParts(targets.get(0), contextMap);
        }
        return this.createMultiSelectionHandleParts(targets, contextMap);
    }

    protected List<IHandlePart<? extends Node>> createMultiSelectionHandleParts(final List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        Provider<BezierCurve[]> segmentsProvider;
        int segments;
        Provider multiSelectionHandlesGeometryInSceneProvider = (Provider)targets.get(0).getRoot().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)MULTI_SELECTION_HANDLES_GEOMETRY_PROVIDER));
        if (multiSelectionHandlesGeometryInSceneProvider == null) {
            multiSelectionHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

                public IGeometry get() {
                    Rectangle bounds = null;
                    for (IVisualPart part : targets) {
                        ResizableTransformableBoundsProvider boundsProvider = new ResizableTransformableBoundsProvider();
                        boundsProvider.setAdaptable(part);
                        IGeometry boundsInLocal = boundsProvider.get();
                        if (boundsInLocal == null) continue;
                        Rectangle boundsInScene = FX2Geometry.toRectangle((Bounds)part.getVisual().localToScene(Geometry2FX.toFXBounds((Rectangle)boundsInLocal.getBounds())));
                        if (bounds == null) {
                            bounds = boundsInScene;
                            continue;
                        }
                        bounds.union(boundsInScene);
                    }
                    return bounds;
                }
            };
        }
        if ((segments = ((BezierCurve[])(segmentsProvider = DefaultSelectionHandlePartFactory.createSegmentsProvider((Provider<? extends IGeometry>)multiSelectionHandlesGeometryInSceneProvider)).get()).length) != 4) {
            throw new IllegalStateException("The multi selection handle geometry provider is expected to return bounds around the selection. However, instead of 4 segments, the provider provides " + segments + " segments.");
        }
        ArrayList<IHandlePart<? extends Node>> handleParts = new ArrayList<IHandlePart<? extends Node>>();
        int i = 0;
        while (i < 4) {
            SquareSegmentHandlePart part = (SquareSegmentHandlePart)this.injector.getInstance(SquareSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            handleParts.add(part);
            ++i;
        }
        return handleParts;
    }

    protected List<IHandlePart<? extends Node>> createSingleSelectionHandleParts(final IVisualPart<? extends Node> target, Map<Object, Object> contextMap) {
        IGeometry selectionHandlesGeometry;
        final Provider selectionHandlesGeometryInTargetLocalProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_HANDLES_GEOMETRY_PROVIDER));
        IGeometry iGeometry = selectionHandlesGeometry = selectionHandlesGeometryInTargetLocalProvider != null ? (IGeometry)selectionHandlesGeometryInTargetLocalProvider.get() : null;
        if (selectionHandlesGeometry == null) {
            return Collections.emptyList();
        }
        Provider<IGeometry> selectionHandlesGeometryInSceneProvider = new Provider<IGeometry>(){

            public IGeometry get() {
                return NodeUtils.localToScene(target.getVisual(), (IGeometry)((IGeometry)selectionHandlesGeometryInTargetLocalProvider.get()));
            }
        };
        Provider<BezierCurve[]> selectionHandlesSegmentsInSceneProvider = DefaultSelectionHandlePartFactory.createSegmentsProvider((Provider<? extends IGeometry>)selectionHandlesGeometryInSceneProvider);
        if (selectionHandlesGeometry instanceof ICurve) {
            return this.createSingleSelectionHandlePartsForCurve(target, contextMap, selectionHandlesSegmentsInSceneProvider);
        }
        if (selectionHandlesGeometry instanceof IShape) {
            if (selectionHandlesGeometry instanceof Rectangle) {
                return this.createSingleSelectionHandlePartsForRectangularOutline(target, contextMap, selectionHandlesSegmentsInSceneProvider);
            }
            return this.createSingleSelectionHandlePartsForPolygonalOutline(target, contextMap, selectionHandlesSegmentsInSceneProvider);
        }
        throw new IllegalStateException("Unable to generate handles for this handle geometry. Expected ICurve or IShape, but got: " + selectionHandlesGeometry);
    }

    protected List<IHandlePart<? extends Node>> createSingleSelectionHandlePartsForCurve(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<? extends Node>> hps = new ArrayList<IHandlePart<? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        if (target.getVisual() instanceof Connection && ((Connection)target.getVisual()).getRouter() instanceof OrthogonalRouter) {
            int i = 0;
            while (i < segments.length) {
                AbstractSegmentHandlePart part;
                double segmentLength;
                if (i == 0) {
                    CircleSegmentHandlePart part2 = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
                    part2.setSegmentsProvider(segmentsProvider);
                    part2.setSegmentIndex(i);
                    part2.setSegmentParameter(0.0);
                    hps.add(part2);
                }
                if ((segmentLength = new Polyline(segments[i].getPoints()).getLength()) > 45.0) {
                    part = (RectangleSegmentHandlePart)this.injector.getInstance(RectangleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.25);
                    hps.add(part);
                }
                if (segmentLength > 5.0) {
                    RectangleSegmentHandlePart midPart = (RectangleSegmentHandlePart)this.injector.getInstance(RectangleSegmentHandlePart.class);
                    midPart.setSegmentsProvider(segmentsProvider);
                    midPart.setSegmentIndex(i);
                    midPart.setSegmentParameter(0.5);
                    hps.add(midPart);
                }
                if (segmentLength > 45.0) {
                    part = (RectangleSegmentHandlePart)this.injector.getInstance(RectangleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.75);
                    hps.add(part);
                }
                if (i == segments.length - 1) {
                    part = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(1.0);
                    hps.add(part);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < segments.length) {
                CircleSegmentHandlePart part = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
                part.setSegmentsProvider(segmentsProvider);
                part.setSegmentIndex(i);
                part.setSegmentParameter(0.0);
                hps.add(part);
                double segmentLength = new Polyline(segments[i].getPoints()).getLength();
                if (segmentLength >= 30.0) {
                    part = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(0.5);
                    hps.add(part);
                }
                if (i == segments.length - 1) {
                    part = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
                    part.setSegmentsProvider(segmentsProvider);
                    part.setSegmentIndex(i);
                    part.setSegmentParameter(1.0);
                    hps.add(part);
                }
                ++i;
            }
        }
        return hps;
    }

    protected List<IHandlePart<? extends Node>> createSingleSelectionHandlePartsForPolygonalOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<? extends Node>> handleParts = new ArrayList<IHandlePart<? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            CircleSegmentHandlePart part = (CircleSegmentHandlePart)this.injector.getInstance(CircleSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            handleParts.add(part);
            ++i;
        }
        return handleParts;
    }

    protected List<IHandlePart<? extends Node>> createSingleSelectionHandlePartsForRectangularOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<? extends Node>> hps = new ArrayList<IHandlePart<? extends Node>>();
        BezierCurve[] segments = (BezierCurve[])segmentsProvider.get();
        int i = 0;
        while (i < segments.length) {
            SquareSegmentHandlePart part = (SquareSegmentHandlePart)this.injector.getInstance(SquareSegmentHandlePart.class);
            part.setSegmentsProvider(segmentsProvider);
            part.setSegmentIndex(i);
            part.setSegmentParameter(0.0);
            hps.add(part);
            ++i;
        }
        return hps;
    }
}

