/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventTarget;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.policies.AbstractTransactionPolicy;
import org.eclipse.gef.mvc.fx.policies.IPolicy;
import org.eclipse.gef.mvc.fx.tools.AbstractTool;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractInteractionPolicy
extends AbstractPolicy {
    private static Map<AbstractTransactionPolicy, StackTraceElement[]> started = new HashMap<AbstractTransactionPolicy, StackTraceElement[]>();
    private static Map<AbstractTransactionPolicy, StackTraceElement[]> finished = new HashMap<AbstractTransactionPolicy, StackTraceElement[]>();
    private static boolean isDebug = false;
    private final Map<IVisualPart<? extends Node>, Boolean> initialRefreshVisual = new HashMap<IVisualPart<? extends Node>, Boolean>();
    private Map<IPolicy, IDomain> domains = new HashMap<IPolicy, IDomain>();

    private static boolean canFinish(AbstractTransactionPolicy policy) {
        if (!started.containsKey(policy)) {
            System.out.println("[ERROR] Trying to finish not-yet-started transaction policy " + policy + " from:");
            AbstractInteractionPolicy.printStackTrace(AbstractInteractionPolicy.getRelevantStackTrace());
            if (finished.containsKey(policy)) {
                System.out.println("[INFO] The policy was previously finished at:");
                AbstractInteractionPolicy.printStackTrace(finished.get(policy));
            }
            return false;
        }
        started.remove(policy);
        finished.put(policy, AbstractInteractionPolicy.getRelevantStackTrace());
        return true;
    }

    private static boolean canStart(AbstractTransactionPolicy policy) {
        if (started.containsKey(policy)) {
            System.out.println("[ERROR] Trying to start already-started transaction policy " + policy + " from:");
            AbstractInteractionPolicy.printStackTrace(AbstractInteractionPolicy.getRelevantStackTrace());
            System.out.println("[INFO] The policy was previously started at:");
            AbstractInteractionPolicy.printStackTrace(started.get(policy));
            return false;
        }
        started.put(policy, AbstractInteractionPolicy.getRelevantStackTrace());
        return true;
    }

    private static StackTraceElement[] getRelevantStackTrace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int i = 2;
        while (i < trace.length) {
            if (AbstractTool.class.isAssignableFrom(trace[i].getClass())) break;
            ++i;
        }
        return Arrays.copyOfRange(trace, 2, i);
    }

    private static void printStackTrace(StackTraceElement[] trace) {
        int i = 0;
        while (i < trace.length) {
            System.out.println("*) " + trace[i]);
            ++i;
        }
    }

    protected void commit(AbstractTransactionPolicy policy) {
        if (policy != null) {
            IDomain domain = this.domains.remove(policy);
            if (isDebug && !AbstractInteractionPolicy.canFinish(policy)) {
                return;
            }
            ITransactionalOperation o = policy.commit();
            if (o != null && !o.isNoOp()) {
                try {
                    domain.execute(o, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An exception occured when committing policy " + policy + ".", e);
                }
            }
        }
    }

    protected void init(AbstractTransactionPolicy policy) {
        if (policy != null) {
            if (isDebug && !AbstractInteractionPolicy.canStart(policy)) {
                return;
            }
            this.domains.put(policy, this.getHost().getRoot().getViewer().getDomain());
            policy.init();
        }
    }

    protected boolean isRegistered(EventTarget eventTarget) {
        IVisualPart<? extends Node> host = this.getHost();
        if (host.getRoot() == null || host.getRoot().getViewer() == null) {
            return false;
        }
        IViewer viewer = host.getRoot().getViewer();
        if (eventTarget instanceof Node) {
            return PartUtils.retrieveVisualPart(viewer, (Node)eventTarget) != viewer.getRootPart();
        }
        return false;
    }

    protected boolean isRegisteredForHost(EventTarget eventTarget) {
        IVisualPart<? extends Node> host = this.getHost();
        if (host.getRoot() == null || host.getRoot().getViewer() == null) {
            return false;
        }
        IViewer viewer = host.getRoot().getViewer();
        if (eventTarget instanceof Node) {
            return PartUtils.retrieveVisualPart(viewer, (Node)eventTarget) == host;
        }
        return false;
    }

    protected void restoreRefreshVisuals(IVisualPart<? extends Node> part) {
        part.setRefreshVisual(this.initialRefreshVisual.remove(part));
    }

    protected void rollback(AbstractTransactionPolicy policy) {
        if (policy != null) {
            this.domains.remove(policy);
            if (isDebug && !AbstractInteractionPolicy.canFinish(policy)) {
                return;
            }
            policy.rollback();
        }
    }

    protected void storeAndDisableRefreshVisuals(IVisualPart<? extends Node> part) {
        this.initialRefreshVisual.put(part, part.isRefreshVisual());
        part.setRefreshVisual(false);
    }
}

