/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;

public abstract class AbstractTransactionPolicy
extends AbstractPolicy {
    private ITransactionalOperation operation;
    private boolean initialized;
    private boolean isLocallyExecuteOperation = false;

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not yet initialized!");
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
    }

    public ITransactionalOperation commit() {
        this.checkInitialized();
        this.locallyExecuteOperation();
        this.initialized = false;
        ITransactionalOperation commit = this.getOperation();
        this.operation = null;
        if (commit != null && !commit.isNoOp()) {
            return commit;
        }
        return null;
    }

    protected abstract ITransactionalOperation createOperation();

    protected void doLocallyExecuteOperation() {
        try {
            if (this.operation != null) {
                this.operation.execute(null, null);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    protected final ITransactionalOperation getOperation() {
        return this.operation;
    }

    public void init() {
        this.checkUninitialized();
        this.initialized = true;
        this.setLocallyExecuteOperation(true);
        this.operation = this.createOperation();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public boolean isLocallyExecuteOperation() {
        return this.isLocallyExecuteOperation;
    }

    protected final void locallyExecuteOperation() {
        if (this.isLocallyExecuteOperation()) {
            this.doLocallyExecuteOperation();
        }
    }

    private void locallyUndoOperation() {
        if (!this.isLocallyExecuteOperation()) {
            return;
        }
        try {
            if (this.operation != null) {
                this.operation.undo(null, null);
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void rollback() {
        this.initialized = false;
        this.locallyUndoOperation();
        this.operation = null;
    }

    public void setLocallyExecuteOperation(boolean isLocallyExecuteOperation) {
        this.isLocallyExecuteOperation = isLocallyExecuteOperation;
    }
}

