/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.Comparator;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.behaviors.SelectionBehavior;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.AbstractVisualPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.BendConnectionPolicy;
import org.eclipse.gef.mvc.fx.policies.CursorSupport;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.SnapSupport;

public class BendFirstAnchorageOnSegmentHandleDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private SnapSupport snapSupport = new SnapSupport(this);
    private IVisualPart<? extends Connection> targetPart;
    private boolean isSegmentDragged;
    private Point initialMouseInScene;
    private Point handlePositionInScene;
    private int initialSegmentIndex;
    private double initialSegmentParameter;
    private boolean isInvalid = false;
    private boolean isPrepared;
    private BendConnectionPolicy bendPolicy;
    private Point startPositionInScene;
    private Comparator<IHandlePart<? extends Node>> handleDistanceComparator = new Comparator<IHandlePart<? extends Node>>(){

        @Override
        public int compare(IHandlePart<? extends Node> interactedWith, IHandlePart<? extends Node> other) {
            Bounds otherBounds = other.getVisual().getLayoutBounds();
            Point2D otherPosition = other.getVisual().localToScene(otherBounds.getMinX() + otherBounds.getWidth() / 2.0, otherBounds.getMinY() + otherBounds.getHeight() / 2.0);
            return (int)(BendFirstAnchorageOnSegmentHandleDragPolicy.this.handlePositionInScene.getDistance(FX2Geometry.toPoint((Point2D)otherPosition)) * 10.0);
        }
    };

    @Override
    public void abortDrag() {
        if (this.isInvalid) {
            return;
        }
        this.restoreRefreshVisuals(this.targetPart);
        this.rollback(this.bendPolicy);
        this.updateHandles();
        this.bendPolicy = null;
        this.targetPart = null;
    }

    protected BendConnectionPolicy determineBendPolicy() {
        return (BendConnectionPolicy)this.targetPart.getAdapter(BendConnectionPolicy.class);
    }

    protected IVisualPart<? extends Connection> determineTargetPart() {
        return (IVisualPart)((AbstractVisualPart)this.getHost()).getAnchoragesUnmodifiable().keySet().iterator().next();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        if (!this.isPrepared) {
            this.isPrepared = true;
            this.prepareBend(e.isShiftDown(), this.bendPolicy);
            this.bendPolicy.move(this.initialMouseInScene, this.initialMouseInScene);
            List<Point> initialPositions = this.bendPolicy.getSelectedInitialPositions();
            Point startPositionInConnectionLocal = initialPositions.get(0);
            this.startPositionInScene = FX2Geometry.toPoint((Point2D)this.targetPart.getVisual().localToScene(startPositionInConnectionLocal.x, startPositionInConnectionLocal.y));
        }
        Connection connection = this.targetPart.getVisual();
        boolean isOrthogonal = this.isSegmentDragged && connection.getRouter() instanceof OrthogonalRouter;
        boolean isHorizontal = isOrthogonal && this.bendPolicy.isSelectionHorizontal();
        Point endPositionInScene = this.startPositionInScene.getTranslated(delta);
        endPositionInScene = this.isPrecise(e) ? endPositionInScene : this.snapSupport.snapToGrid(endPositionInScene.x, endPositionInScene.y);
        this.bendPolicy.move(this.startPositionInScene, endPositionInScene);
        if (isOrthogonal) {
            if (isHorizontal) {
                this.handlePositionInScene.setY(endPositionInScene.y);
            } else {
                this.handlePositionInScene.setX(endPositionInScene.x);
            }
        } else {
            this.handlePositionInScene.setX(endPositionInScene.x);
            this.handlePositionInScene.setY(endPositionInScene.y);
        }
        this.updateHandles();
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        this.commit(this.bendPolicy);
        this.restoreRefreshVisuals(this.targetPart);
        this.updateHandles();
        this.bendPolicy = null;
        this.targetPart = null;
    }

    protected BendConnectionPolicy getBendPolicy() {
        return this.bendPolicy;
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public AbstractSegmentHandlePart<? extends Node> getHost() {
        return (AbstractSegmentHandlePart)super.getHost();
    }

    protected IVisualPart<? extends Connection> getTargetPart() {
        return this.targetPart;
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isBend(MouseEvent event) {
        return true;
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    private void prepareBend(boolean isShiftDown, BendConnectionPolicy bendPolicy) {
        IVisualPart host = this.getHost();
        if (((AbstractSegmentHandlePart)host).getSegmentParameter() == 0.5) {
            if (isShiftDown || this.targetPart.getVisual().getRouter() instanceof OrthogonalRouter) {
                bendPolicy.selectSegment(((AbstractSegmentHandlePart)host).getSegmentIndex());
                this.isSegmentDragged = true;
            } else {
                Integer previousAnchorHandle = bendPolicy.getExplicitIndexAtOrBefore(((AbstractSegmentHandlePart)host).getSegmentIndex());
                Integer newAnchorHandle = bendPolicy.createAfter(previousAnchorHandle, this.initialMouseInScene);
                bendPolicy.select(newAnchorHandle);
            }
        } else if (((AbstractSegmentHandlePart)host).getSegmentParameter() == 0.25 || ((AbstractSegmentHandlePart)host).getSegmentParameter() == 0.75) {
            this.isSegmentDragged = true;
            boolean selectFirstHalve = ((AbstractSegmentHandlePart)host).getSegmentParameter() == 0.25;
            int firstSegmentIndex = ((AbstractSegmentHandlePart)host).getSegmentIndex();
            int secondSegmentIndex = ((AbstractSegmentHandlePart)host).getSegmentIndex() + 1;
            Point firstPoint = this.targetPart.getVisual().getPoint(firstSegmentIndex);
            Point secondPoint = this.targetPart.getVisual().getPoint(secondSegmentIndex);
            Vector direction = new Vector(firstPoint, secondPoint);
            Point midPoint = firstPoint.getTranslated(direction.x / 2.0, direction.y / 2.0);
            Point2D midInScene = this.targetPart.getVisual().localToScene(midPoint.x, midPoint.y);
            Node connectedAnchorage = this.targetPart.getVisual().getAnchor(selectFirstHalve ? firstSegmentIndex : secondSegmentIndex).getAnchorage();
            boolean isConnected = connectedAnchorage != null && connectedAnchorage != this.targetPart.getVisual();
            List<Integer> explicit = bendPolicy.makeExplicit(firstSegmentIndex, secondSegmentIndex);
            Integer firstAnchorHandle = explicit.get(0);
            Integer secondAnchorHandle = explicit.get(1);
            if (isConnected) {
                int connectionIndex = bendPolicy.getBendOperation().getConnectionIndex(selectFirstHalve ? firstAnchorHandle : secondAnchorHandle);
                Point positionInScene = FX2Geometry.toPoint((Point2D)this.targetPart.getVisual().localToScene(Geometry2FX.toFXPoint((Point)bendPolicy.getConnection().getPoint(connectionIndex))));
                if (selectFirstHalve) {
                    firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, positionInScene);
                } else {
                    secondAnchorHandle = bendPolicy.createBefore(secondAnchorHandle, positionInScene);
                }
            }
            if (selectFirstHalve) {
                secondAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                secondAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
            } else {
                firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                firstAnchorHandle = bendPolicy.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)midInScene));
                secondAnchorHandle = secondAnchorHandle + 2;
            }
            bendPolicy.select(firstAnchorHandle);
            bendPolicy.select(secondAnchorHandle);
        } else {
            int connectionIndex = ((AbstractSegmentHandlePart)host).getSegmentIndex() + (((AbstractSegmentHandlePart)host).getSegmentParameter() == 1.0 ? 1 : 0);
            bendPolicy.select(bendPolicy.makeExplicit(connectionIndex, connectionIndex).get(0));
        }
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        boolean bl = this.isInvalid = !this.isBend(e);
        if (this.isInvalid) {
            return;
        }
        this.isPrepared = false;
        this.isSegmentDragged = false;
        this.initialMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.handlePositionInScene = this.initialMouseInScene.getCopy();
        IVisualPart hostPart = this.getHost();
        this.initialSegmentIndex = ((AbstractSegmentHandlePart)hostPart).getSegmentIndex();
        this.initialSegmentParameter = ((AbstractSegmentHandlePart)hostPart).getSegmentParameter();
        this.targetPart = this.determineTargetPart();
        this.storeAndDisableRefreshVisuals(this.targetPart);
        this.bendPolicy = this.determineBendPolicy();
        this.init(this.bendPolicy);
        this.updateHandles();
    }

    protected void updateHandles() {
        if (!(this.targetPart instanceof IContentPart)) {
            return;
        }
        IContentPart targetContentPart = (IContentPart)this.targetPart;
        IHandlePart<? extends Node> replacementHandle = ((SelectionBehavior)this.targetPart.getRoot().getAdapter(SelectionBehavior.class)).updateHandles(targetContentPart, this.handleDistanceComparator, (IHandlePart<? extends Node>)this.getHost());
        if (replacementHandle instanceof AbstractSegmentHandlePart) {
            AbstractSegmentHandlePart segmentData = (AbstractSegmentHandlePart)replacementHandle;
            ((AbstractSegmentHandlePart)this.getHost()).setSegmentIndex(segmentData.getSegmentIndex());
            ((AbstractSegmentHandlePart)this.getHost()).setSegmentParameter(segmentData.getSegmentParameter());
            if (segmentData.getSegmentParameter() == this.initialSegmentParameter) {
                ((HoverModel)((AbstractVisualPart)this.getHost()).getRoot().getViewer().getAdapter(HoverModel.class)).setHover(this.getHost());
            } else if (this.initialSegmentParameter != 0.25 && this.initialSegmentParameter != 0.75 || segmentData.getSegmentParameter() != 0.5 || Math.abs(segmentData.getSegmentIndex() - this.initialSegmentIndex) >= 2) {
                ((HoverModel)((AbstractVisualPart)this.getHost()).getRoot().getViewer().getAdapter(HoverModel.class)).clearHover();
            }
        }
    }
}

