/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.mvc.fx.behaviors.SelectionBehavior;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.AbstractInteractionPolicy;
import org.eclipse.gef.mvc.fx.policies.BendConnectionPolicy;
import org.eclipse.gef.mvc.fx.policies.CursorSupport;
import org.eclipse.gef.mvc.fx.policies.IOnDragPolicy;
import org.eclipse.gef.mvc.fx.policies.SnapSupport;

public class BendOnSegmentDragPolicy
extends AbstractInteractionPolicy
implements IOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private SnapSupport snapSupport = new SnapSupport(this);
    private Point initialMouseInScene;
    private boolean isInvalid = false;
    private boolean isPrepared;
    private BendConnectionPolicy bendPolicy;

    @Override
    public void abortDrag() {
        if (this.isInvalid) {
            return;
        }
        this.rollback(this.bendPolicy);
        this.restoreRefreshVisuals(this.getHost());
        this.updateHandles();
        this.bendPolicy = null;
    }

    protected BendConnectionPolicy determineBendPolicy() {
        return (BendConnectionPolicy)this.getHost().getAdapter(BendConnectionPolicy.class);
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        if (!this.isPrepared) {
            this.isPrepared = true;
            this.prepareBend(this.bendPolicy);
            this.bendPolicy.move(this.initialMouseInScene, this.initialMouseInScene);
        }
        Point newEndPointInScene = this.isPrecise(e) ? new Point(e.getSceneX(), e.getSceneY()) : this.snapSupport.snapToGrid(e.getSceneX(), e.getSceneY());
        this.bendPolicy.move(this.initialMouseInScene, newEndPointInScene);
        this.updateHandles();
    }

    @Override
    public void endDrag(MouseEvent e, Dimension delta) {
        if (this.isInvalid) {
            return;
        }
        this.commit(this.bendPolicy);
        this.restoreRefreshVisuals(this.getHost());
        this.updateHandles();
        this.bendPolicy = null;
    }

    protected BendConnectionPolicy getBendPolicy() {
        return this.bendPolicy;
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public IVisualPart<Connection> getHost() {
        return super.getHost();
    }

    @Override
    public void hideIndicationCursor() {
        this.cursorSupport.restoreCursor();
    }

    protected boolean isBend(MouseEvent event) {
        boolean isInvalid = false;
        if (!(this.getHost().getVisual().getRouter() instanceof OrthogonalRouter)) {
            isInvalid = true;
        } else {
            IVisualPart<Connection> host = this.getHost();
            ObservableList<IContentPart<? extends Node>> selection = ((SelectionModel)host.getRoot().getViewer().getAdapter(SelectionModel.class)).getSelectionUnmodifiable();
            if (selection.size() > 1 && selection.contains(host)) {
                isInvalid = true;
            } else if (!this.getHost().getVisual().isStartConnected() && !this.getHost().getVisual().isEndConnected()) {
                isInvalid = true;
            }
        }
        return !isInvalid;
    }

    protected boolean isPrecise(MouseEvent e) {
        return e.isShortcutDown();
    }

    private void prepareBend(BendConnectionPolicy bendPolicy) {
        Connection connection = bendPolicy.getConnection();
        Polyline polyline = new Polyline((Point[])connection.getPointsUnmodifiable().toArray((Object[])new Point[0]));
        Polyline polylineInScene = (Polyline)NodeUtils.localToScene((Node)connection, (IGeometry)polyline);
        Line[] segmentsInScene = polylineInScene.getCurves();
        double minDistance = -1.0;
        int segmentIndex = -1;
        int i = 0;
        while (i < segmentsInScene.length) {
            Line segment = segmentsInScene[i];
            Point projection = segment.getProjection(this.initialMouseInScene);
            double distance = projection.getDistance(this.initialMouseInScene);
            if (minDistance < 0.0 || distance < minDistance) {
                minDistance = distance;
                segmentIndex = i;
            }
            ++i;
        }
        if (segmentIndex < 0) {
            throw new IllegalStateException("Cannot identify pressed segment.");
        }
        bendPolicy.selectSegment(segmentIndex);
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    @Override
    public void startDrag(MouseEvent e) {
        boolean bl = this.isInvalid = !this.isBend(e);
        if (this.isInvalid) {
            return;
        }
        this.isPrepared = false;
        this.initialMouseInScene = new Point(e.getSceneX(), e.getSceneY());
        this.storeAndDisableRefreshVisuals(this.getHost());
        this.bendPolicy = this.determineBendPolicy();
        this.init(this.bendPolicy);
        this.updateHandles();
    }

    protected void updateHandles() {
        ((SelectionBehavior)this.getHost().getRoot().getAdapter(SelectionBehavior.class)).updateHandles(this.getHost(), null, null);
    }
}

